/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.interpreter.AbstractDataObject;
import com.ibm.xltxe.rnm1.xylem.interpreter.IAppendableStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.IConvertible;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.InterpreterUtilities;
import com.ibm.xltxe.rnm1.xylem.interpreter.StreamUtilities;
import com.ibm.xltxe.rnm1.xylem.interpreter.Tuple;
import com.ibm.xltxe.rnm1.xylem.types.IForkReleaseManaged;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xltxe.rnm1.xylem.xci.prototype.XCIConstruction;
import com.ibm.xml.xci.Cursor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListStream
implements IAppendableStream,
IConvertible,
IForkReleaseManaged {
    protected List<Object> m_list;
    protected boolean m_mustForkAndRelease = false;

    public ListStream() {
        this.m_list = new ArrayList<Object>();
    }

    public ListStream(List l) {
        this.init(l);
    }

    public ListStream(List l, boolean shouldFork) {
        this.init(l, shouldFork);
    }

    protected void init(List l) {
        this.init(l, true);
    }

    protected void init(List l, boolean fork) {
        this.m_list = new ArrayList<Object>();
        for (Object o : l) {
            if (o instanceof IForkReleaseManaged) {
                if (!this.m_mustForkAndRelease) {
                    this.m_mustForkAndRelease |= ((IForkReleaseManaged)o).requiresRelease();
                }
                if (fork) {
                    o = ((IForkReleaseManaged)o).evaluateInstanceFork();
                }
            } else if (o instanceof Cursor) {
                Cursor xci2 = (Cursor)o;
                if (fork) {
                    o = xci2.fork(false, XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_LIMIT_FOR_PROTOTYPE);
                }
                if (!this.m_mustForkAndRelease) {
                    this.m_mustForkAndRelease = ((Cursor)o).requiresRelease();
                }
            }
            this.m_list.add(o);
        }
    }

    public ListStream(Object o) {
        this.m_list = new ArrayList<Object>();
        if (o instanceof IForkReleaseManaged) {
            this.m_mustForkAndRelease = ((IForkReleaseManaged)o).mustForkAndRelease();
            o = ((IForkReleaseManaged)o).evaluateInstanceFork();
        } else if (o instanceof Cursor) {
            Cursor xci2 = (Cursor)o;
            o = xci2.fork(false, XCIConstruction.FEATURES_FOR_PROTOTYPE, XCIConstruction.FEATURES_LIMIT_FOR_PROTOTYPE);
            this.m_mustForkAndRelease = true;
        }
        this.m_list.add(o);
    }

    public Iterator iterator() {
        return new ForkingIterator(this.m_list.iterator());
    }

    @Override
    public void append(Object o, Type bindingType) {
        assert (bindingType != null);
        if (o instanceof ListStream) {
            ListStream ls = (ListStream)o;
            Iterator i = ls.iterator();
            while (i.hasNext()) {
                o = i.next();
                Object fork = bindingType.evaluateVariableFork(o);
                if (fork != o) {
                    this.m_mustForkAndRelease = true;
                }
                this.m_list.add(fork);
            }
        } else if (o instanceof IStream) {
            IStream is2 = (IStream)o;
            Iterator<Object> i = is2.iterator();
            while (i.hasNext()) {
                o = i.next();
                Object fork = bindingType.evaluateVariableFork(o);
                if (fork != o) {
                    this.m_mustForkAndRelease = true;
                }
                this.m_list.add(fork);
            }
        } else {
            Object fork = bindingType.evaluateVariableFork(o);
            if (fork != o) {
                this.m_mustForkAndRelease = true;
            }
            this.m_list.add(fork);
        }
    }

    @Override
    public String toString() {
        InterpreterUtilities utility = new InterpreterUtilities();
        if (this.m_list.size() > 0 && this.m_list.get(0) instanceof AbstractDataObject) {
            return this.m_list.toString();
        }
        if (this.m_list.size() > 0 && this.m_list.get(0) instanceof Tuple && utility.getDebuggerflag()) {
            StringBuffer sb = new StringBuffer();
            for (Tuple tuple : this.m_list) {
                sb.append(tuple.toString());
            }
            return sb.toString();
        }
        if (this.m_list.size() == 0 || this.m_list.get(0) instanceof Character) {
            return new String(this.toCharArray());
        }
        String ans = "[";
        Iterator<Object> iter = this.m_list.iterator();
        boolean bl = true;
        while (iter.hasNext()) {
            boolean bl2;
            Object o = iter.next();
            ans = ans + (bl2 ? "" : ", ") + o.toString();
            bl2 = false;
        }
        ans = ans + "]";
        return ans;
    }

    @Override
    public char[] toCharArray() {
        char[] x = new char[this.m_list.size()];
        Iterator<Object> i = this.m_list.iterator();
        int j = 0;
        while (i.hasNext()) {
            Object o = i.next();
            Character ch = (Character)o;
            x[j++] = ch.charValue();
        }
        return x;
    }

    @Override
    public Object convert(IntegerSettings is2, Type t) {
        if (t instanceof StreamType) {
            Type elementType = ((StreamType)t).getElementType();
            Class javaType = elementType.getJavaType(is2);
            int[] dimensions = new int[]{this.size()};
            Object array = Array.newInstance(javaType, dimensions);
            for (int i = 0; i < this.size(); ++i) {
                Object element2 = this.get(i);
                if (element2 instanceof IConvertible) {
                    element2 = ((IConvertible)element2).convert(is2, elementType);
                }
                Array.set(array, i, element2);
            }
            return array;
        }
        if (t.equals(JavaObjectType.s_javaStringType)) {
            return this.toString();
        }
        throw new XylemError("ERR_SYSTEM", "Can't convert ListStream to " + t);
    }

    @Override
    public int size() {
        return this.m_list.size();
    }

    @Override
    public Object get(int i) {
        return this.m_list.get(i);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IStream)) {
            return false;
        }
        return StreamUtilities.equals(this, (IStream)obj);
    }

    @Override
    public void release() {
        if (this.m_mustForkAndRelease) {
            for (Object x : this.m_list) {
                if (x instanceof IForkReleaseManaged) {
                    ((IForkReleaseManaged)x).release();
                    continue;
                }
                if (!(x instanceof Cursor)) continue;
                ((Cursor)x).release();
            }
        }
    }

    @Override
    public boolean requiresRelease() {
        return this.m_mustForkAndRelease;
    }

    @Override
    public Object evaluateInstanceFork() {
        ArrayList<Object> newlist = new ArrayList<Object>();
        newlist.addAll(this.m_list);
        ListStream ls = new ListStream(newlist);
        return ls;
    }

    @Override
    public boolean mustForkAndRelease() {
        return this.m_mustForkAndRelease;
    }

    public class ForkingIterator
    implements Iterator {
        Iterator m_iter;

        public ForkingIterator(Iterator iter) {
            this.m_iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        public Object next() {
            Object o = this.m_iter.next();
            return XCIConstruction.evalForkIfNeeded(o);
        }

        @Override
        public void remove() {
            this.m_iter.remove();
        }
    }
}

