/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.interpreter.IConvertible;
import com.ibm.xltxe.rnm1.xylem.interpreter.IStream;
import com.ibm.xltxe.rnm1.xylem.interpreter.StreamUtilities;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.Iterator;

public class StringStream
implements IStream,
IConvertible {
    protected String m_string;

    public StringStream(String s) {
        this.m_string = s;
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            int m_i = 0;
            int m_c;
            {
                this.m_c = StringStream.this.m_string.length();
            }

            @Override
            public boolean hasNext() {
                return this.m_i < this.m_c;
            }

            @Override
            public Object next() {
                return new Character(StringStream.this.m_string.charAt(this.m_i++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String toString() {
        return this.m_string;
    }

    @Override
    public char[] toCharArray() {
        return this.m_string.toCharArray();
    }

    @Override
    public Object convert(IntegerSettings is2, Type t) {
        if (t.equals(JavaObjectType.s_javaStringType)) {
            return this.m_string;
        }
        if (t.equals(CharType.s_charType.getStreamType())) {
            return this.toCharArray();
        }
        throw new XylemError("ERR_SYSTEM", "Cannot convert StringStream to " + t);
    }

    @Override
    public int size() {
        return this.m_string.length();
    }

    @Override
    public Object get(int i) {
        return new Character(this.m_string.charAt(i));
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IStream)) {
            return false;
        }
        return StreamUtilities.equals(this, (IStream)obj);
    }

    public int hashCode() {
        return StreamUtilities.hashCode(this);
    }
}

