/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.interpreter;

import com.ibm.xltxe.rnm1.xylem.types.IForkReleaseManaged;
import com.ibm.xml.xci.Cursor;
import com.ibm.xml.xci.Releasable;

public class Tuple
implements IForkReleaseManaged {
    protected Object[] m_values;
    private boolean m_mustForkAndRelease = false;
    private boolean m_containsCursors = false;
    private static final Object BOGUSBADVALUE = new Object(){

        public String toString() {
            return "Evil deleted object!";
        }
    };

    protected Tuple() {
    }

    public Tuple(Object[] values2) {
        this.init(values2, false);
    }

    public Tuple(Object[] values2, boolean shouldFork) {
        this.init(values2, shouldFork);
    }

    protected void init(Object[] values2) {
        this.init(values2, false);
    }

    protected void init(Object[] values2, boolean shouldFork) {
        this.m_values = values2;
        boolean containsCursors = false;
        for (int i = values2.length - 1; i >= 0; --i) {
            Releasable fork;
            Object v = values2[i];
            if (v instanceof Cursor) {
                containsCursors = true;
                if (!shouldFork) continue;
                fork = ((Cursor)v).fork(false);
                if (!this.m_mustForkAndRelease) {
                    this.m_mustForkAndRelease = fork.requiresRelease();
                }
                values2[i] = fork;
                continue;
            }
            if (!(v instanceof IForkReleaseManaged)) continue;
            containsCursors = true;
            if (!shouldFork) continue;
            fork = (IForkReleaseManaged)((IForkReleaseManaged)v).evaluateInstanceFork();
            if (!this.m_mustForkAndRelease) {
                this.m_mustForkAndRelease = fork.requiresRelease();
            }
            values2[i] = fork;
        }
        this.m_containsCursors = containsCursors;
    }

    public Object[] getValues() {
        assert (Tuple.checkForBadValues(this.m_values));
        return this.m_values;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("tuple");
        sb.append("(");
        for (int i = 0; i < this.m_values.length; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.m_values[i] == null ? "<null>" : this.m_values[i].toString());
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Tuple)) {
            return false;
        }
        Tuple t = (Tuple)obj;
        assert (Tuple.checkForBadValues(t.m_values));
        if (t.m_values.length != this.m_values.length) {
            return false;
        }
        for (int i = 0; i < this.m_values.length; ++i) {
            assert (Tuple.isNotReleasedValue(this.m_values[i]));
            if (this.m_values[i].equals(t.m_values[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void release() {
        if (this.m_mustForkAndRelease) {
            for (int i = this.m_values.length - 1; i >= 0; --i) {
                Object x = this.m_values[i];
                if (x instanceof Releasable) {
                    ((Releasable)x).release();
                }
                assert (Tuple.nullArrayValue(this.m_values, i));
            }
            this.m_mustForkAndRelease = false;
        }
    }

    @Override
    public boolean requiresRelease() {
        return this.m_mustForkAndRelease;
    }

    private static final boolean nullArrayValue(Object[] values2, int i) {
        values2[i] = BOGUSBADVALUE;
        return true;
    }

    private static final boolean isNotReleasedValue(Object value2) {
        return value2 != BOGUSBADVALUE;
    }

    private static final boolean checkForBadValues(Object[] values2) {
        for (int i = 0; i < values2.length; ++i) {
            assert (Tuple.isNotReleasedValue(values2[i]));
        }
        return true;
    }

    @Override
    public Object evaluateInstanceFork() {
        if (this.m_containsCursors) {
            Object[] newvalues = (Object[])this.m_values.clone();
            return new Tuple(newvalues, true);
        }
        return this;
    }

    @Override
    public boolean mustForkAndRelease() {
        return this.m_mustForkAndRelease;
    }

    public void setMustForkAndRelease(boolean b) {
        this.m_mustForkAndRelease = b;
    }
}

