/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.LinkedList;

public class DeadLetEliminatorOptimizer
extends Optimizer {
    protected int m_eliminatedLetCount;

    public Instruction optimize(Instruction n2, Function f2) {
        this.m_currentFunction = f2;
        Instruction x = this.optimize(n2);
        this.m_currentFunction = null;
        return x;
    }

    @Override
    public Instruction optimize(Instruction n2) {
        if (this.getCurrentFunction().getBindingEnvironment() == null) {
            return n2;
        }
        this.m_eliminatedLetCount = 0;
        LinkedList<Instruction> ll = new LinkedList<Instruction>();
        ll.add(n2);
        this.markUsedLets(this.getCurrentFunction().getBindingEnvironment(), ll);
        n2 = super.optimize(n2);
        return n2;
    }

    protected void markUsedLets(BindingEnvironment benv, LinkedList queue) {
        while (!queue.isEmpty()) {
            StreamInstruction si;
            LetInstruction leti;
            Instruction n2 = (Instruction)queue.removeFirst();
            while (n2 instanceof LetInstruction) {
                leti = (LetInstruction)n2;
                leti.m_inUse = false;
                n2 = leti.getBody();
            }
            if (n2 instanceof LiteralInstruction) continue;
            if (n2 instanceof IdentifierInstruction) {
                leti = ((IdentifierInstruction)n2).getBinding(benv).getLet();
                if (leti == null || leti.m_inUse) continue;
                leti.m_inUse = true;
                queue.add(leti.getValue());
                continue;
            }
            if (n2 instanceof StreamInstruction && (si = (StreamInstruction)n2).isStoredAsString()) continue;
            int c = n2.getChildInstructionCount();
            ISpecialForm sf = n2 instanceof ISpecialForm ? (ISpecialForm)((Object)n2) : null;
            for (int i = 0; i < c; ++i) {
                Instruction child2 = n2.getChildInstruction(i);
                if (sf != null && sf.isChildInstructionBody(i)) {
                    queue.add(child2);
                    continue;
                }
                if (child2 instanceof IdentifierInstruction) {
                    if (((IdentifierInstruction)child2).getBinding(benv) == null) {
                        System.out.println("Missing binding on function: " + this.m_currentFunction + " for binding " + child2);
                        throw new RuntimeException();
                    }
                    LetInstruction leti2 = ((IdentifierInstruction)child2).getBinding(benv).getLet();
                    if (leti2 == null || leti2.m_inUse) continue;
                    leti2.m_inUse = true;
                    queue.add(leti2.getValue());
                    continue;
                }
                if (child2 instanceof LiteralInstruction && child2 instanceof StreamInstruction) continue;
            }
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction n2, Instruction parent2, int parentIndex) {
        if (!(n2 instanceof LetInstruction)) {
            return n2;
        }
        Instruction blankReturn = null;
        LetInstruction let = (LetInstruction)n2;
        while (true) {
            if (let.getBinding() == null) {
                if (parent2 instanceof LetInstruction) {
                    throw new XylemError("ERR_SYSTEM", "let has null binding (or no dependancy info)" + ((LetInstruction)parent2).getValue() + " " + let.getBody() + " " + parent2.getClass());
                }
                throw new XylemError("ERR_SYSTEM", "let has null binding (or no dependancy info)" + let.getValue() + " " + let.getBody() + " " + parent2.getClass());
            }
            Instruction x = null;
            if (!let.m_inUse) {
                ++this.m_eliminatedLetCount;
                x = let.optimizeOut();
            }
            if (x != null) {
                if (parent2 != null) {
                    parent2.setChildInstruction(parentIndex, x);
                } else {
                    blankReturn = x;
                }
                if (!(x instanceof LetInstruction)) {
                    this.optimizeChildren(x);
                    return blankReturn;
                }
                let = (LetInstruction)x;
                continue;
            }
            Instruction body = let.getBody();
            if (!(body instanceof LetInstruction)) break;
            Instruction value2 = let.getValue();
            Instruction value22 = this.optimizeStep(value2, let, 0);
            if (value22 == null) {
                value22 = value2;
            }
            if (value22 == value2) {
                this.optimizeChildren(value22);
            } else {
                let.setValue(value22);
            }
            parent2 = let;
            parentIndex = 1;
            let = (LetInstruction)body;
        }
        this.optimizeChildren(let);
        return blankReturn;
    }

    public static void eliminateDeadLets(Module prog) {
        prog.optimize(new DeadLetEliminatorOptimizer());
    }

    public static Instruction eliminateDeadLets(Instruction n2, Function f2) {
        DeadLetEliminatorOptimizer dleo = new DeadLetEliminatorOptimizer();
        dleo.m_currentFunction = f2;
        return dleo.optimize(n2);
    }
}

