/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingDependencyInfo;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.TailRecursiveOptimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeadParameterEliminatorOptimizer
extends TailRecursiveOptimizer {
    protected Module m_prog;
    protected HashMap m_originalParameterSets;
    private static final Logger s_logger = LoggerUtil.getLogger(DeadParameterEliminatorOptimizer.class);
    private static final String s_className = DeadParameterEliminatorOptimizer.class.getName();
    boolean m_changed;
    ArrayList m_changedFunctions = new ArrayList();

    protected DeadParameterEliminatorOptimizer(Module prog, HashMap originalParameterSets) {
        this.m_prog = prog;
        this.m_originalParameterSets = originalParameterSets;
    }

    @Override
    protected Instruction optimizeStep2(Instruction n2) {
        if (n2 instanceof FunctionCallInstruction) {
            FunctionCallInstruction fci = (FunctionCallInstruction)n2;
            Function f2 = this.m_prog.getFunction(fci.getFunction());
            Binding[] originalParams = (Binding[])this.m_originalParameterSets.get(f2);
            Function f22 = f2.lookupDerivative(DeadParameterEliminatorOptimizer.class);
            if (f22 != null && fci.getChildInstructionCount() != f22.m_parameters.length) {
                ArrayList<Instruction> params = new ArrayList<Instruction>();
                int c = originalParams.length;
                int j = 0;
                for (int i = 0; i < c && j < f22.m_parameters.length; ++i) {
                    if (f22.m_parameters[j] != originalParams[i]) continue;
                    params.add(fci.getChildInstruction(i));
                    ++j;
                }
                fci.m_parameters = new Instruction[params.size()];
                params.toArray(fci.m_parameters);
                fci.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList<Function>());
                this.m_changed = true;
                return n2;
            }
        }
        return n2;
    }

    @Override
    public void optimizeFunction(Function f2) {
        this.m_changed = false;
        super.optimizeFunction(f2);
        if (this.m_changed) {
            f2.setBody(DeadLetEliminatorOptimizer.eliminateDeadLets(f2.getBody(), f2));
            this.m_changedFunctions.add(f2);
        }
    }

    public static void eliminateDeadParameters(Module prog) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "eliminateDeadParameters", "Starting dead param elimination");
        }
        BuildFunctionCallGraph bfcg = new BuildFunctionCallGraph();
        prog.optimize(bfcg);
        HashMap callers = bfcg.m_callers;
        HashMap bindingDeps = new HashMap();
        final HashMap<Function, Binding[]> originalParameterSets = new HashMap<Function, Binding[]>();
        ArrayList funcs = new ArrayList(prog.getFunctions());
        while (true) {
            Iterator<Function> i = funcs.iterator();
            ArrayList<String> changedFunctions = new ArrayList<String>();
            while (i.hasNext()) {
                Function f3;
                Function f2 = i.next();
                if (prog.m_signature.containsFunction(f2.getName())) continue;
                ArrayList<Binding> newParams = new ArrayList<Binding>();
                ArrayList<Binding> deadParams = new ArrayList<Binding>();
                ArrayList<LiteralInstruction> deadParams2 = new ArrayList<LiteralInstruction>();
                int c = f2.m_parameters.length;
                HashMap bindingDependencies = (HashMap)bindingDeps.get(f2.getName());
                if (bindingDependencies == null) {
                    bindingDependencies = new HashMap();
                    f2.determineDataDependencies(f2.m_parameters, bindingDependencies);
                    bindingDeps.put(f2.getName(), bindingDependencies);
                }
                block2: for (int j = 0; j < c; ++j) {
                    List deps = (List)bindingDependencies.get(f2.m_parameters[j]);
                    if (deps == null || deps.isEmpty()) continue;
                    Iterator k = deps.iterator();
                    while (k.hasNext()) {
                        BindingDependencyInfo ii = (BindingDependencyInfo)k.next();
                        if (ii.getParent() instanceof FunctionCallInstruction) {
                            FunctionCallInstruction fci = (FunctionCallInstruction)ii.getParent();
                            int index2 = fci.getChildInstructionIndex(ii.m_identifierInstruction);
                            if (index2 == -1) {
                                k.remove();
                                continue;
                            }
                            if (fci.getFunction().equals(f2.getName())) continue;
                            newParams.add(f2.m_parameters[j]);
                            continue block2;
                        }
                        newParams.add(f2.m_parameters[j]);
                        continue block2;
                    }
                    if (deps.isEmpty()) continue;
                    deadParams.add(f2.m_parameters[j]);
                    deadParams2.add(new LiteralInstruction(f2.m_parameters[j].getBindingType(), null));
                }
                if (newParams.size() == c || (f3 = f2.lookupDerivative(DeadParameterEliminatorOptimizer.class)) != null && f3.m_parameters.length == newParams.size()) continue;
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "eliminateDeadParameters", "shrinking " + f2.getName());
                }
                originalParameterSets.put(f2, f2.m_parameters);
                f2.registerDerivative(DeadParameterEliminatorOptimizer.class, f2);
                f2.setMemoizeResult(f2.getMemoizeResult());
                f2.m_parameters = new Binding[newParams.size()];
                newParams.toArray(f2.m_parameters);
                Instruction[] x = new Instruction[deadParams2.size()];
                deadParams2.toArray(x);
                Binding[] y = new Binding[deadParams2.size()];
                deadParams.toArray(y);
                new TailRecursiveOptimizer(){

                    @Override
                    protected Instruction optimizeStep2(Instruction n2) {
                        FunctionCallInstruction fci;
                        if (n2 instanceof FunctionCallInstruction && (fci = (FunctionCallInstruction)n2).getFunction().equals(this.m_currentFunction.getOriginalFunction().getName())) {
                            Function f2 = this.m_currentFunction.getOriginalFunction();
                            Function f22 = this.m_currentFunction;
                            ArrayList<Instruction> params = new ArrayList<Instruction>();
                            Binding[] originalParams = (Binding[])originalParameterSets.get(f2);
                            int c = originalParams.length;
                            int j = 0;
                            for (int i = 0; i < c && j < f22.m_parameters.length; ++i) {
                                if (originalParams[i] != f22.m_parameters[j]) continue;
                                params.add(fci.getChildInstruction(i));
                                ++j;
                            }
                            fci.m_parameters = new Instruction[params.size()];
                            params.toArray(fci.m_parameters);
                            fci.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList<Function>());
                            return fci;
                        }
                        return n2;
                    }
                }.optimizeFunction(f2);
                changedFunctions.add(f2.getName());
                if (f3 == null) continue;
                f3.registerDerivative(DeadParameterEliminatorOptimizer.class, f2);
            }
            if (changedFunctions.size() == 0) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "eliminateDeadParameters", "finished dead param elimination");
                }
                return;
            }
            DeadParameterEliminatorOptimizer dpeo = new DeadParameterEliminatorOptimizer(prog, originalParameterSets);
            HashSet todo = new HashSet();
            for (String name2 : changedFunctions) {
                Collection deps = (Collection)callers.get(name2);
                if (deps == null) continue;
                todo.addAll(deps);
            }
            for (String name2 : todo) {
                dpeo.optimizeFunction(prog.getFunction(name2));
            }
            funcs = dpeo.m_changedFunctions;
        }
    }

    static class BuildFunctionCallGraph
    extends TailRecursiveOptimizer {
        protected HashMap m_callers = new HashMap();

        BuildFunctionCallGraph() {
        }

        @Override
        protected Instruction optimizeStep2(Instruction n2) {
            if (n2 instanceof FunctionCallInstruction) {
                FunctionCallInstruction fci = (FunctionCallInstruction)n2;
                HashSet<String> set2 = (HashSet<String>)this.m_callers.get(fci.getFunction());
                if (set2 == null) {
                    set2 = new HashSet<String>();
                    this.m_callers.put(fci.getFunction(), set2);
                }
                set2.add(this.getCurrentFunction().getName());
            }
            return n2;
        }
    }
}

