/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.PostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FindFreeBindings
extends PostOrderOptimizer {
    BindingEnvironment m_benv = new BindingEnvironment();
    private HashSet m_freeBindings = new HashSet();

    protected FindFreeBindings(BindingEnvironment benv) {
        this.m_benv = benv;
    }

    public static Set findFreeBindings(Instruction n2, BindingEnvironment benv) {
        FindFreeBindings ffv = new FindFreeBindings(benv);
        ffv.optimize(n2);
        return ffv.getFreeBindings();
    }

    public HashSet getFreeBindings() {
        return this.m_freeBindings;
    }

    @Override
    public Instruction optimize(Instruction n2) {
        this.m_freeBindings.clear();
        return super.optimize(n2);
    }

    @Override
    protected Instruction optimizeStep(Instruction n2, Instruction parent2, int parentIndex) {
        if (n2 instanceof IdentifierInstruction) {
            this.m_freeBindings.add(((IdentifierInstruction)n2).getBinding(this.m_benv));
        }
        return n2;
    }

    @Override
    protected void optimizeChildren(Instruction n2) {
        HashSet freeBindings2 = null;
        int c = n2.getChildInstructionCount();
        freeBindings2 = c < 2 ? this.m_freeBindings : new HashSet();
        for (int i = 0; i < c; ++i) {
            Instruction n3 = n2.getChildInstruction(i);
            this.optimizeChildren(n3);
            Instruction n4 = this.optimizeStep(n3, n2, i);
            if (n2 instanceof ISpecialForm && ((ISpecialForm)((Object)n2)).isChildInstructionBody(i)) {
                IBinding[] bb = ((ISpecialForm)((Object)n2)).getChildInstructionBindings(i);
                if (bb == null) {
                    throw new XylemError("ERR_SYSTEM", "!" + i + " " + n2);
                }
                this.m_freeBindings.removeAll(Arrays.asList(bb));
            }
            if (freeBindings2 == this.m_freeBindings) continue;
            freeBindings2.addAll(this.m_freeBindings);
            this.m_freeBindings.clear();
        }
        this.m_freeBindings = freeBindings2;
    }
}

