/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ScopedPostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class FindFreeVariables
extends ScopedPostOrderOptimizer {
    private HashSet<Object> m_freeVars = new HashSet();
    private LinkedList<HashSet<Object>> m_freeVarsStack = new LinkedList();

    protected FindFreeVariables() {
    }

    public static Set<Object> findFreeVariables(Instruction n2) {
        FindFreeVariables ffv = new FindFreeVariables();
        ffv.optimize(n2);
        return ffv.getFreeVars();
    }

    public static Set<IBinding> findFreeBindings(Instruction n2, BindingEnvironment benv) {
        FindFreeVariables ffv = new FindFreeVariables();
        ffv.optimize(n2);
        HashSet<IBinding> bb = new HashSet<IBinding>();
        for (Object o : ffv.getFreeVars()) {
            IBinding b = benv.getVariableBinding(o);
            if (b == null) {
                throw new XylemError("ERR_SYSTEM", "unbound variable " + o);
            }
            bb.add(b);
        }
        return bb;
    }

    public HashSet<Object> getFreeVars() {
        return this.m_freeVars;
    }

    @Override
    protected void endOptimize(Instruction n2) {
        if (this.m_freeVarsStack.size() != 0) {
            throw new XylemError("ERR_SYSTEM", "!!!" + this.m_freeVarsStack.size());
        }
    }

    @Override
    protected void beginOptimize(Instruction n2) {
        this.m_freeVars.clear();
        this.m_freeVarsStack.clear();
    }

    @Override
    protected void preOrderStep(Instruction n2, Instruction parent2, int parentIndex) {
        if (parent2 instanceof ISpecialForm && ((ISpecialForm)((Object)parent2)).isChildInstructionBody(parentIndex)) {
            this.m_freeVarsStack.add(this.m_freeVars);
            this.m_freeVars = new HashSet();
        }
    }

    protected void addVars(Instruction n2, Instruction parent2, int parentIndex) {
        if (n2 instanceof IdentifierInstruction) {
            this.m_freeVars.add(((IdentifierInstruction)n2).getVariable());
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction n2, Instruction parent2, int parentIndex) {
        this.addVars(n2, parent2, parentIndex);
        this.removeVars(n2, parent2, parentIndex);
        return n2;
    }

    protected void removeVars(Instruction n2, Instruction parent2, int parentIndex) {
        if (parent2 instanceof ISpecialForm && ((ISpecialForm)((Object)parent2)).isChildInstructionBody(parentIndex)) {
            IBinding[] bb = ((ISpecialForm)((Object)parent2)).getChildInstructionBindings(parentIndex);
            if (bb == null) {
                throw new XylemError("ERR_SYSTEM", "!" + parentIndex + " " + n2);
            }
            this.m_freeVars.removeAll(Arrays.asList(Binding.getNames(bb)));
            HashSet<Object> outer = this.m_freeVarsStack.removeLast();
            outer.addAll(this.m_freeVars);
            this.m_freeVars = outer;
        }
    }
}

