/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import java.util.LinkedList;

public class FlattenStreamOptimizer
extends Optimizer {
    private static final int MIN_STRING_COALESCE_SIZE = 5;
    private static final boolean COLAESCE_STRINGS_CODE = true;
    private static final boolean COLAESCE_STRINGS = true;

    protected void collectStream(StreamInstruction si, LinkedList list, LetChainBuilder lcb, StringBuffer stringInProgress) {
        if (si.isString() && stringInProgress != null) {
            stringInProgress.append(si.getStringContent());
            return;
        }
        int c = si.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            Instruction n1;
            Instruction n2 = n1 = si.getChildInstruction(i);
            if (n1 instanceof IdentifierInstruction && (n2 = NavigationUtilities.resolveReducedIdentifier(n1, this.getCurrentFunction().m_bindingEnvironment)) == null) {
                n2 = n1;
            }
            if (n2 instanceof StreamInstruction) {
                StreamInstruction si2 = (StreamInstruction)n2;
                this.collectStream(si2, list, lcb, stringInProgress);
                continue;
            }
            if (n2 instanceof LiteralInstruction) {
                if (stringInProgress != null) {
                    stringInProgress.append(((Character)((LiteralInstruction)n2).getValue()).charValue());
                    continue;
                }
                list.add(n2);
                continue;
            }
            this.coalesceString(stringInProgress, list, lcb);
            list.add(n1);
        }
    }

    private void coalesceString(StringBuffer stringInProgress, LinkedList list, LetChainBuilder lcb) {
        if (stringInProgress != null && stringInProgress.length() > 0) {
            if (stringInProgress.length() > 5) {
                list.add(lcb.bind(StreamInstruction.charStreamLiteral(stringInProgress.toString())));
            } else {
                for (int i = 0; i < stringInProgress.length(); ++i) {
                    list.add(LiteralInstruction.charLiteral(stringInProgress.charAt(i)));
                }
            }
            stringInProgress.setLength(0);
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction n2, Instruction parent2, int parentIndex) {
        if (n2 instanceof LetInstruction && ((LetInstruction)n2).getValue() instanceof StreamInstruction) {
            LetInstruction li = (LetInstruction)n2;
            LetChainBuilder lcb = null;
            lcb = new LetChainBuilder();
            Instruction si = this.optimizeStream((StreamInstruction)li.getValue(), lcb);
            if (si == li.getValue()) {
                return n2;
            }
            BindingEnvironment benv = this.getCurrentFunction().getBindingEnvironment();
            TypeEnvironment tenv = this.getCurrentFunction().getTypeEnvironment();
            LinkedList<Function> ll = new LinkedList<Function>();
            li.setValue(si);
            LetInstruction n22 = li = (LetInstruction)lcb.packageUp(li);
            while (li != n2) {
                li.getValue().typeCheckReduced(tenv, benv, ll);
                benv.setVariableBinding(li);
                li = (LetInstruction)li.getBody();
            }
            if (parent2 != null) {
                parent2.setChildInstruction(parentIndex, n22);
            } else {
                this.getCurrentFunction().setBody(n22);
            }
        }
        return n2;
    }

    protected Instruction optimizeStream(StreamInstruction si, LetChainBuilder lcb) {
        if (si.isString()) {
            return si;
        }
        int c = si.getChildInstructionCount();
        if (c == 1) {
            Instruction child0 = si.getChildInstruction(0);
            try {
                if (this.resolveType(child0).equals(this.resolveType(si))) {
                    return child0;
                }
            }
            catch (NullPointerException e) {
                return si;
            }
        }
        LinkedList list = new LinkedList();
        StringBuffer stringInProgress = null;
        if (si.getType(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment()).equals(CharType.s_charType.getStreamType())) {
            stringInProgress = new StringBuffer();
        }
        this.collectStream(si, list, lcb, stringInProgress);
        this.coalesceString(stringInProgress, list, lcb);
        StreamInstruction si2 = new StreamInstruction(si.getElementType(), list);
        Instruction.propagateInfo(si, si2);
        return si2;
    }
}

