/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xml.ras.LoggerUtil;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FunctionInfo
extends Optimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(FunctionInfo.class);
    private static final String s_className = FunctionInfo.class.getName();
    private Map m_info = new TreeMap(new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof Class) {
                Class c0 = (Class)arg0;
                if (arg1 instanceof Class) {
                    Class c1 = (Class)arg1;
                    return c0.getName().compareTo(c1.getName());
                }
            }
            return 0;
        }
    });
    private int m_bindings = 0;

    @Override
    public void optimizeFunction(Function f2) {
        this.m_info.clear();
        this.m_bindings = 0;
        super.optimizeFunction(f2);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "optimizeFunction", "FUNCTION: " + f2.getName() + "\nbindings=" + this.m_bindings);
            for (Class c : this.m_info.keySet()) {
                s_logger.logp(Level.FINEST, s_className, "optimizeFunction", " " + this.m_info.get(c) + " " + c.getName().substring(c.getName().lastIndexOf(46)));
            }
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction n2) {
        Integer i;
        if (n2 instanceof ISpecialForm) {
            ISpecialForm sf = (ISpecialForm)((Object)n2);
            for (int i2 = 0; i2 < n2.getChildInstructionCount(); ++i2) {
                IBinding[] bb = sf.getChildInstructionBindings(i2);
                if (bb == null) continue;
                this.m_bindings += bb.length;
            }
        }
        i = (i = (Integer)this.m_info.get(n2.getClass())) != null ? new Integer(i + 1) : new Integer(1);
        this.m_info.put(n2.getClass(), i);
        return n2;
    }
}

