/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.PureInstruction;
import java.util.HashSet;

public class ImperitivityOptimizer
extends Optimizer {
    private HashSet m_impureFunctions = new HashSet();
    private HashSet m_inProcessFunctions = new HashSet();

    @Override
    public Instruction optimize(Instruction n2) {
        return n2;
    }

    private boolean isProvablyPure(Function f2) {
        if (!f2.isImpure()) {
            return true;
        }
        if (this.m_impureFunctions.contains(f2)) {
            return false;
        }
        if (this.m_inProcessFunctions.contains(f2)) {
            return false;
        }
        Instruction body = f2.getBody();
        this.m_inProcessFunctions.add(f2);
        boolean b = this.isProvablyPure(body);
        if (b) {
            f2.setImpurity(false);
        } else {
            this.m_impureFunctions.add(f2);
        }
        this.m_inProcessFunctions.remove(f2);
        return b;
    }

    private boolean isProvablyPure(Instruction instr) {
        if (instr instanceof PureInstruction) {
            return true;
        }
        if (instr instanceof IImperativeInstruction) {
            return false;
        }
        int c = instr.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            Instruction child2 = instr.getChildInstruction(i);
            if (this.isProvablyPure(child2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void optimizeFunction(Function f2) {
        this.isProvablyPure(f2);
    }
}

