/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xml.ras.LoggerUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class InlineFunctions
extends Optimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(InlineFunctions.class);
    private static final String s_className = InlineFunctions.class.getName();
    private LinkedList m_inlineStack = new LinkedList();
    private Module m_module;

    protected InlineFunctions(Module m) {
        this.m_module = m;
    }

    @Override
    protected Instruction optimizeStep(Instruction n2) {
        FunctionCallInstruction fci;
        Function f2;
        if (n2 instanceof FunctionCallInstruction && (f2 = this.getFunction(fci = (FunctionCallInstruction)n2)) != null && this.shouldInline(f2, this.m_inlineStack)) {
            this.m_inlineStack.addLast(f2);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.m_inlineStack.size(); ++i) {
                    sb.append(' ');
                }
                sb.append("inlining call to ");
                sb.append(f2.getName());
                s_logger.logp(Level.FINEST, s_className, "optimizeStep", sb.toString());
            }
            Instruction x = LetChainBuilder.inlinebody(fci.m_parameters, f2.m_parameters, f2.getBody());
            x = this.optimize(x);
            this.m_inlineStack.removeLast();
            return new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), x, null);
        }
        return n2;
    }

    private Function getFunction(FunctionCallInstruction fci) {
        String fName = fci.getFunction();
        return this.m_module.getFunction(fName);
    }

    protected abstract boolean shouldInline(Function var1, List var2);

    public static class ByParamType
    extends InlineFunctions {
        private Type m_type;
        private int m_limit;

        public ByParamType(Type t, int limit, Module m) {
            super(m);
            this.m_type = t;
            this.m_limit = limit;
            if (this.m_type == null) {
                throw new RuntimeException();
            }
        }

        @Override
        protected boolean shouldInline(Function f2, List inlineStack) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "shouldInline", "inlining call to " + f2.getName() + " ?");
            }
            if (inlineStack.size() > this.m_limit) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                    s_logger.logp(Level.FINEST, s_className, "shouldInline", " no -- too deep.");
                }
                return false;
            }
            for (int i = 0; i < f2.m_parameters.length; ++i) {
                if (!this.m_type.equals(f2.m_parameters[i].getBindingType())) continue;
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                    s_logger.logp(Level.FINEST, s_className, "shouldInline", "yes");
                }
                return true;
            }
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "shouldInline", "no -- no params of type " + this.m_type);
            }
            return false;
        }
    }
}

