/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.AutomatonInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.LetLetOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.optimizers.RenameFunctions;
import com.ibm.xltxe.rnm1.xylem.optimizers.RepeatedExpressionOptimizer;
import com.ibm.xltxe.rnm1.xylem.utils.HiddenOptions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class InliningOptimizer
extends Optimizer {
    public static final String INLINE_OPTION = "inline";
    public static final boolean sInline = !HiddenOptions.optionValueIs("inline", "off");
    public static final String INLINESPECULATIVE_OPTION = "speculativeInline";
    public static final boolean sInlineSpeculative = HiddenOptions.wasSpecified("speculativeInline") && !HiddenOptions.optionValueIs("speculativeInline", "off");
    public static final String SHOWINLINESPECULATIVE_OPTION = "showSpeculativeInline";
    public static final boolean sInlineShowSpeculative = HiddenOptions.wasSpecified("showSpeculativeInline") && !HiddenOptions.optionValueIs("showSpeculativeInline", "off");
    public static boolean doInline = sInline;
    protected Module m_rtLib = null;
    protected String m_rtLibModuleName = "";
    boolean aggressiveInline = false;
    final HashSet<String> functionsCalled;
    boolean abandonHope;
    int thisInstrCount;
    final int depth;
    int originalInstructionCount = 0;
    public static int highestInstructionCount = 0;
    public static boolean reportMaxFunctionSize = false;
    public static final int MINIMAL_INLINE_INSTRUCTION_COUNT = 10;
    public static final int ABANDON_HOPE_INSTRUCTION_COUNT = 200;
    public static final int DONT_EVEN_TRY_INSTRUCTION_COUNT = 20000;
    public static final long MAX_TIME_BEFORE_AGRESSIVE_SHUTOFF = 2000L;
    public static final long MAX_TIME_BEFORE_INLINE_SHUTOFF = 2000L;
    final long startTime;
    static final boolean reportExtraInfo = false;

    public InliningOptimizer(boolean aggressiveInline, HashSet<String> functionsCalled, int depth, long startTime) {
        this.aggressiveInline = aggressiveInline;
        this.functionsCalled = functionsCalled;
        this.abandonHope = false;
        this.thisInstrCount = 0;
        this.isTypeReparing = true;
        this.depth = depth;
        this.startTime = startTime < 0L ? System.currentTimeMillis() : startTime;
    }

    public void setRuntimeLibrary(Module rtLib) {
        this.m_rtLib = rtLib;
        this.m_rtLibModuleName = rtLib.getName();
    }

    @Override
    protected Instruction optimizeStep(Instruction n2) {
        NaryPrimopInstruction fci;
        if (this.timeMaxedOut(2000L)) {
            this.abandonHope = true;
            return n2;
        }
        if (this.aggressiveInline && this.abandonHope) {
            return n2;
        }
        ++this.thisInstrCount;
        if (!(n2 instanceof FunctionCallInstruction)) {
            return n2;
        }
        Function f2 = this.getCurrentFunction();
        TypeEnvironment tenv = f2.getTypeEnvironment();
        BindingEnvironment benv = f2.getBindingEnvironment();
        Function called = null;
        Instruction[] params = null;
        Instruction body = null;
        if (n2 instanceof FunctionCallInstruction) {
            fci = (FunctionCallInstruction)n2;
            if (((FunctionCallInstruction)fci).getFunction().contains("xslt2$report-error")) {
                return n2;
            }
            called = this.getCurrentModule().getFunction(((FunctionCallInstruction)fci).getFunction());
            params = ((FunctionCallInstruction)fci).getParameters();
            body = called.getBody();
        } else if (n2 instanceof ModuleFunctionCallInstruction) {
            fci = (ModuleFunctionCallInstruction)n2;
            called = this.resolveModuleFunctionCall(((ModuleFunctionCallInstruction)fci).getModule(), ((ModuleFunctionCallInstruction)fci).getFunction());
            if (called == null) {
                return n2;
            }
            params = ((ModuleFunctionCallInstruction)fci).getParameters();
            RenameFunctions renamer = new RenameFunctions(this.m_rtLib);
            body = renamer.optimize(called.getBody().cloneWithoutTypeInformation());
        } else {
            return n2;
        }
        Instruction bodyx = this.getBodyForInlineMaybe(f2, tenv, benv, called, params, body);
        if (bodyx != null) {
            f2.m_justInlined = true;
            Instruction newSection = this.doInline(tenv, benv, called, params, bodyx);
            this.setFunctionNeedsTypecheck(true);
            return newSection;
        }
        return n2;
    }

    private Instruction doInline(TypeEnvironment tenv, BindingEnvironment benv, Function called, Instruction[] params, Instruction body) {
        assert (body != null);
        Instruction x = OptimizerUtilities.replaceDeconstructionBindings(params, called.m_parameters, body);
        HashMap map2 = new HashMap();
        x = x.assignNewNames(map2);
        if (benv != null) {
            x.typeCheckReduced(tenv, benv, new LinkedList<Function>());
        }
        return x;
    }

    private int getInstrCount(Function f2) {
        InstructionCountAnalyzer analyzer = new InstructionCountAnalyzer();
        analyzer.optimizeFunction(f2);
        return analyzer.count;
    }

    private Instruction getBodyForInlineMaybe(Function f2, TypeEnvironment tenv, BindingEnvironment benv, Function called, Instruction[] fciArgs, Instruction body) {
        boolean hasInline = false;
        if (!(f2.getBody() instanceof AutomatonInstruction)) {
            if (f2.m_parameters.length == 1) {
                hasInline = this.mergeCandidateTruth(f2);
            } else {
                HashSet<String> set2 = new HashSet<String>();
                f2.getBody().accumulateFunctionsCalled(set2);
                set2.remove(f2.getName());
                if (set2.isEmpty()) {
                    hasInline = this.mergeCandidateTruth(f2);
                }
            }
            if (hasInline) {
                if (!sInlineSpeculative || this.timeMaxedOut(2000L)) {
                    this.abandonHope = true;
                    return body;
                }
                InliningOptimizer inliner = new InliningOptimizer(true, this.functionsCalled, this.depth + 1, this.startTime);
                Function called2 = called.cloneFunctionForFixup("%%Inline%%0%%", false, true, false);
                called2.setModule(called.getModule());
                inliner.optimizeFunction(called2);
                if (!inliner.abandonHope) {
                    body = called2.getBody();
                }
            } else if (sInlineSpeculative && !hasInline) {
                if (this.timeMaxedOut(2000L)) {
                    this.abandonHope = true;
                    return body;
                }
                if ((body = this.attemptAggressiveSpeculativeInline(tenv, benv, called, fciArgs, body)) != null) {
                    hasInline = true;
                }
            } else {
                body = null;
            }
        }
        return hasInline ? body : null;
    }

    private boolean timeMaxedOut(long timeAllowed) {
        return System.currentTimeMillis() - this.startTime > timeAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Instruction attemptAggressiveSpeculativeInline(TypeEnvironment tenv, BindingEnvironment benv, Function called, Instruction[] fciArgs, Instruction body) {
        String key2;
        boolean shouldInline = false;
        assert (body != null);
        if (called.getMemoizeResult()) {
            return null;
        }
        Function origOrig = called.getOriginalFunction();
        String string2 = key2 = origOrig != null ? origOrig.getName() : called.getName();
        if (this.functionsCalled.contains(key2)) {
            return null;
        }
        Type[] types2 = new Type[fciArgs.length];
        boolean hasSpecializedType = this.collectSpecializedArgTypes(tenv, benv, called, fciArgs, types2);
        if (!hasSpecializedType) {
            return null;
        }
        Function called2 = called.cloneFunctionForFixup("%%Inline%%1%%", false, true, false);
        called2.setInlineHint(called.getInlineHint());
        called2.setMemoizeResult(called.getMemoizeResult());
        for (int i = 0; i < types2.length; ++i) {
            called2.m_parameters[i].setType(types2[i]);
        }
        Module module = this.tryHardToGetGoodModule(called);
        if (null == module) {
            return null;
        }
        boolean didTypecheck = this.doTypeCheck(module, called2);
        if (!didTypecheck) {
            return null;
        }
        try {
            this.functionsCalled.add(key2);
            if (!this.optimizationRegimenForShrinkage(called2, module)) {
                Instruction instruction2 = null;
                return instruction2;
            }
            this.reportInlineAttempt(key2, called, called2);
            int instrCountNew = this.getInstrCount(called2);
            if (instrCountNew <= 10) {
                int instrCountOrig = this.getInstrCount(called);
                if (instrCountNew < instrCountOrig) {
                    InliningOptimizer inliner = new InliningOptimizer(true, this.functionsCalled, this.depth + 1, this.startTime);
                    Function called3 = called2.cloneFunctionForFixup("%%Inline%%2%%", false, true, false);
                    called3.setModule(module);
                    inliner.optimizeFunction(called3);
                    body = inliner.abandonHope ? called3.getBody() : called2.getBody();
                    shouldInline = true;
                    this.thisInstrCount += instrCountNew - 1;
                    if (!this.aggressiveInline && sInlineShowSpeculative) {
                        System.out.println("DEBUG: Specialized Inlining: " + key2 + " is " + instrCountOrig + " to reduce to " + instrCountNew + (this.aggressiveInline ? ", thisInstrCount=" + this.thisInstrCount : ""));
                    }
                } else if (this.aggressiveInline && this.thisInstrCount > 200) {
                    this.abandonHope = true;
                }
            } else if (this.aggressiveInline && this.thisInstrCount > 200) {
                this.abandonHope = true;
            }
        }
        catch (ClassNotFoundException e) {
            assert (false);
        }
        catch (IllegalAccessException e) {
            assert (false);
        }
        catch (InstantiationException e) {
            assert (false);
        }
        finally {
            this.functionsCalled.remove(key2);
        }
        module.cleanInlineStubs();
        return shouldInline ? body : null;
    }

    private void reportInlineAttempt(String key2, Function original, Function reducedMaybe) {
    }

    private boolean optimizationRegimenForShrinkage(Function f2, Module module) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<Optimizer> xpathStepOptimizerClass = this.callOptimizerByReflection(f2, "com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XPathStepOptimizer");
        boolean didTypecheck2 = this.doTypeCheck(module, f2);
        if (!didTypecheck2) {
            return false;
        }
        this.callOptimizerByReflection(f2, "com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.XDMSequenceOptimizer");
        didTypecheck2 = this.doTypeCheck(module, f2);
        if (!didTypecheck2) {
            return false;
        }
        Optimizer xpathStepOptimizer2 = xpathStepOptimizerClass.newInstance();
        xpathStepOptimizer2.optimizeFunction(f2);
        DeadLetEliminatorOptimizer deadLetOptimizer = new DeadLetEliminatorOptimizer();
        deadLetOptimizer.optimizeFunction(f2);
        this.callOptimizerByReflection(f2, "com.ibm.xltxe.rnm1.xtq.xslt.xylem.optimizers.StringEqualityOptimizer");
        RepeatedExpressionOptimizer repeatedExpressionOptimizer = new RepeatedExpressionOptimizer();
        ((Optimizer)repeatedExpressionOptimizer).optimizeFunction(f2);
        LetLetOptimizer letLetOptimizer = new LetLetOptimizer();
        ((Optimizer)letLetOptimizer).optimizeFunction(f2);
        didTypecheck2 = this.doTypeCheck(module, f2);
        if (!didTypecheck2) {
            return false;
        }
        Optimizer xpathStepOptimizer3 = xpathStepOptimizerClass.newInstance();
        xpathStepOptimizer3.optimizeFunction(f2);
        return true;
    }

    private Module tryHardToGetGoodModule(Function called) {
        Module module = called.getModule();
        if (module == null) {
            module = called.hasBeenTypeChecked() ? called.getTypeEnvironment().getModule() : null;
        }
        return module;
    }

    private boolean collectSpecializedArgTypes(TypeEnvironment tenv, BindingEnvironment benv, Function called, Instruction[] fciArgs, Type[] types2) {
        boolean hasSpecializedType = false;
        for (int i = 0; i < fciArgs.length; ++i) {
            Instruction fciArg = fciArgs[i];
            Type fciArgType = fciArg.getCachedType();
            if (fciArgType == null) {
                hasSpecializedType = false;
                break;
            }
            Type calledParamType = called.m_parameters[i].getBindingType(tenv, benv);
            if (fciArgType.hasXMLSubtype() && !fciArgType.semanticallyEquals(calledParamType, true)) {
                hasSpecializedType = true;
            }
            types2[i] = fciArgType;
        }
        return hasSpecializedType;
    }

    private Class<Optimizer> callOptimizerByReflection(Function called2, String name2) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<Optimizer> optClass = Class.forName(name2);
        Optimizer xpathStepOptimizer = (Optimizer)optClass.newInstance();
        xpathStepOptimizer.optimizeFunction(called2);
        return optClass;
    }

    private boolean mergeCandidateTruth(Function f2) {
        return this.aggressiveInline || f2.getInlineHint();
    }

    private Function resolveModuleFunctionCall(String called_module, String called_function) {
        if (!called_module.equals(this.m_rtLibModuleName)) {
            return null;
        }
        if (!called_module.equals(this.m_rtLibModuleName)) {
            return null;
        }
        Module m = this.m_rtLib;
        if (m == null) {
            return null;
        }
        return m.getPublicFunction(called_function);
    }

    @Override
    public void optimizeFunction(Function f2) {
        if (this.timeMaxedOut(2000L)) {
            this.abandonHope = true;
            return;
        }
        this.originalInstructionCount = this.getInstrCount(f2);
        if (this.originalInstructionCount > 20000) {
            this.abandonHope = true;
            return;
        }
        this.abandonHope = false;
        if (reportMaxFunctionSize && !this.aggressiveInline && this.originalInstructionCount > highestInstructionCount) {
            highestInstructionCount = this.originalInstructionCount;
            System.out.println("Instruction count for " + f2.getName() + " is " + this.originalInstructionCount);
        }
        super.optimizeFunction(f2);
        if (f2.m_justInlined) {
            f2.m_justInlined = false;
        }
    }

    public class InstructionCountAnalyzer
    extends Optimizer {
        public int count = 0;

        @Override
        protected Instruction optimizeStep(Instruction n2) {
            ++this.count;
            return super.optimizeStep(n2);
        }
    }
}

