/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.PostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.optimizers.ReducedForm;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LambdaOptimizer
extends PostOrderOptimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(LambdaOptimizer.class);
    private static final String s_className = LambdaOptimizer.class.getName();
    protected HashMap m_cache = new HashMap();
    protected boolean m_doLoopInvariantOptimization = true;

    public void disableLoopInvariantOptimization() {
        this.m_doLoopInvariantOptimization = false;
    }

    @Override
    protected Instruction optimizeStep(Instruction n2) {
        if (n2 instanceof LambdaInstruction) {
            LambdaInstruction cnlfi = (LambdaInstruction)n2;
            BindingEnvironment benv = this.getCurrentFunction().getBindingEnvironment();
            TypeEnvironment tenv = this.getCurrentFunction().getTypeEnvironment();
            Instruction replacement = cnlfi;
            if (this.m_doLoopInvariantOptimization) {
                Instruction body;
                Instruction originalBodyForDependencies = body = cnlfi.getBody();
                boolean stillReduced = true;
                ArrayList<LetInstruction> toKeep = new ArrayList<LetInstruction>();
                ArrayList<LetInstruction> moveOutside = new ArrayList<LetInstruction>();
                while (body instanceof LetInstruction) {
                    LetInstruction let = (LetInstruction)body;
                    if (let.getValue().isStatic(benv)) {
                        toKeep.add(let);
                        moveOutside.add(let);
                        stillReduced = false;
                    } else {
                        Set set2 = NavigationUtilities.resolveFreeBindingsForReducedExpression(let.getValue(), originalBodyForDependencies, benv);
                        List l = cnlfi.getBindings();
                        int c = l.size();
                        l.removeAll(set2);
                        if (l.size() == c) {
                            moveOutside.add(let);
                        } else {
                            toKeep.add(let);
                        }
                    }
                    body = let.getBody();
                }
                cnlfi.setBody(OptimizerUtilities.reconstructLets(body, toKeep, false));
                if (!stillReduced) {
                    cnlfi = (LambdaInstruction)cnlfi.cloneWithoutTypeInformation();
                }
                replacement = OptimizerUtilities.reconstructLets(cnlfi, moveOutside, !stillReduced);
                if (!stillReduced) {
                    replacement = ReducedForm.reduceFragment(replacement);
                    replacement.typeCheckReduced(tenv, benv, new LinkedList<Function>());
                }
            }
            ArrayList<LetInstruction> lets = new ArrayList<LetInstruction>();
            LambdaInstruction newCNLFI = (LambdaInstruction)OptimizerUtilities.skipLets(replacement, lets);
            Instruction newBody = LambdaOptimizer.generateFunctionCallBody(newCNLFI.getChildInstruction(0), newCNLFI.getBindings(), this.getCurrentFunction(), this.m_cache);
            newCNLFI.setBody(newBody);
            newBody.typeCheckReduced(tenv, benv, new LinkedList<Function>());
            if (this.m_doLoopInvariantOptimization && replacement instanceof LetInstruction) {
                return new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), replacement, null);
            }
            return replacement;
        }
        return super.optimizeStep(n2);
    }

    public static Instruction generateFunctionCallBody(Instruction n2, List paramBindings, Function parentFunction, Map cache) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.entering(s_className, "generateFunctionCallBody");
        }
        if (n2 instanceof FunctionCallInstruction) {
            return n2;
        }
        BindingEnvironment benv = parentFunction.getBindingEnvironment();
        Instruction canonical = n2.generateCanonicalForm(benv);
        String hashVal = canonical.toString();
        String funName = "";
        Set s = n2.accumulateFreeBindingsInOrder(benv);
        Iterator j = paramBindings.iterator();
        int k = 0;
        while (j.hasNext()) {
            IBinding b = (IBinding)j.next();
            if (s.contains(b)) {
                hashVal = hashVal + "_" + k;
            }
            ++k;
        }
        for (IBinding b : s) {
            Type t = b.getBindingType();
            if (t == null) {
                t = b.getLet().getValue().getType(parentFunction.getTypeEnvironment(), benv);
            }
            hashVal = hashVal + "_" + t.toString();
        }
        if (!cache.containsKey(hashVal)) {
            TypeEnvironment tenv = parentFunction.getTypeEnvironment();
            funName = OptimizerUtilities.generateIntermediateIdentifier("repeatedFunction");
            Binding[] bindings = new Binding[s.size()];
            int i = 0;
            for (IBinding b : s) {
                Type t = b.getBindingType();
                if (t == null) {
                    t = b.getLet().getValue().getType(parentFunction.getTypeEnvironment(), benv);
                }
                bindings[i] = new Binding(b.getName(), t);
                ++i;
            }
            Function f2 = parentFunction.cloneFunctionForFixup(null, false, false, false);
            f2.setBody(n2.cloneWithNewNames());
            f2.m_parameters = bindings;
            f2.setName(funName);
            tenv.getModule().addFunction(f2);
            cache.put(hashVal, funName);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "generateFunctionCallBody", "Cache Add");
            }
        } else {
            funName = (String)cache.get(hashVal);
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                s_logger.logp(Level.FINEST, s_className, "generateFunctionCallBody", "Cache hit! on " + funName + " in " + parentFunction.getName());
            }
        }
        LinkedList<IdentifierInstruction> l = new LinkedList<IdentifierInstruction>();
        Iterator it = s.iterator();
        while (it.hasNext()) {
            IdentifierInstruction ii = new IdentifierInstruction(((IBinding)it.next()).getName());
            l.add(ii);
        }
        return new FunctionCallInstruction(funName, l);
    }
}

