/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.BindingDependencyInfo;
import com.ibm.xltxe.rnm1.xylem.DataDependencyDrivenOptimizer;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xml.ras.LoggerUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LetChainClusterizer
extends DataDependencyDrivenOptimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(LetChainClusterizer.class);
    private static final String s_className = LetChainClusterizer.class.getName();
    HashMap m_toConsolidate = new HashMap();
    HashMap m_triples = new HashMap();
    private final int MIN_CHAIN = 5;

    @Override
    protected Instruction optimizeStep(Instruction n2, Instruction parent2, int parentIndex) {
        if (n2 instanceof LetInstruction) {
            boolean separate;
            Instruction valueBody;
            int uses = this.getBindingUseCount((IBinding)((Object)n2));
            if (uses > 1) {
                return n2;
            }
            if (uses == 0) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "optimizeStep", "dead let or untypechecked code?");
                }
                return n2;
            }
            BindingDependencyInfo bdi = (BindingDependencyInfo)this.getBindingDependencyInfo((IBinding)((Object)n2)).next();
            if (!this.shouldConsolidate(bdi)) {
                return n2;
            }
            LinkedList triples = (LinkedList)this.m_toConsolidate.get(bdi.m_parent);
            if (triples == null) {
                triples = new LinkedList();
                this.m_toConsolidate.put(bdi.m_parent, triples);
            }
            Object[] triple = new Object[]{n2, parent2, new Integer(parentIndex)};
            this.m_triples.put(n2, triple);
            triples.add(triple);
            Instruction value2 = ((LetInstruction)n2).getValue();
            triples = (LinkedList)this.m_toConsolidate.get(value2);
            if (triples == null) {
                return n2;
            }
            if (triples.size() < 5) {
                valueBody = n2;
                separate = false;
            } else {
                valueBody = value2;
                separate = true;
            }
            while (!triples.isEmpty()) {
                Object[] oo = (Object[])triples.removeLast();
                LetInstruction li = (LetInstruction)oo[0];
                Instruction p = (Instruction)oo[1];
                int pidx = (Integer)oo[2];
                if (li == parent2) {
                    parent2 = p;
                    parentIndex = pidx;
                }
                this.setChild(p, li.getBody(), pidx);
                this.setChild(li, valueBody, 1);
                valueBody = li;
            }
            if (separate) {
                ChooseInstruction choose = new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), valueBody, null);
                this.setChild(choose, valueBody, 1);
                this.setChild(n2, choose, 0);
            } else {
                this.setChild(parent2, valueBody, parentIndex);
            }
            this.m_toConsolidate.remove(value2);
            return n2;
        }
        return n2;
    }

    private void setChild(Instruction n2, Instruction c, int idx) {
        if (n2 != null) {
            n2.setChildInstruction(idx, c);
        } else {
            this.getCurrentFunction().setBody(n2);
        }
        Object[] oo2 = (Object[])this.m_triples.get(c);
        if (oo2 != null) {
            oo2[1] = n2;
            oo2[2] = new Integer(idx);
        }
    }

    private boolean shouldConsolidate(BindingDependencyInfo bdi) {
        return bdi.m_parent instanceof StreamInstruction;
    }
}

