/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xml.ras.LoggerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LetLetOptimizer
extends Optimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(LetLetOptimizer.class);
    private static final String s_className = LetLetOptimizer.class.getName();
    HashSet<String> imperativeFunctions = new HashSet();

    public void prescan(Module m) {
    }

    @Override
    public void optimizeFunction(Function f2) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "optimizeFunction", "optimizing " + f2.getName());
        }
        Instruction body = this.go(f2.getBody(), new HashMap(), new PendingRenameOptimizer());
        f2.setBody(body);
    }

    public Instruction go(Instruction n2, Map expressions, PendingRenameOptimizer rename) {
        if (!(n2 instanceof ISpecialForm)) {
            return rename.optimize(n2);
        }
        if (!(n2 instanceof LetInstruction)) {
            for (int i = 0; i < n2.getChildInstructionCount(); ++i) {
                n2.setChildInstruction(i, this.go(n2.getChildInstruction(i), expressions, rename));
            }
            return n2;
        }
        expressions = new HashMap(expressions);
        LinkedList<LetInstruction> letList = new LinkedList<LetInstruction>();
        Instruction body = OptimizerUtilities.skipLets(n2, letList);
        LetInstruction last2 = null;
        Iterator i = letList.iterator();
        while (i.hasNext()) {
            LetInstruction li = (LetInstruction)i.next();
            li.setValue(this.go(li.getValue(), expressions, rename));
            if (li.getValue() instanceof ISpecialForm) {
                li.setValue(rename.optimize(li.getValue()));
            }
            if (li.getValue() instanceof IdentifierInstruction) {
                rename.put(li.getVariable(), ((IdentifierInstruction)li.getValue()).getVariable());
                if (last2 != null) {
                    last2.setBody(li.getBody());
                }
                i.remove();
                continue;
            }
            last2 = li;
        }
        body = this.go(body, expressions, rename);
        if (letList.size() == 0) {
            return body;
        }
        letList.getLast().setBody(body);
        return letList.getFirst();
    }

    private static class PendingRenameOptimizer
    extends Optimizer {
        private Map m_map;

        public PendingRenameOptimizer() {
            this.m_skipStringStreams = true;
            this.m_map = new TransitiveMap();
        }

        public void put(Object oldName, Object newName) {
            this.m_map.put(oldName, newName);
        }

        @Override
        protected Instruction optimizeStep(Instruction n2) {
            IdentifierInstruction ii;
            if (n2 instanceof IdentifierInstruction && this.m_map.containsKey((ii = (IdentifierInstruction)n2).getVariable())) {
                return new IdentifierInstruction(this.m_map.get(ii.getVariable()));
            }
            return super.optimizeStep(n2);
        }
    }

    private static class TransitiveMap
    extends HashMap {
        private static final long serialVersionUID = 7758861528196050459L;

        private TransitiveMap() {
        }

        @Override
        public Collection values() {
            return super.values();
        }

        @Override
        public Set entrySet() {
            return super.entrySet();
        }

        @Override
        public Object get(Object arg0) {
            Object a = super.get(arg0);
            while (super.containsKey(a)) {
                a = super.get(a);
            }
            if (a != null) {
                this.put(arg0, a);
            }
            return a;
        }
    }
}

