/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetBaseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.AbstractDataObjectPI;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PISubEntry;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import java.util.Collections;
import java.util.List;

public class OptimizerUtilities {
    private static int s_identifiers = 0;

    public static Instruction replaceDeconstructionBindings(Instruction[] params, Binding[] bindings, Instruction body) {
        Instruction innermost = null;
        Instruction outermost = null;
        for (int k = 0; k < params.length; ++k) {
            outermost = new LetInstruction(bindings[k].getName(), params[k].cloneReduced(), outermost);
            if (innermost != null) continue;
            innermost = outermost;
        }
        if (innermost == null) {
            innermost = body.cloneReduced();
            if (outermost == null) {
                outermost = innermost;
            }
        } else {
            ((LetInstruction)innermost).setBody(body.cloneReduced());
        }
        return outermost;
    }

    public static String generateIntermediateIdentifier() {
        return OptimizerUtilities.generateIntermediateIdentifier("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateIntermediateIdentifier(String prefix2) {
        Class<OptimizerUtilities> clazz = OptimizerUtilities.class;
        synchronized (OptimizerUtilities.class) {
            int n2 = ++s_identifiers;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return "$optimize" + n2 + (prefix2.length() == 0 ? "" : "$" + prefix2);
        }
    }

    public static final Instruction skipLets(Instruction n2, List<LetInstruction> lets) {
        while (n2 instanceof LetInstruction) {
            lets.add((LetInstruction)n2);
            n2 = ((LetInstruction)n2).getBody();
        }
        return n2;
    }

    public static final Instruction skipLets(Instruction n2) {
        while (n2 instanceof LetInstruction) {
            n2 = ((LetInstruction)n2).getBody();
        }
        return n2;
    }

    public static final LetInstruction skipToInnermostLet(LetInstruction n2) {
        Instruction body = n2.getBody();
        while (body instanceof LetInstruction) {
            n2 = (LetInstruction)body;
            body = n2.getBody();
        }
        return n2;
    }

    public static Instruction reconstructLets(Instruction body, List lets) {
        return OptimizerUtilities.reconstructLets(body, lets, true);
    }

    public static Instruction reconstructLets(Instruction body, List lets, boolean clone) {
        LetBaseInstruction inner2 = null;
        LetInstruction outer = null;
        for (LetInstruction x : lets) {
            LetInstruction y;
            LetInstruction letInstruction = y = clone ? new LetInstruction(x.getVariable(), x.getValue().cloneWithoutTypeInformation(), null) : x;
            if (outer == null) {
                outer = y;
            }
            if (inner2 != null) {
                inner2.setBody(y);
            }
            inner2 = y;
        }
        if (outer == null) {
            return body;
        }
        inner2.setBody(body);
        return outer;
    }

    public static AbstractDataObjectPI findCommonalities(PartialInformationCollector pic, List handlers, LetChainManager lcm) {
        BindingEnvironment benv = lcm.getCurrentFunction().getBindingEnvironment();
        Instruction[] commonalities = null;
        AbstractDataType.Constructor c0 = null;
        for (Instruction n2 : handlers) {
            int j;
            if ((n2 = NavigationUtilities.skipLets(n2)) instanceof IdentifierInstruction) {
                IdentifierInstruction ii = (IdentifierInstruction)n2;
                IBinding b = ii.getBinding(lcm.getCurrentFunction().getBindingEnvironment());
                if (b != null && b.getLet() != null) {
                    n2 = b.getLet().getValue();
                } else {
                    return null;
                }
            }
            if (n2 == null) {
                return null;
            }
            if (!(n2 instanceof ConstructorInstantiationInstruction)) {
                return null;
            }
            ConstructorInstantiationInstruction cii = (ConstructorInstantiationInstruction)n2;
            AbstractDataType.Constructor c = cii.getConstructor();
            if (commonalities == null) {
                commonalities = new Instruction[c.m_parameters.length];
                c0 = c;
                for (j = 0; j < c.m_parameters.length; ++j) {
                    if (!cii.m_parameters[j].isStatic(benv)) continue;
                    commonalities[j] = cii.m_parameters[j];
                }
                continue;
            }
            if (c0 != c) {
                return null;
            }
            for (j = 0; j < c.m_parameters.length; ++j) {
                if (cii.m_parameters[j].isStatic(benv) && cii.m_parameters[j].equals(commonalities[j])) continue;
                commonalities[j] = null;
            }
        }
        if (commonalities == null) {
            return null;
        }
        boolean foundCommonality = false;
        PISubEntry[] entries = new PISubEntry[commonalities.length];
        for (int j = 0; j < commonalities.length; ++j) {
            if (commonalities[j] == null) continue;
            commonalities[j] = lcm.lookupBinding((Instruction)commonalities[j]);
            if (!(commonalities[j] instanceof LiteralInstruction)) continue;
            entries[j] = new PISubEntry(Collections.EMPTY_SET, commonalities[j], lcm.getCurrentFunction().getName());
            foundCommonality = true;
        }
        if (!foundCommonality) {
            return null;
        }
        AbstractDataObjectPI adopi = new AbstractDataObjectPI(c0, entries);
        return adopi;
    }

    public static void clearTypeInformation(Instruction instruction2) {
        int numTypes = instruction2.getTypeParameterCount();
        for (int i = 0; i < numTypes; ++i) {
            instruction2.setTypeParameter(i, new TypeVariable());
        }
        int numChildren = instruction2.getChildInstructionCount();
        for (int i = 0; i < numChildren; ++i) {
            OptimizerUtilities.clearTypeInformation(instruction2.getChildInstruction(i));
        }
    }
}

