/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ScopedPostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetBaseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class OrderLetChains {
    private static final boolean m_debug = true;
    Function m_currentFunction;

    public void orderFunction(Function f2) {
        this.m_currentFunction = f2;
        this.orderInstruction(f2.getBody(), null, -1);
    }

    private void orderInstruction(Instruction n2, Instruction parent2, int parentIndex) {
        if (n2 instanceof LetInstruction) {
            this.orderLetChain(n2, parent2, parentIndex);
        } else {
            this.orderChildren(n2);
        }
    }

    private void orderChildren(Instruction n2) {
        for (int i = 0; i < n2.getChildInstructionCount(); ++i) {
            Instruction child2 = n2.getChildInstruction(i);
            this.orderInstruction(child2, n2, i);
        }
    }

    private void orderLetChain(Instruction n2, Instruction parent2, int parentIndex) {
        HashMap<Object, LetInstruction> variableToLetHash = new HashMap<Object, LetInstruction>();
        int count2 = 0;
        while (n2 instanceof LetInstruction) {
            ++count2;
            LetInstruction li = (LetInstruction)n2;
            Instruction value2 = li.getValue();
            this.orderInstruction(value2, li, 0);
            Object variable2 = ((LetInstruction)n2).getVariable();
            variableToLetHash.put(variable2, li);
            n2 = li.getBody();
        }
        this.orderInstruction(n2, parent2, parentIndex);
        if (count2 <= 1) {
            return;
        }
        Instruction body = n2;
        LinkedList<ArrayList> workStack = new LinkedList<ArrayList>();
        ArrayList freeVars = OrderedFreeVariables.findFreeVariables(body);
        LetBaseInstruction previousLet = null;
        LetInstruction top = null;
        ArrayList<Object> orderedVariables = new ArrayList<Object>(variableToLetHash.size());
        while (!freeVars.isEmpty()) {
            Object variable3 = freeVars.get(0);
            LetInstruction let = (LetInstruction)variableToLetHash.get(variable3);
            if (let != null) {
                ArrayList<Object> vars = OrderedFreeVariables.findFreeVariables(let.getValue());
                if (vars.isEmpty()) {
                    freeVars.remove(0);
                    variableToLetHash.remove(variable3);
                    if (previousLet != null) {
                        previousLet.setBody(let);
                    } else {
                        top = let;
                    }
                    previousLet = let;
                    orderedVariables.add(variable3);
                } else {
                    workStack.add(freeVars);
                    freeVars = vars;
                }
            } else {
                freeVars.remove(0);
            }
            while (freeVars.isEmpty() && !workStack.isEmpty()) {
                freeVars = (ArrayList)workStack.removeLast();
                variable3 = freeVars.remove(0);
                let = (LetInstruction)variableToLetHash.remove(variable3);
                if (previousLet != null) {
                    previousLet.setBody(let);
                } else {
                    top = let;
                }
                previousLet = let;
                orderedVariables.add(variable3);
            }
        }
        if (top != null) {
            if (parent2 == null) {
                this.m_currentFunction.setBody(top);
            } else {
                parent2.setChildInstruction(parentIndex, top);
            }
        }
        if (previousLet != null) {
            previousLet.setBody(body);
        }
    }

    public static class OrderedFreeVariables
    extends ScopedPostOrderOptimizer {
        private ArrayList<Object> m_freeVars = new ArrayList();
        private LinkedList<ArrayList<Object>> m_freeVarsStack = new LinkedList();

        public static ArrayList<Object> findFreeVariables(Instruction n2) {
            OrderedFreeVariables ffv = new OrderedFreeVariables();
            ffv.optimize(n2);
            return ffv.getFreeVars();
        }

        public ArrayList<Object> getFreeVars() {
            return this.m_freeVars;
        }

        @Override
        protected void preOrderStep(Instruction n2, Instruction parent2, int parentIndex) {
            if (parent2 instanceof ISpecialForm && ((ISpecialForm)((Object)parent2)).isChildInstructionBody(parentIndex)) {
                this.m_freeVarsStack.add(this.m_freeVars);
                this.m_freeVars = new ArrayList();
            }
        }

        @Override
        protected Instruction optimizeStep(Instruction n2, Instruction parent2, int parentIndex) {
            this.addVars(n2, parent2, parentIndex);
            this.removeVars(n2, parent2, parentIndex);
            return n2;
        }

        @Override
        protected void endOptimize(Instruction n2) {
            if (this.m_freeVarsStack.size() != 0) {
                throw new XylemError("ERR_SYSTEM", "!!!" + this.m_freeVarsStack.size());
            }
        }

        @Override
        protected void beginOptimize(Instruction n2) {
            this.m_freeVars.clear();
            this.m_freeVarsStack.clear();
        }

        protected void addVars(Instruction n2, Instruction parent2, int parentIndex) {
            Object variable2;
            if (n2 instanceof IdentifierInstruction && !this.m_freeVars.contains(variable2 = ((IdentifierInstruction)n2).getVariable())) {
                Object var = ((IdentifierInstruction)n2).getVariable();
                this.m_freeVars.add(var);
            }
        }

        protected void removeVars(Instruction n2, Instruction parent2, int parentIndex) {
            if (parent2 instanceof ISpecialForm && ((ISpecialForm)((Object)parent2)).isChildInstructionBody(parentIndex)) {
                IBinding[] bb = ((ISpecialForm)((Object)parent2)).getChildInstructionBindings(parentIndex);
                if (bb == null) {
                    throw new XylemError("ERR_SYSTEM", "!" + parentIndex + " " + n2);
                }
                this.m_freeVars.removeAll(Arrays.asList(Binding.getNames(bb)));
                ArrayList<Object> outer = this.m_freeVarsStack.removeLast();
                for (int i = 0; i < this.m_freeVars.size(); ++i) {
                    Object freeVar = this.m_freeVars.get(i);
                    if (outer.contains(freeVar)) continue;
                    outer.add(freeVar);
                }
                this.m_freeVars = outer;
            }
        }
    }
}

