/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.DataDependencyDrivenPostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ParallelForEachInstruction;
import com.ibm.xml.ras.LoggerUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParallelForEachOptimizer
extends DataDependencyDrivenPostOrderOptimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(ParallelForEachOptimizer.class);
    private static final String s_className = ParallelForEachOptimizer.class.getName();

    @Override
    protected Instruction optimizeStep(Instruction n2) {
        if (n2 instanceof ParallelForEachInstruction) {
            Object[] vars;
            Instruction[] sources;
            ParallelForEachInstruction pfei = (ParallelForEachInstruction)n2;
            Binding[] bindings = pfei.getElementBindings();
            int nUsed = 0;
            for (int i = 0; i < bindings.length; ++i) {
                if (!this.isBindingUsed(bindings[i])) continue;
                ++nUsed;
            }
            if (nUsed == bindings.length) {
                return n2;
            }
            if (nUsed == 0) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "optimizeStep", "No bindings used in PFEI");
                }
                sources = new Instruction[]{pfei.getSources()[0].cloneWithoutTypeInformation()};
                vars = new Object[]{pfei.getElementVars()[0]};
            } else {
                sources = new Instruction[nUsed];
                vars = new Object[nUsed];
                int j = 0;
                for (int i = 0; i < bindings.length; ++i) {
                    if (!this.isBindingUsed(bindings[i])) continue;
                    sources[j] = pfei.getSources()[i].cloneWithoutTypeInformation();
                    vars[j++] = pfei.getElementVars()[i];
                }
            }
            ParallelForEachInstruction pfei2 = new ParallelForEachInstruction(sources, vars, pfei.getBody().cloneWithoutTypeInformation());
            pfei2.setIndexVar(pfei.getIndexVar());
            this.doTypeCheck(n2, pfei2, n2.getBindingEnvironment());
            return pfei2;
        }
        return n2;
    }
}

