/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReducedForm {
    private static boolean s_enabled = false;
    private static final Logger s_logger = LoggerUtil.getLogger(ReducedForm.class);
    private static final String s_className = ReducedForm.class.getName();

    public static void reduceModule(Module m) {
        for (Function f2 : m.getFunctions()) {
            Instruction bodyOriginal = f2.getBody();
            try {
                ReducedForm.reduceFunction(f2);
                f2.typeCheckReduced(m, new LinkedList());
            }
            catch (Exception e) {
                FFDCUtil.log(e, ReducedForm.class);
                f2.setComment(f2.getComment() + "\n" + e);
                String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"converted code did not reduce"});
                s_logger.logp(Level.SEVERE, s_className, "reduceModule", message, e);
                Program.dumpXylemFunctions(new Function[]{f2}, new File("."), "function");
                throw new XylemError(message);
            }
        }
    }

    public static void reduceFunction(Function f2) {
        new Form().optimizeFunction(f2);
        new Form2().optimizeFunction(f2);
        new Variables().optimizeFunction(f2);
    }

    public static Instruction reduceFragment(Instruction n2) {
        n2 = new Form().optimize(n2);
        n2 = new Form2().optimize(n2);
        n2 = new Variables().optimizeFragment(n2);
        return n2;
    }

    private static class Variables
    extends Optimizer {
        private HashMap m_names;
        private static final Object BOUND = "";
        private boolean m_checkUnboundVars = true;

        private Variables() {
        }

        @Override
        protected Instruction optimizeStep(Instruction n2) {
            if (n2 instanceof LetInstruction) {
                LetInstruction inner2;
                Instruction outer = n2;
                do {
                    boolean renamed;
                    inner2 = (LetInstruction)n2;
                    Object original = inner2.getVariable();
                    Object previousMapping = this.m_names.get(original);
                    if (this.m_names.get(original) == null) {
                        renamed = false;
                    } else {
                        renamed = true;
                        Integer newVar = ReductionHelper.generateIntermediateIdentifier2();
                        inner2.setVariable(newVar);
                    }
                    this.m_names.put(inner2.getVariable(), BOUND);
                    n2.setChildInstruction(0, this.optimize(inner2.getValue()));
                    if (!renamed) continue;
                    this.m_names.put(original, inner2.getVariable());
                    inner2.setBody(this.optimize(inner2.getBody()));
                    this.m_names.put(original, previousMapping);
                    return null;
                } while ((n2 = inner2.getBody()) instanceof LetInstruction);
                inner2.setBody(this.optimize(n2));
                return null;
            }
            if (n2 instanceof IdentifierInstruction) {
                IdentifierInstruction ii = (IdentifierInstruction)n2;
                Object name2 = this.m_names.get(ii.getVariable());
                if (name2 == null) {
                    if (this.m_checkUnboundVars) {
                        throw new XylemError("ERR_SYSTEM", "unbound variable:" + ii + " in: " + this.getCurrentFunction());
                    }
                    return null;
                }
                if (name2 == BOUND) {
                    return null;
                }
                return new IdentifierInstruction(name2);
            }
            if (n2 instanceof ISpecialForm) {
                for (int i = 0; i < n2.getChildInstructionCount(); ++i) {
                    IBinding[] bb = ((ISpecialForm)((Object)n2)).getChildInstructionBindings(i);
                    if (bb != null) {
                        HashMap<Object, Integer> newNames = null;
                        HashMap<Object, Object> oldNames = null;
                        for (int j = 0; j < bb.length; ++j) {
                            Object name3;
                            if ("_".equals(bb[j].getName()) && n2.getClass().getName().endsWith("MatchXDMItemInstruction") || (name3 = this.m_names.put(bb[j].getName(), BOUND)) == null) continue;
                            if (newNames == null) {
                                newNames = new HashMap<Object, Integer>();
                                oldNames = new HashMap<Object, Object>();
                            }
                            Integer newName = ReductionHelper.generateIntermediateIdentifier2();
                            newNames.put(bb[j].getName(), newName);
                            oldNames.put(bb[j].getName(), name3);
                            bb[j].setName(newName);
                        }
                        if (newNames != null) {
                            this.m_names.putAll(newNames);
                            n2.setChildInstruction(i, this.optimize(n2.getChildInstruction(i)));
                            this.m_names.putAll(oldNames);
                            continue;
                        }
                    }
                    n2.setChildInstruction(i, this.optimize(n2.getChildInstruction(i)));
                }
                return null;
            }
            return n2;
        }

        @Override
        public void optimizeFunction(Function f2) {
            this.m_names = new HashMap();
            for (int i = 0; i < f2.m_parameters.length; ++i) {
                this.m_names.put(f2.m_parameters[i].getName(), BOUND);
            }
            super.optimizeFunction(f2);
            this.m_names = null;
        }

        public Instruction optimizeFragment(Instruction n2) {
            this.m_checkUnboundVars = false;
            this.m_names = new HashMap();
            n2 = this.optimize(n2);
            this.m_names = null;
            this.m_checkUnboundVars = true;
            return n2;
        }
    }

    private static class Form
    extends Optimizer {
        private Form() {
        }

        @Override
        protected Instruction optimizeStep(Instruction n2) {
            if (n2 instanceof LetInstruction) {
                LetInstruction inner2;
                Instruction outer = n2;
                do {
                    inner2 = (LetInstruction)n2;
                    Instruction val = this.optimize(inner2.getValue());
                    inner2.setValue(val);
                } while ((n2 = inner2.getBody()) instanceof LetInstruction);
                inner2.setBody(this.optimize(n2));
                return null;
            }
            if (n2 instanceof LiteralInstruction) {
                return n2;
            }
            boolean special = n2 instanceof ISpecialForm;
            int c = n2.getChildInstructionCount();
            Instruction outer = n2;
            for (int i = 0; i < c; ++i) {
                if (special && ((ISpecialForm)((Object)n2)).isChildInstructionBody(i)) {
                    n2.setChildInstruction(i, this.optimize(n2.getChildInstruction(i)));
                    continue;
                }
                Instruction n22 = n2.getChildInstruction(i);
                if (n22 instanceof IdentifierInstruction || n22 instanceof LiteralInstruction) continue;
                Integer var = ReductionHelper.generateIntermediateIdentifier2();
                n2.setChildInstruction(i, new IdentifierInstruction(var));
                Instruction reduced = this.optimize(n22);
                ArrayList<LetInstruction> lets = new ArrayList<LetInstruction>();
                Instruction reducedBody = OptimizerUtilities.skipLets(reduced, lets);
                Instruction newLet = new LetInstruction(var, reducedBody, outer);
                if (lets.size() > 0) {
                    LetInstruction inner3 = (LetInstruction)lets.get(lets.size() - 1);
                    inner3.setBody(newLet);
                    newLet = reduced;
                }
                outer = newLet;
            }
            return outer.cloneShallow();
        }
    }

    private static class Form2
    extends Optimizer {
        private Form2() {
        }

        @Override
        protected Instruction optimizeStep(Instruction n2) {
            if (n2 instanceof LetInstruction) {
                LetInstruction li;
                LetInstruction prevLI = null;
                do {
                    if ((li = (LetInstruction)n2).getValue() instanceof LetInstruction) {
                        LinkedList<LetInstruction> ll = new LinkedList<LetInstruction>();
                        Instruction eventualValue = OptimizerUtilities.skipLets(li.getValue(), ll);
                        li.setValue(this.optimize(eventualValue));
                        LetInstruction inner2 = ll.get(ll.size() - 1);
                        inner2.setBody(li);
                        Instruction outer = ll.get(0);
                        outer = this.optimize(outer);
                        if (prevLI != null) {
                            prevLI.setBody(outer);
                            return null;
                        }
                        return outer;
                    }
                    li.setValue(this.optimize(li.getValue()));
                    n2 = li.getBody();
                    prevLI = li;
                } while (n2 instanceof LetInstruction);
                li.setBody(this.optimize(n2));
                return null;
            }
            if (n2 instanceof ChooseInstruction && ((ChooseInstruction)n2).m_cases.length > 1) {
                ChooseInstruction ci = (ChooseInstruction)n2;
                ChooseInstruction.Case[] cases = ci.m_cases;
                Instruction outer = ci.getDefaultHandler();
                if (outer != null) {
                    outer = this.optimize(outer);
                }
                for (int j = cases.length - 1; j >= 0; --j) {
                    outer = new ChooseInstruction(cases[j].getTest(), this.optimize(cases[j].getHandler()), outer);
                }
                return outer;
            }
            return n2;
        }
    }

    public static class Check
    extends Optimizer {
        private Instruction m_fragment;
        private HashSet m_names = new HashSet();

        public static void check(Module module) {
            if (!s_enabled) {
                return;
            }
            Check checker = new Check();
            for (Function f2 : module.getFunctions()) {
                checker.optimizeFunction(f2);
            }
        }

        public static void check(Function f2) {
            if (!s_enabled) {
                return;
            }
            new Check().optimizeFunction(f2);
        }

        public static void check(Instruction n2) {
            if (!s_enabled) {
                return;
            }
            new Check().optimize(n2);
        }

        @Override
        protected Instruction optimizeStep(Instruction n2, Instruction parent2, int parentIndex) {
            if (n2 == null) {
                throw new XylemError("ERR_SYSTEM", "null instruction!");
            }
            if (n2 instanceof LetInstruction) {
                if (((LetInstruction)n2).getValue() instanceof LetInstruction) {
                    throw new XylemError("ERR_SYSTEM", "let value cannot be let in '" + n2 + "'");
                }
                if (!this.m_names.add(((LetInstruction)n2).getVariable())) {
                    throw new XylemError("ERR_SYSTEM", "let variable '" + ((LetInstruction)n2).getVariable() + "'" + " reused in " + this.getCurrentFunction());
                }
            } else {
                boolean special = n2 instanceof ISpecialForm;
                int c = n2.getChildInstructionCount();
                for (int i = 0; i < c; ++i) {
                    Instruction param;
                    if (special && ((ISpecialForm)((Object)n2)).isChildInstructionBody(i) || (param = n2.getChildInstruction(i)) instanceof IdentifierInstruction || param instanceof LiteralInstruction) continue;
                    throw new XylemError("ERR_SYSTEM", "child " + i + " not reduced: " + param + "\n in: " + n2);
                }
                if (n2 instanceof ChooseInstruction) {
                    ChooseInstruction ci = (ChooseInstruction)n2;
                    if (ci.m_cases.length > 1) {
                        throw new XylemError("ERR_SYSTEM", "ChooseInstruction not reduced (too many cases):\n" + n2);
                    }
                } else if (this.getCurrentFunction() != null && n2 instanceof IdentifierInstruction && ((IdentifierInstruction)n2).getBinding(this.getCurrentFunction().getBindingEnvironment()) == null) {
                    throw new XylemError("ERR_SYSTEM", "identifier " + n2 + " is not bound");
                }
            }
            return n2;
        }

        @Override
        public Instruction optimize(Instruction n2) {
            this.m_names.clear();
            this.m_fragment = n2;
            super.optimize(n2);
            this.m_fragment = null;
            this.m_names.clear();
            return n2;
        }

        @Override
        public void optimizeFunction(Function f2) {
            if (f2.getBindingEnvironment() == null) {
                throw new XylemError("ERR_SYSTEM", "function " + f2.getName() + " has no binding environment.");
            }
            this.m_names = new HashSet();
            for (int i = 0; i < f2.m_parameters.length; ++i) {
                this.m_names.add(f2.m_parameters[i].getName());
            }
            try {
                super.optimizeFunction(f2);
            }
            catch (Exception e) {
                FFDCUtil.log(e, this);
                String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"error encountered in " + f2.getName() + " [" + e + "]\n" + f2});
                s_logger.logp(Level.SEVERE, s_className, "optimizeFunction", message, e);
                throw new XylemError(message);
            }
            this.m_names = null;
        }
    }
}

