/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IImperativeInstruction;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xml.ras.LoggerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RepeatedExpressionOptimizer
extends Optimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(RepeatedExpressionOptimizer.class);
    private static final String s_className = RepeatedExpressionOptimizer.class.getName();
    HashSet<String> imperativeFunctions = new HashSet();
    int count = 0;
    private static final boolean diag = false;
    private static final boolean newMethod = false;

    public void prescan(Module m) {
        ScanForImperativeFunctions scanner = new ScanForImperativeFunctions();
        m.optimize(scanner);
        scanner.propigateImperativity();
    }

    @Override
    public void optimizeFunction(Function f2) {
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "optimizeFunction", "optimizing " + f2.getName());
        }
        Instruction body = this.go(f2.getBody(), new HashMap<ExpressionInfo, ExpressionInfo>(), new PendingRenameOptimizer());
        f2.setBody(body);
    }

    public Instruction go(Instruction n2, Map<ExpressionInfo, ExpressionInfo> expressions, PendingRenameOptimizer rename) {
        if (!(n2 instanceof ISpecialForm)) {
            return rename.optimize(n2);
        }
        if (!(n2 instanceof LetInstruction)) {
            for (int i = 0; i < n2.getChildInstructionCount(); ++i) {
                n2.setChildInstruction(i, this.go(n2.getChildInstruction(i), expressions, rename));
            }
            return n2;
        }
        expressions = new HashMap<ExpressionInfo, ExpressionInfo>(expressions);
        LinkedList<LetInstruction> letList = new LinkedList<LetInstruction>();
        Instruction body = OptimizerUtilities.skipLets(n2, letList);
        LetInstruction last2 = null;
        Iterator i = letList.iterator();
        while (i.hasNext()) {
            ExpressionInfo ei;
            ExpressionInfo ei2;
            LetInstruction li = (LetInstruction)i.next();
            li.setValue(this.go(li.getValue(), expressions, rename));
            if (li.getValue() instanceof ISpecialForm) {
                li.setValue(rename.optimize(li.getValue()));
            }
            if ((ei2 = expressions.put(ei = new ExpressionInfo(li.getVariable(), li.getValue()), ei)) != null) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                    s_logger.logp(Level.FINEST, s_className, "go", "replacing '" + ei.getIdentifier() + " with " + ei2.getIdentifier());
                }
                rename.put(ei.getIdentifier(), ei2.getIdentifier());
                if (last2 != null) {
                    last2.setBody(li.getBody());
                }
                expressions.put(ei2, ei2);
                i.remove();
                continue;
            }
            last2 = li;
        }
        body = this.go(body, expressions, rename);
        if (letList.size() == 0) {
            return body;
        }
        letList.getLast().setBody(body);
        return letList.getFirst();
    }

    String calcInstructionString(Instruction expr) {
        Instruction clean = expr.assignNewNames(new HashMap(), new IdentifierCanonicalizer());
        clean.clearTypeInformation();
        return clean.toString();
    }

    private static class IdentifierCanonicalizer
    implements INewNameGenerator {
        private int m_id = 0;

        private IdentifierCanonicalizer() {
        }

        public void reset() {
            this.m_id = 0;
        }

        @Override
        public Object getNewName() {
            return new Integer(++this.m_id);
        }
    }

    private static class PendingRenameOptimizer
    extends Optimizer {
        private Map m_map;

        public PendingRenameOptimizer() {
            this.m_skipStringStreams = true;
            this.m_map = new TransitiveMap();
        }

        public void put(Object oldName, Object newName) {
            this.m_map.put(oldName, newName);
        }

        @Override
        protected Instruction optimizeStep(Instruction n2) {
            IdentifierInstruction ii;
            if (n2 instanceof IdentifierInstruction && this.m_map.containsKey((ii = (IdentifierInstruction)n2).getVariable())) {
                return new IdentifierInstruction(this.m_map.get(ii.getVariable()));
            }
            return super.optimizeStep(n2);
        }
    }

    private static class TransitiveMap
    extends HashMap {
        private static final long serialVersionUID = 7758861528196050459L;

        private TransitiveMap() {
        }

        @Override
        public Collection values() {
            return super.values();
        }

        @Override
        public Set entrySet() {
            return super.entrySet();
        }

        @Override
        public Object get(Object arg0) {
            Object a = super.get(arg0);
            while (super.containsKey(a)) {
                a = super.get(a);
            }
            if (a != null) {
                this.put(arg0, a);
            }
            return a;
        }
    }

    private class ExpressionInfo {
        private Instruction m_expr;
        private String m_key;
        private String m_canonical;
        private Object m_identifier;

        public ExpressionInfo(Object ident, Instruction n2) {
            this.m_identifier = ident;
            this.m_expr = n2;
        }

        public Object getIdentifier() {
            return this.m_identifier;
        }

        public int hashCode() {
            if (this.m_key == null) {
                this.calcKey();
            }
            return this.m_key.hashCode();
        }

        public boolean equals(Object arg0) {
            if (this.m_expr instanceof IImperativeInstruction) {
                return false;
            }
            if (this.m_expr instanceof FunctionCallInstruction && RepeatedExpressionOptimizer.this.imperativeFunctions.contains(((FunctionCallInstruction)this.m_expr).getFunction())) {
                return false;
            }
            ExpressionInfo ei = (ExpressionInfo)arg0;
            if (this.hashCode() != ei.hashCode()) {
                return false;
            }
            if (this.m_canonical == null) {
                this.calcCanonical();
            }
            if (ei.m_canonical == null) {
                ei.calcCanonical();
            }
            return this.m_canonical.equals(ei.m_canonical);
        }

        void diagEquals(String s1, String s2) {
            System.out.println("Comparing:");
            System.out.println(this.getStrippedCanonical(s1));
            System.out.println(this.getStrippedCanonical(s2));
        }

        String getStrippedCanonical(String m_canonical) {
            StringBuilder builder = new StringBuilder();
            char[] chars = m_canonical.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (c == '\n') continue;
                builder.append(c);
            }
            return builder.toString();
        }

        private void calcKey() {
            if (!(this.m_expr instanceof ISpecialForm)) {
                this.m_canonical = this.m_key = this.m_expr.toString();
            } else {
                ISpecialForm sf = (ISpecialForm)((Object)this.m_expr);
                StringBuffer sb = new StringBuffer(this.m_expr.getClass().getName());
                for (int i = 0; i < this.m_expr.getChildInstructionCount(); ++i) {
                    if (sf.isChildInstructionBody(i)) continue;
                    sb.append(' ');
                    sb.append(this.m_expr.getChildInstruction(i).toString());
                }
                this.m_key = sb.toString();
            }
        }

        private void calcCanonical() {
            this.m_canonical = this.m_expr.assignNewNames(new HashMap(), new IdentifierCanonicalizer()).toString();
        }
    }

    public class ScanForImperativeFunctions
    extends Optimizer {
        HashMap<String, Set<String>> dependencies = new HashMap();

        @Override
        public Instruction optimizeStep(Instruction n2) {
            if (n2 instanceof IImperativeInstruction) {
                RepeatedExpressionOptimizer.this.imperativeFunctions.add(this.getCurrentFunction().getName());
            } else if (n2 instanceof FunctionCallInstruction) {
                Set<String> calls;
                FunctionCallInstruction fci = (FunctionCallInstruction)n2;
                Function caller = this.getCurrentFunction();
                String called = fci.getFunction();
                boolean calledIsImper = RepeatedExpressionOptimizer.this.imperativeFunctions.contains(called);
                if (calledIsImper) {
                    RepeatedExpressionOptimizer.this.imperativeFunctions.add(caller.getName());
                }
                if ((calls = this.dependencies.get(called)) == null) {
                    calls = new HashSet<String>();
                    this.dependencies.put(called, calls);
                }
                calls.add(caller.getName());
            } else if (n2 instanceof ModuleFunctionCallInstruction) {
                return n2;
            }
            return n2;
        }

        public void propigateImperativity() {
            boolean changed;
            do {
                changed = false;
                for (String called : this.dependencies.keySet()) {
                    if (!RepeatedExpressionOptimizer.this.imperativeFunctions.contains(called)) continue;
                    for (String caller : this.dependencies.get(called)) {
                        if (RepeatedExpressionOptimizer.this.imperativeFunctions.contains(caller)) continue;
                        changed = true;
                        RepeatedExpressionOptimizer.this.imperativeFunctions.add(caller);
                    }
                }
            } while (changed);
        }
    }
}

