/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.DataDependencyDrivenPostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReverseInliningOptimizer
extends DataDependencyDrivenPostOrderOptimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(ReverseInliningOptimizer.class);
    private static final String s_className = ReverseInliningOptimizer.class.getName();
    private int m_limit;
    public Object[] m_necessaryParameters = new Object[0];

    public ReverseInliningOptimizer(int limit) {
        this.m_limit = limit;
    }

    @Override
    protected Instruction optimizeStep(Instruction n2) {
        int size = n2.accumulateByteCodeSize();
        if (this.m_limit > 0 && size > this.m_limit && this.m_currentFunction.getBody() != n2) {
            Instruction n22 = n2;
            if (n2 instanceof ChooseInstruction) {
                n22 = this.handleChoose((ChooseInstruction)n2);
            } else if (n2 instanceof LetInstruction) {
                n22 = this.handleLet((LetInstruction)n2);
            } else if (n2 instanceof MatchInstruction) {
                n22 = this.handleMatch((MatchInstruction)n2);
            } else if (n2 instanceof StreamInstruction) {
                n22 = this.handleStream((StreamInstruction)n2);
            }
            if (n2 == n22) {
                return n2;
            }
            int size2 = n22.accumulateByteCodeSize();
            if (size2 < size) {
                return this.optimizeStep(this.doTypeCheck(n2, n22, n2.getBindingEnvironment()));
            }
            return n2;
        }
        return n2;
    }

    private boolean isSafeToCut(Instruction n2) {
        HashSet freeVarBindings = new HashSet();
        n2.accumulateFreeBindings(freeVarBindings, null);
        for (IBinding b : freeVarBindings) {
            if (b == null) continue;
            TypeEnvironment bte = this.getCurrentFunction().getTypeEnvironment();
            Type bt = b.getBindingType().resolveType(bte);
            if (bt instanceof NamedType) {
                return false;
            }
            if (!(bt instanceof StreamType) || b.getLet() == null || this.getBindingUseCount(b) != 1 || b.getLet().isStatic(null)) continue;
            return false;
        }
        return true;
    }

    private Instruction handleMatch(MatchInstruction mn) {
        FunctionCallInstruction fc;
        int i;
        if (!this.isSafeToCut(mn)) {
            return mn;
        }
        Instruction oldDefault = mn.getDefault();
        MatchInstruction.Match[] oldMatches = mn.getMatches();
        Instruction oldToMatch = mn.getToMatch();
        LinkedList<MatchInstruction.Match> firstList = new LinkedList<MatchInstruction.Match>();
        LinkedList<MatchInstruction.Match> secondList = new LinkedList<MatchInstruction.Match>();
        for (i = oldMatches.length - 1; i > 1 && i > oldMatches.length / 2; --i) {
            secondList.addFirst(oldMatches[i]);
        }
        while (i >= 0) {
            firstList.addFirst(oldMatches[i]);
            --i;
        }
        MatchInstruction.Match[] first = new MatchInstruction.Match[firstList.size()];
        MatchInstruction.Match[] second = new MatchInstruction.Match[secondList.size()];
        firstList.toArray(first);
        secondList.toArray(second);
        if (secondList.size() == 0) {
            if (null == oldDefault) {
                return mn;
            }
            fc = this.buildFunction(mn, oldDefault, "match-default");
        } else {
            MatchInstruction secondMatch = new MatchInstruction(oldToMatch, second, oldDefault);
            fc = this.buildFunction(mn, secondMatch, "match");
        }
        Instruction firstMatch = new MatchInstruction(oldToMatch, first, (Instruction)fc).cloneWithoutTypeInformation();
        return firstMatch;
    }

    private Instruction handleChoose(ChooseInstruction cn) {
        FunctionCallInstruction fc;
        Instruction test2;
        Instruction handler;
        int i;
        if (!this.isSafeToCut(cn)) {
            return cn;
        }
        Instruction oldDefault = cn.getDefaultHandler();
        int size = 0;
        if (oldDefault != null) {
            size += oldDefault.accumulateByteCodeSize();
        }
        LinkedList<ChooseInstruction.Case> firstList = new LinkedList<ChooseInstruction.Case>();
        LinkedList<ChooseInstruction.Case> secondList = new LinkedList<ChooseInstruction.Case>();
        for (i = cn.m_cases.length - 1; i >= 1; --i) {
            handler = cn.m_cases[i].getHandler();
            test2 = cn.m_cases[i].getTest();
            size += handler.accumulateByteCodeSize();
            if (this.m_limit > 0 && (size += test2.accumulateByteCodeSize()) >= this.m_limit) break;
            secondList.addFirst(new ChooseInstruction.Case(test2, handler));
        }
        while (i >= 0) {
            handler = cn.m_cases[i].getHandler();
            test2 = cn.m_cases[i].getTest();
            firstList.addFirst(new ChooseInstruction.Case(test2, handler));
            --i;
        }
        if (secondList.size() == 0) {
            if (oldDefault == null) {
                throw new XylemError("ERR_SYSTEM", "inconsistency in RIO at " + cn);
            }
            fc = this.buildFunction(cn, oldDefault, "choose-default");
        } else {
            ChooseInstruction secondChoose = new ChooseInstruction(secondList.toArray(new ChooseInstruction.Case[0]), oldDefault);
            fc = this.buildFunction(cn, secondChoose, "choose");
        }
        if (firstList.size() == 0) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "handleChoose", "inconsistency 1 in RIO at " + cn);
            }
            return fc;
        }
        ChooseInstruction firstChoose = new ChooseInstruction(firstList.toArray(new ChooseInstruction.Case[0]), fc);
        return ((Instruction)firstChoose).cloneWithoutTypeInformation();
    }

    private Instruction handleLet(LetInstruction n2) {
        LetInstruction newLet = (LetInstruction)n2.cloneShallow();
        Instruction body = n2.getBody();
        Instruction value2 = n2.getValue();
        if (body.accumulateByteCodeSize() >= value2.accumulateByteCodeSize()) {
            if (!this.isSafeToCut(body)) {
                return n2;
            }
            FunctionCallInstruction fc = this.buildFunction(n2, body, "let-body");
            newLet.setBody(fc);
        } else {
            if (!this.isSafeToCut(value2)) {
                return n2;
            }
            FunctionCallInstruction fc = this.buildFunction(n2, value2, "let-value");
            newLet.setValue(fc);
        }
        return newLet.cloneWithoutTypeInformation();
    }

    private Instruction handleStream(StreamInstruction n2) {
        return this.buildFunction(n2, n2, "stream");
    }

    private FunctionCallInstruction buildFunction(Instruction n2, Instruction body, String kind2) {
        if (body instanceof FunctionCallInstruction) {
            return (FunctionCallInstruction)body.cloneWithoutTypeInformation();
        }
        TreeSet<IBinding> freeVarBindings = new TreeSet<IBinding>(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                Comparable s1;
                IBinding b0 = (IBinding)arg0;
                IBinding b1 = (IBinding)arg1;
                if (b0 == b1) {
                    return 0;
                }
                Comparable s0 = (Comparable)b0.getName();
                if (s0.equals(s1 = (Comparable)b1.getName())) {
                    int d = System.identityHashCode(b0) - System.identityHashCode(b1);
                    if (d == 0) {
                        int d2;
                        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                            s_logger.logp(Level.FINE, s_className, "compare", "two objects with the same identity hash code");
                        }
                        if ((d2 = System.identityHashCode(s0) - System.identityHashCode(s1)) == 0) {
                            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                                s_logger.logp(Level.FINE, s_className, "compare", "two objects who have names that have the same identity hash code");
                            }
                            return -1;
                        }
                        return d2;
                    }
                    return d;
                }
                int h = s1.getClass().hashCode() - s0.getClass().hashCode();
                if (h != 0) {
                    return h;
                }
                return s0.compareTo(s1);
            }
        });
        body.accumulateFreeBindings(freeVarBindings, null);
        for (int i = 0; i < this.m_necessaryParameters.length; ++i) {
            IBinding b = n2.getBindingEnvironment().getVariableBinding(this.m_necessaryParameters[i]);
            if (b == null) continue;
            freeVarBindings.add(b);
        }
        IBinding[] bb = Binding.cloneBindings(freeVarBindings.toArray(new IBinding[0]));
        Instruction[] ii = Binding.getIdentifiers(bb);
        if (ii.length > 0) {
            Instruction.propagateInfo(body, ii[0]);
        }
        String id2 = this.m_currentFunction != null ? "outlinedFunction" + this.m_currentFunction.getName() : "outlinedFunction";
        String functionName = OptimizerUtilities.generateIntermediateIdentifier(kind2 + "-" + id2);
        Function outlined = new Function(functionName, (Binding[])bb, body.cloneWithoutTypeInformation());
        if (!this.m_currentFunction.m_resolvedConstraintTypes.isEmpty()) {
            for (Type t : this.m_currentFunction.m_resolvedConstraintTypes.keySet()) {
                outlined.m_resolvedConstraintTypes.put(t, this.m_currentFunction.m_resolvedConstraintTypes.get(t));
            }
        }
        this.getCurrentModule().addFunction(outlined);
        FunctionCallInstruction fc = new FunctionCallInstruction(functionName, ii);
        if (0 < ii.length) {
            Instruction.propagateInfo(ii[0], fc);
        }
        return fc;
    }
}

