/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;

public class SimpleUnflattenStreamOptimizer
extends Optimizer {
    protected int m_limit;

    public SimpleUnflattenStreamOptimizer(int limit) {
        this.m_limit = limit;
    }

    @Override
    public void optimizeFunction(Function f2) {
        if (f2.getName().indexOf("xdm-") == -1) {
            super.optimizeFunction(f2);
        }
    }

    @Override
    protected Instruction optimizeStep(Instruction n2) {
        if (n2 instanceof StreamInstruction) {
            StreamInstruction si = (StreamInstruction)n2;
            if (si.isStoredAsString()) {
                return null;
            }
            int size = n2.accumulateByteCodeSize();
            int c = si.getChildInstructionCount();
            if (this.m_limit > 0 && size > this.m_limit && c > 4) {
                StreamInstruction si2 = (StreamInstruction)si.cloneWithoutTypeInformation();
                si2.split();
                n2 = this.doTypeCheck(n2, si2, n2.getBindingEnvironment());
            }
        }
        return n2;
    }
}

