/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.INewNameGenerator;
import com.ibm.xltxe.rnm1.xylem.ISpecialForm;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.annot.PedanticAnormalForm;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.BeginInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.FindFreeVariables;
import com.ibm.xltxe.rnm1.xylem.optimizers.LetChainClusterizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.optimizers.OrderLetChains;
import com.ibm.xltxe.rnm1.xylem.optimizers.ReducedForm;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SplitFunctions
extends FindFreeVariables {
    private static final Logger s_logger = LoggerUtil.getLogger(SplitFunctions.class);
    private static final String s_className = SplitFunctions.class.getName();
    private Candidate m_best = new Candidate();
    private int m_total;
    private InformationCollector m_info = new InformationCollector();
    private Module m_program;
    private int m_splitSize;
    private boolean m_orderSafeSplit = false;
    public static final int DEFAULT_SPLIT_SIZE = 7500;
    public static final int MAX_PARAMS = 200;
    private static final boolean FORBID_PSES = false;
    private PedanticAnormalForm m_pedantic = new PedanticAnormalForm();
    private int s_suspiciouslyBadCandidates = 0;

    public SplitFunctions(Module p, boolean orderSafeSplit) {
        this(p, 7500);
        this.m_orderSafeSplit = orderSafeSplit;
    }

    public SplitFunctions(Module p, int splitSize) {
        this.m_program = p;
        this.m_splitSize = splitSize;
    }

    public void splitOnce(Function f2) {
        this.prepareFunction(f2);
        this.collectInfo(f2);
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "splitOnce", "forcing split of " + f2.getName() + " at " + this.m_total);
        }
        this.findCandidate(f2);
        if (this.m_best.score < 5.0) {
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Failed to find a split candidate for " + f2.getName() + "; best was score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total});
            s_logger.logp(Level.SEVERE, s_className, "splitOnce", message);
            Program.dumpXylemFunctions(new Function[]{f2}, null, "badsplit");
            throw new XylemError(message);
        }
        if (this.m_best.score < 30.0 && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "splitOnce", "suspiciously bad split candidate for " + f2.getName() + " score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total);
        }
        this.split(f2);
        SplitFunctions.cleanUp(f2);
    }

    @Override
    public void optimizeFunction(Function f2) {
        this.prepareFunction(f2);
        while (true) {
            this.collectInfo(f2);
            this.findCandidate(f2);
            if (this.m_total < this.m_splitSize) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINE, s_className, "optimizeFunction", "function " + f2.getName() + " OK at " + this.m_total);
                }
                SplitFunctions.cleanUp(f2);
                return;
            }
            if (this.m_best.score < 5.0) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "optimizeFunction", "no split candidate for " + f2.getName() + " best was score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total);
                }
                SplitFunctions.cleanUp(f2);
                return;
            }
            if (this.m_best.score < 30.0 && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "optimizeFunction", "suspiciously bad split candidate for " + f2.getName() + " score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total);
            }
            this.split(f2);
        }
    }

    private void prepareFunction(Function f2) {
        new PreSplitter().optimizeFunction(f2);
        this.m_pedantic.optimizeFunction(f2);
        if (this.m_orderSafeSplit) {
            new OrderLetChains().orderFunction(f2);
        } else {
            new LetChainClusterizer().optimizeFunction(f2);
        }
    }

    private static void cleanUp(Function f2) {
    }

    private void collectInfo(Function f2) {
        this.m_best.clear();
        this.m_total = this.m_info.collectInfo(f2);
    }

    private void findCandidate(Function f2) {
        super.optimizeFunction(f2);
    }

    @Override
    protected Instruction optimizeStep(Instruction n2, Instruction parent2, int parentIndex) {
        boolean isValue;
        Object var;
        int size;
        double score;
        this.addVars(n2, parent2, parentIndex);
        if (parent2 instanceof LetInstruction && this.isSplitCandidate(parent2, n2, this.getCurrentFunction(), this.getFreeVars()) && this.m_best.compare(score = this.score(n2, size = this.m_info.getSizeInfo(var = ((LetInstruction)parent2).getVariable(), isValue = parentIndex == 0), this.m_total, this.getFreeVars()))) {
            this.m_best.set(n2, (LetInstruction)parent2, parentIndex, this.getFreeVars(), isValue, score, size);
        }
        this.removeVars(n2, parent2, parentIndex);
        return n2;
    }

    protected double score(Instruction n2, int size, int total, Set freeVars) {
        double s = 1.0 * (double)size / (double)(++total);
        double f2 = (double)freeVars.size() / 200.0;
        return (4.0 * s - 4.0 * s * s - f2 * f2) * 100.0;
    }

    protected int size(Instruction n2, TypeEnvironment tenv, BindingEnvironment benv) {
        if (n2 instanceof LiteralInstruction || n2 instanceof IdentifierInstruction || n2 instanceof StreamInstruction && ((StreamInstruction)n2).isString()) {
            return -1;
        }
        if (n2 instanceof StreamInstruction) {
            int size = 4;
            for (int i = 0; i < n2.getChildInstructionCount(); ++i) {
                Instruction n22 = n2.getChildInstruction(i);
                if (n22 instanceof LiteralInstruction) {
                    ++size;
                }
                if (n22.getType(tenv, benv) instanceof StreamType) {
                    size += 4;
                    continue;
                }
                size += 2;
            }
            return -size;
        }
        if (n2 instanceof ConstructorInstantiationInstruction) {
            return -(4 + 4 * n2.getChildInstructionCount());
        }
        int size = 2;
        if (n2 instanceof LambdaInstruction) {
            size += 2 * SplitFunctions.findFreeVariables(n2).size();
        }
        if (n2 instanceof MatchInstruction || n2 instanceof ChooseInstruction) {
            size += 4;
        }
        if (n2 instanceof MatchInstruction) {
            size += 2 * ((MatchInstruction)n2).getMatches().length;
        }
        if (n2 instanceof ISpecialForm) {
            ISpecialForm sf = (ISpecialForm)((Object)n2);
            for (int i = 0; i < n2.getChildInstructionCount(); ++i) {
                IBinding[] bb = sf.getChildInstructionBindings(i);
                if (bb == null) continue;
                size += 2 * bb.length;
            }
        }
        return size;
    }

    protected boolean isSplitCandidate(Instruction parent2, Instruction n2, Function f2, Set freeVars) {
        if (n2 instanceof FunctionCallInstruction) {
            return false;
        }
        if (n2 instanceof LetInstruction && ((LetInstruction)n2).getBody() instanceof IdentifierInstruction && ((LetInstruction)n2).getValue() instanceof FunctionCallInstruction) {
            return false;
        }
        for (Object v : freeVars) {
            Type t = new IdentifierInstruction(v).getType(f2.getTypeEnvironment(), f2.getBindingEnvironment());
            if (!((t = StreamType.makeAtomicType(t)) instanceof NamedType)) continue;
            AbstractDataType adt = ((NamedType)t).resolveNameToADT(f2.getTypeEnvironment());
        }
        return true;
    }

    private void split(Function f2) {
        if (this.m_best.n == null) {
            throw new XylemError("ERR_SYSTEM", "corrupt!");
        }
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "split", "splitting " + (this.m_best.isValue ? "value" : "body") + " score=" + this.m_best.score + " size=" + this.m_best.size + " / " + this.m_total + "\n   " + f2.getName());
        }
        if (this.m_orderSafeSplit) {
            ArrayList<Object> orderedVars = OrderLetChains.OrderedFreeVariables.findFreeVariables(this.m_best.n);
            SplitFunctions.split(this.m_best.n, orderedVars, this.m_best.parent, this.m_best.parentIndex, f2, this.m_program);
        } else {
            SplitFunctions.split(this.m_best.n, this.m_best.freeVars, this.m_best.parent, this.m_best.parentIndex, f2, this.m_program);
        }
    }

    private static void split(Instruction body, Collection freeVars, Instruction parent2, int parentIndex, Function enclosingFunction, Module m) {
        String message;
        ReducedForm.Check.check(enclosingFunction);
        Object[] vars = freeVars.toArray();
        ArrayList<IdentifierInstruction> args = new ArrayList<IdentifierInstruction>(vars.length);
        ArrayList<Binding> params = new ArrayList<Binding>(vars.length);
        HashMap map2 = new HashMap();
        INewNameGenerator ng = new INewNameGenerator(){
            private int m_count;

            @Override
            public Object getNewName() {
                return new Integer(this.m_count++);
            }
        };
        HashMap<Object, IdentifierInstruction> names = new HashMap<Object, IdentifierInstruction>();
        Type rtnType = body.getType(enclosingFunction.getTypeEnvironment(), enclosingFunction.getBindingEnvironment());
        for (int i = 0; i < vars.length; ++i) {
            Object v = ng.getNewName();
            names.put(vars[i], new IdentifierInstruction(v));
            IdentifierInstruction a = new IdentifierInstruction(vars[i]);
            args.add(a);
            Type t = a.getType(enclosingFunction.getTypeEnvironment(), enclosingFunction.getBindingEnvironment());
            Type t2 = StreamType.makeAtomicType(t);
            if (t == null) {
                throw new XylemError("ERR_SYSTEM", "?" + vars[i]);
            }
            params.add(new Binding(v, t));
        }
        String fName = enclosingFunction.getName() + "$split$" + ReductionHelper.generateIntermediateIdentifier2();
        FunctionCallInstruction replacement = new FunctionCallInstruction(fName, args);
        body = body.cloneWithoutTypeInformation().assignNewNames(names, ng);
        Function f2 = new Function(fName, params.toArray(new Binding[0]), body);
        m.addFunction(f2);
        SplitFunctions.cleanUp(f2);
        parent2.setChildInstruction(parentIndex, replacement);
        try {
            f2.typeCheckReduced(m, new LinkedList());
        }
        catch (Exception e) {
            FFDCUtil.log(e, SplitFunctions.class);
            message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"TCE in new function " + f2});
            s_logger.logp(Level.SEVERE, s_className, "split", message, e);
            throw new RuntimeException(message);
        }
        try {
            enclosingFunction.typeCheckReduced(m, new LinkedList());
        }
        catch (Exception e) {
            FFDCUtil.log(e, SplitFunctions.class);
            message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"TCE in modified enclosing function " + enclosingFunction});
            s_logger.logp(Level.SEVERE, s_className, "split", message, e);
            throw new RuntimeException(message);
        }
        ReducedForm.Check.check(enclosingFunction);
        ReducedForm.Check.check(f2);
    }

    private static class PreSplitter
    extends Optimizer {
        final int CHUNK = 500;

        private PreSplitter() {
        }

        Instruction preSplitBegin(Instruction n2, Instruction parent2, int parentIndex) {
            if (n2.getChildInstructionCount() > 500) {
                LinkedList<Instruction> children = new LinkedList<Instruction>(Arrays.asList(((BeginInstruction)n2).getOperands()));
                Instruction body = children.removeLast();
                while (!children.isEmpty()) {
                    int start = children.size() - 500;
                    if (start < 0) {
                        start = 0;
                    }
                    List lastChunk = children.subList(start, children.size());
                    ArrayList<Instruction> newBegin = new ArrayList<Instruction>(lastChunk);
                    newBegin.add(body);
                    body = new BeginInstruction(newBegin.toArray(new Instruction[0]));
                    lastChunk.clear();
                }
                body.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList<Function>());
                return body;
            }
            return n2;
        }

        Instruction preSplitMatch(Instruction n2, Instruction parent2, int parentIndex) {
            if (n2.getChildInstructionCount() > 1000) {
                MatchInstruction mi = (MatchInstruction)n2;
                Instruction otherwise = ((MatchInstruction)n2).getDefault();
                ArrayList<MatchInstruction.Match> matches2 = new ArrayList<MatchInstruction.Match>(Arrays.asList(((MatchInstruction)n2).getMatches()));
                while (!matches2.isEmpty()) {
                    int start = matches2.size() - 500;
                    if (start < 0) {
                        start = 0;
                    }
                    List lastChunk = matches2.subList(start, matches2.size());
                    otherwise = new MatchInstruction(mi.getToMatch(), lastChunk, otherwise);
                    lastChunk.clear();
                }
                otherwise.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList<Function>());
                return otherwise;
            }
            return n2;
        }

        Instruction preSplitLetStream(Instruction n2, Instruction parent2, int parentIndex) {
            StreamInstruction si = (StreamInstruction)((LetInstruction)n2).getValue();
            if (si instanceof StreamInstruction && !si.isString() && si.getChildInstructionCount() > 501) {
                StreamInstruction oldStream = si;
                LetChainBuilder lcb = new LetChainBuilder();
                while (oldStream.getChildInstructionCount() > 500) {
                    List<Instruction> children = Arrays.asList(oldStream.getElements());
                    ArrayList<Instruction> chunkValues = new ArrayList<Instruction>();
                    for (int start = 0; start < children.size(); start += 500) {
                        int end = start + 500;
                        end = end > children.size() ? children.size() : end;
                        ArrayList<Instruction> newStream = new ArrayList<Instruction>(children.subList(start, end));
                        chunkValues.add(lcb.bind(new StreamInstruction(oldStream.getElementType(), newStream)));
                    }
                    oldStream = new StreamInstruction(oldStream.getElementType(), chunkValues);
                }
                ((LetInstruction)n2).setValue(oldStream);
                n2 = lcb.packageUp(n2);
                n2.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList<Function>());
            }
            return n2;
        }

        @Override
        protected Instruction optimizeStep(Instruction n2, Instruction parent2, int parentIndex) {
            if (n2 instanceof BeginInstruction) {
                return this.preSplitBegin(n2, parent2, parentIndex);
            }
            if (n2 instanceof LetInstruction && ((LetInstruction)n2).getValue() instanceof StreamInstruction) {
                return this.preSplitLetStream(n2, parent2, parentIndex);
            }
            return n2;
        }
    }

    private static class Candidate {
        private Instruction n = null;
        private LetInstruction parent = null;
        private int parentIndex = -1;
        private Set freeVars = new HashSet();
        private boolean isValue = false;
        private double score = 0.0;
        private int size = 0;

        private Candidate() {
        }

        public boolean compare(double newScore) {
            return this.score < newScore;
        }

        public void clear() {
            this.n = null;
            this.parent = null;
            this.parentIndex = -1;
            this.freeVars = new HashSet();
            this.isValue = false;
            this.score = 0.0;
            this.size = 0;
        }

        public void set(Instruction n2, LetInstruction p, int pI, Set freeVars, boolean val, double score, int size) {
            this.n = n2;
            this.parent = p;
            this.parentIndex = pI;
            this.freeVars.clear();
            this.freeVars.addAll(freeVars);
            this.isValue = val;
            this.score = score;
            this.size = size;
        }
    }

    private class InformationCollector {
        private HashMap m_valueSizes = new HashMap();
        private HashMap m_bodySizes = new HashMap();
        private HashMap m_beginSizes = new HashMap();

        private InformationCollector() {
        }

        public int collectInfo(Function f2) {
            this.m_bodySizes.clear();
            this.m_valueSizes.clear();
            return this.collectSize(f2.getBody(), f2.getTypeEnvironment(), f2.getBindingEnvironment());
        }

        public int collectSize(Instruction n2, TypeEnvironment tenv, BindingEnvironment benv) {
            if (!(n2 instanceof LetInstruction)) {
                int size = SplitFunctions.this.size(n2, tenv, benv);
                if (size < 0) {
                    size = -size;
                } else {
                    for (int i = 0; i < n2.getChildInstructionCount(); ++i) {
                        size += this.collectSize(n2.getChildInstruction(i), tenv, benv);
                    }
                }
                return size;
            }
            Instruction outer = n2;
            LinkedList<LetInstruction> letList = new LinkedList<LetInstruction>();
            int bSize = this.collectSize(OptimizerUtilities.skipLets(n2, letList), tenv, benv);
            LetInstruction[] lets = letList.toArray(new LetInstruction[0]);
            for (int i = lets.length - 1; i >= 0; --i) {
                int vSize = this.collectSize(lets[i].getValue(), tenv, benv);
                this.m_valueSizes.put(lets[i].getVariable(), new Integer(vSize));
                this.m_bodySizes.put(lets[i].getVariable(), new Integer(bSize));
                bSize += vSize;
            }
            return bSize;
        }

        public int getSizeInfo(Object var, boolean isValue) {
            if (isValue) {
                return (Integer)this.m_valueSizes.get(var);
            }
            return (Integer)this.m_bodySizes.get(var);
        }
    }
}

