/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.builders.LetChainBuilder;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamElementInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.SubstreamInstruction;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import java.util.ArrayList;
import java.util.LinkedList;

public class StaticStringTableOptimizer
extends Optimizer {
    @Override
    protected Instruction optimizeStep(Instruction n2) {
        block3: {
            MatchInstruction.Match[] mim;
            MatchInstruction mi;
            if (n2 instanceof MatchInstruction && (mi = (MatchInstruction)n2).getDefault() == null && (mim = mi.getMatches())[0] instanceof MatchInstruction.LiteralMatch) {
                StringBuffer sb = new StringBuffer();
                ArrayList<String> strings2 = new ArrayList<String>();
                ArrayList<Integer> offsets = new ArrayList<Integer>();
                ArrayList<LiteralInstruction> offsetInstructions = new ArrayList<LiteralInstruction>();
                ArrayList<LiteralInstruction> lengthInstructions = new ArrayList<LiteralInstruction>();
                for (int i = 0; i < mim.length; ++i) {
                    StreamInstruction si;
                    if (mim[i].getHandler() instanceof StreamInstruction && ((MatchInstruction.LiteralMatch)mim[i]).getLiteral().getValue().equals(new Integer(i)) && (si = (StreamInstruction)mim[i].getHandler()).isString()) {
                        String s = si.getStringContent();
                        int offset = sb.length();
                        offsets.add(new Integer(offset));
                        sb.append(s);
                        strings2.add(s);
                        offsetInstructions.add(LiteralInstruction.integerLiteral(offset));
                        lengthInstructions.add(LiteralInstruction.integerLiteral(s.length()));
                        continue;
                    }
                    break block3;
                }
                LetChainBuilder lcb = new LetChainBuilder();
                Instruction stringPool = lcb.bind(StreamInstruction.charStreamLiteral(sb.toString()));
                Instruction offsetsIntoPool = lcb.bind(new StreamInstruction((Type)IntType.s_intType, offsetInstructions));
                Instruction lengthsInPool = lcb.bind(new StreamInstruction((Type)IntType.s_intType, lengthInstructions));
                Instruction actualOffset = lcb.bind(new StreamElementInstruction(offsetsIntoPool, mi.getToMatch()));
                Instruction actualLength = lcb.bind(new StreamElementInstruction(lengthsInPool, mi.getToMatch()));
                Instruction actualString = lcb.bind(new SubstreamInstruction(stringPool, actualOffset, actualLength, true));
                ChooseInstruction ci = new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), lcb.packageUp(actualString), null);
                ci.typeCheckReduced(this.getCurrentFunction().getTypeEnvironment(), this.getCurrentFunction().getBindingEnvironment(), new LinkedList<Function>());
                return ci;
            }
        }
        return super.optimizeStep(n2);
    }
}

