/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import java.util.ArrayList;

public class TerminalLetOptimizer
extends Optimizer {
    @Override
    public void optimizeFunction(Function f2) {
        super.optimizeFunction(f2);
    }

    @Override
    protected Instruction optimizeStep(Instruction n2) {
        if (n2 instanceof LetInstruction) {
            ArrayList<LetInstruction> letList = new ArrayList<LetInstruction>();
            n2 = OptimizerUtilities.skipLets(n2, letList);
            LetInstruction[] lets = letList.toArray(new LetInstruction[0]);
            for (int i = 0; i < lets.length; ++i) {
                lets[i].setValue(this.optimize(lets[i].getValue()));
            }
            LetInstruction last2 = lets[lets.length - 1];
            if (last2.getBody() instanceof IdentifierInstruction) {
                Object v = ((IdentifierInstruction)last2.getBody()).getVariable();
                if (v.equals(last2.getVariable())) {
                    Instruction val = this.optimize(last2.getValue());
                    if (lets.length == 1) {
                        return val;
                    }
                    lets[lets.length - 2].setBody(val);
                }
            } else {
                last2.setBody(this.optimize(last2.getBody()));
            }
            return null;
        }
        return n2;
    }
}

