/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.DataDependencyDrivenOptimizer;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.ForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ParallelForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ProcessStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamElementInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleMatchInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.optimizers.ParallelForEachOptimizer;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TupleOptimizer
extends Optimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(TupleOptimizer.class);
    private static final String s_className = TupleOptimizer.class.getName();
    private HashMap m_tupleUseInfo = new HashMap();
    private int m_reductions = 0;
    private int m_totalCTors = 0;
    private int m_removedCTors = 0;
    private int m_totalMatches = 0;
    private int m_removedMatches = 0;
    private int m_totalPFEIs = 0;
    private int m_reducedPFEIs = 0;

    public void optimize(Module m) {
        try {
            InformationCollector collector = new InformationCollector(m);
            TupleReducer reducer = new TupleReducer();
            TupleRemover remover = new TupleRemover();
            ParallelForEachOptimizer pfeo = new ParallelForEachOptimizer();
            do {
                DeadLetEliminatorOptimizer.eliminateDeadLets(m);
                m.optimize(pfeo);
                this.m_reductions = 0;
                this.m_tupleUseInfo.clear();
                m.optimize(collector);
                m.optimize(reducer);
                m.clearTypeInformation(true);
                m.typeCheck();
                if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINER)) continue;
                s_logger.logp(Level.FINER, s_className, "optimize", "Removed " + this.m_reductions + " tuple or tuple-match arguments.");
            } while (this.m_reductions > 0);
            m.optimize(remover);
            m.clearTypeInformation(true);
            m.typeCheck();
            m.reduce();
            m.typeCheck();
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "optimize", "Removed " + this.m_removedCTors + "/" + this.m_totalCTors + " tuple instructions.\n" + "Removed " + this.m_removedMatches + "/" + this.m_totalMatches + " tuple-match instructions.\n" + "Simplified " + this.m_reducedPFEIs + "/" + this.m_totalPFEIs + " parallel-foreach instructions.");
            }
        }
        catch (Throwable t) {
            FFDCUtil.log(t, this);
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{""});
            s_logger.logp(Level.SEVERE, s_className, "optimize", message, t);
            throw new XylemError(message);
        }
    }

    private static String getInstanceKey(Type t) {
        return "tuple" + System.identityHashCode(t);
    }

    private TupleUseInfo registerTuple(TupleType tt) {
        TupleUseInfo tui;
        String instanceKey = TupleOptimizer.getInstanceKey(tt);
        Object o = this.m_tupleUseInfo.get(instanceKey);
        if (o == null) {
            tui = new TupleUseInfo(tt);
            this.m_tupleUseInfo.put(instanceKey, tui);
        } else {
            while (o instanceof String) {
                o = this.m_tupleUseInfo.get(o);
            }
            tui = (TupleUseInfo)o;
        }
        return tui;
    }

    private void registerTuple(TupleType tt, TupleUseInfo tui) {
        String name2 = TupleOptimizer.getInstanceKey(tt);
    }

    private TupleUseInfo getInfo(Instruction n2, TypeEnvironment tenv) {
        Type t = n2.getCachedType();
        String k = TupleOptimizer.getInstanceKey(t);
        Object o = this.m_tupleUseInfo.get(k);
        while (o instanceof String) {
            o = this.m_tupleUseInfo.get(o);
        }
        TupleUseInfo tui = (TupleUseInfo)o;
        if (tui == null && t instanceof TupleType && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
            s_logger.logp(Level.FINE, s_className, "getInfo", "missing entry for tuple " + k + " at " + n2);
        }
        return tui;
    }

    private static class TupleUseInfo {
        private TupleType m_type;
        private boolean[] m_used;
        private String m_name;

        private TupleUseInfo(TupleType tt) {
            this.m_type = tt;
            this.m_used = new boolean[tt.getChildTypeCount()];
            this.m_name = TupleOptimizer.getInstanceKey(tt);
        }

        private void mergeInfo(TupleUseInfo tui) {
            for (int i = 0; i < tui.m_used.length; ++i) {
                if (!tui.m_used[i]) continue;
                this.setUsed(i);
            }
        }

        private void setUsed(int i) {
            this.m_used[i] = true;
        }

        private void setAllUsed() {
            for (int i = 0; i < this.m_used.length; ++i) {
                this.m_used[i] = true;
            }
        }

        private String getName() {
            return this.m_name;
        }

        public String toString() {
            return this.getName();
        }

        private boolean isFullyUsed() {
            for (int i = 0; i < this.m_used.length; ++i) {
                if (this.m_used[i]) continue;
                return false;
            }
            return true;
        }
    }

    private class TupleRemover
    extends Optimizer {
        private TupleRemover() {
        }

        @Override
        protected Instruction optimizeStep(Instruction n2) {
            TypeEnvironment tenv = this.getCurrentFunction().getTypeEnvironment();
            if (n2 instanceof TupleInstruction) {
                TupleOptimizer.this.m_totalCTors++;
                TupleInstruction ti = (TupleInstruction)n2;
                if (ti.getChildInstructionCount() == 1) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                        s_logger.logp(Level.FINEST, s_className, "optimizeStep", "removed " + ti);
                    }
                    TupleOptimizer.this.m_removedCTors++;
                    Instruction n22 = ti.getChildInstruction(0);
                    this.optimizeChildren(n22);
                    return n22;
                }
            } else if (n2 instanceof TupleMatchInstruction) {
                TupleOptimizer.this.m_totalMatches++;
                TupleMatchInstruction tmi = (TupleMatchInstruction)n2;
                if (tmi.getVariableNames().length == 1) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                        s_logger.logp(Level.FINEST, s_className, "optimizeStep", "removed " + tmi);
                    }
                    TupleOptimizer.this.m_removedMatches++;
                    LetInstruction n23 = new LetInstruction(tmi.getVariableNames()[0], tmi.getToMatch(), tmi.getBody());
                    this.optimizeChildren(n23);
                    return n23;
                }
            } else if (n2 instanceof ParallelForEachInstruction) {
                TupleType tt;
                TupleOptimizer.this.m_totalPFEIs++;
                ParallelForEachInstruction pfei = (ParallelForEachInstruction)n2;
                Type t = pfei.getCachedType();
                if (t instanceof TupleType && (tt = (TupleType)t).getChildTypeCount() == 1) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
                        s_logger.logp(Level.FINEST, s_className, "optimizeStep", "removed " + pfei);
                    }
                    TupleOptimizer.this.m_reducedPFEIs++;
                    Object indexVar = pfei.getIndexVar();
                    Instruction body = pfei.getBody();
                    if (pfei.getElementVars().length > 1) {
                        if (indexVar == null) {
                            indexVar = OptimizerUtilities.generateIntermediateIdentifier("index");
                        }
                        for (int i = 1; i < pfei.getElementVars().length; ++i) {
                            IdentifierInstruction index2 = new IdentifierInstruction(indexVar);
                            StreamElementInstruction src = new StreamElementInstruction(pfei.getSources()[i], index2);
                            body = new LetInstruction(pfei.getElementVars()[i], src, body);
                        }
                    }
                    Object var1 = pfei.getElementVars()[0];
                    Instruction source1 = pfei.getSources()[0];
                    ForEachInstruction n24 = new ForEachInstruction(source1, var1, indexVar, body);
                    this.optimizeChildren(n24);
                    return n24;
                }
            }
            return n2;
        }
    }

    private class InformationCollector
    extends DataDependencyDrivenOptimizer {
        private Module m_module;
        private HashMap m_tupleCopyMap = new HashMap();

        private InformationCollector(Module m) {
            this.m_module = m;
        }

        @Override
        public void optimizeFunction(Function f2) {
            this.clearTupleCopyMap();
            if (f2.getReturnType() instanceof TupleType && this.m_module.getPublicFunction(f2.getName()) != null) {
                TupleType tt = (TupleType)f2.getReturnType();
                TupleOptimizer.this.registerTuple(tt).setAllUsed();
            }
            super.optimizeFunction(f2);
        }

        @Override
        protected Instruction optimizeStep(Instruction n2) {
            TypeEnvironment tenv = this.getCurrentFunction().getTypeEnvironment();
            BindingEnvironment benv = this.getCurrentFunction().getBindingEnvironment();
            this.clearTupleCopyMap();
            if (n2 instanceof TupleMatchInstruction) {
                TupleMatchInstruction tmi = (TupleMatchInstruction)n2;
                Binding[] bindings = tmi.getBindings();
                TupleType tt = (TupleType)tmi.getToMatch().getType(tenv, benv);
                for (int i = 0; i < bindings.length; ++i) {
                    Binding b = bindings[i];
                    if (b == null) {
                        throw new XylemError("ERR_SYSTEM", "tuple match binding (" + i + ") " + "has null binding (or no dependancy info) " + tmi);
                    }
                    if (!this.isBindingUsed(bindings[i])) continue;
                    TupleOptimizer.this.registerTuple(tt).setUsed(i);
                }
            } else {
                if (n2 instanceof ProcessStreamInstruction) {
                    ProcessStreamInstruction psi = (ProcessStreamInstruction)n2;
                    TupleUseInfo tui = TupleOptimizer.this.registerTuple((TupleType)psi.getChildInstruction(2).getType(tenv, benv));
                    tui.setAllUsed();
                }
                if (n2.getCachedType() instanceof TupleType) {
                    this.registerTupleInstruction(n2, tenv);
                    if (n2 instanceof IdentifierInstruction) {
                        Instruction n22 = NavigationUtilities.resolveReducedIdentifier(n2, benv);
                        this.registerTupleInstruction(n22, tenv);
                    }
                }
                for (int i = 0; i < n2.getChildInstructionCount(); ++i) {
                    if (!(n2.getChildInstruction(i).getCachedType() instanceof TupleType)) continue;
                    this.registerTupleInstruction(n2.getChildInstruction(i), tenv);
                }
            }
            return n2;
        }

        private void clearTupleCopyMap() {
            this.m_tupleCopyMap.clear();
        }

        private void registerTupleInstruction(Instruction n2, TypeEnvironment tenv) {
            TupleType tt = (TupleType)n2.getCachedType();
            String instanceKey = TupleOptimizer.getInstanceKey(tt);
            String typeKey = this.getTypeKey(n2, tenv);
            TupleUseInfo tui = TupleOptimizer.this.registerTuple(tt);
            TupleUseInfo tuiCopy = (TupleUseInfo)this.m_tupleCopyMap.get(typeKey);
            if (tuiCopy != null && tuiCopy != tui) {
                tuiCopy.mergeInfo(tui);
                TupleOptimizer.this.m_tupleUseInfo.put(instanceKey, tuiCopy.getName());
            } else {
                this.m_tupleCopyMap.put(typeKey, tui);
            }
        }

        private String getTypeKey(Instruction n2, TypeEnvironment tenv) {
            TupleType t = (TupleType)n2.getCachedType();
            StringBuffer sb = new StringBuffer("tuple");
            for (int i = 0; i < t.getChildTypeCount(); ++i) {
                sb.append("_");
                Type ct = t.getChildType(i).resolveType(this.m_currentFunction.getTypeEnvironment());
                if (ct instanceof TypeVariable) {
                    throw new Error("!");
                }
                sb.append(ct);
            }
            return sb.toString();
        }
    }

    private class TupleReducer
    extends Optimizer {
        private TupleReducer() {
        }

        @Override
        protected Instruction optimizeStep(Instruction n2) {
            TypeEnvironment tenv = this.getCurrentFunction().getTypeEnvironment();
            if (n2 instanceof TupleInstruction) {
                TupleUseInfo tui = TupleOptimizer.this.getInfo(n2, tenv);
                if (tui == null || tui.isFullyUsed()) {
                    return n2;
                }
                TupleInstruction ti = (TupleInstruction)n2;
                ArrayList<Instruction> params = new ArrayList<Instruction>();
                for (int i = 0; i < ti.getChildInstructionCount(); ++i) {
                    if (!tui.m_used[i]) continue;
                    params.add(ti.getChildInstruction(i).cloneWithoutTypeInformation());
                }
                TupleInstruction n22 = new TupleInstruction(params.toArray(new Instruction[0]));
                this.optimizeChildren(n22);
                String name2 = tui.getName();
                TupleOptimizer.this.m_reductions += ti.getChildInstructionCount() - ((Instruction)n22).getChildInstructionCount();
                return n22;
            }
            if (n2 instanceof TupleMatchInstruction) {
                TupleMatchInstruction tmi = (TupleMatchInstruction)n2;
                Instruction toMatch = tmi.getToMatch();
                TupleUseInfo tui = TupleOptimizer.this.getInfo(toMatch, tenv);
                if (tui == null || tui.isFullyUsed()) {
                    return n2;
                }
                ArrayList<Object> params = new ArrayList<Object>();
                for (int i = 0; i < tmi.getVariableNames().length; ++i) {
                    if (!tui.m_used[i]) continue;
                    params.add(tmi.getVariableNames()[i]);
                }
                TupleMatchInstruction n23 = new TupleMatchInstruction(toMatch.cloneWithoutTypeInformation(), params.toArray(), tmi.getBody());
                this.optimizeChildren(n23);
                String name3 = tui.getName();
                TupleOptimizer.this.m_reductions += tmi.getVariableNames().length - params.size();
                return n23;
            }
            return n2;
        }
    }
}

