/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.PostOrderOptimizer;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.CompoundType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.VirtualDataTypeMap;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VDTMapOptimizer
extends PostOrderOptimizer {
    private static final Logger s_logger = LoggerUtil.getLogger(VDTMapOptimizer.class);
    private static final String s_className = VDTMapOptimizer.class.getName();
    private VirtualDataTypeMap m_vdtmap = null;
    private Set m_functionsToUpdate = new HashSet();
    List deltas = new ArrayList();
    Map m_map;

    private VDTMapOptimizer() {
    }

    public VDTMapOptimizer(VirtualDataTypeMap map2) {
        this.m_vdtmap = map2;
    }

    @Override
    protected Instruction optimizeStep(Instruction n2) {
        if (n2 instanceof MatchInstruction) {
            Instruction matchCode;
            MatchInstruction mi = (MatchInstruction)n2;
            MatchInstruction.Match match0 = mi.getMatches()[0];
            if (!(match0 instanceof MatchInstruction.DeconstructionMatch)) {
                return n2;
            }
            Instruction toMatch = mi.getToMatch();
            AbstractDataType adt = ((MatchInstruction.DeconstructionMatch)match0).getConstructor().getAbstractDataType();
            if (adt == null || !this.m_vdtmap.hasVDTMapping(adt.getName())) {
                return n2;
            }
            VirtualDataTypeMap.ADTMapping adtm = this.m_vdtmap.getVDTMapping(adt.getName());
            MatchInstruction.Match[] arms = mi.getMatches();
            MatchInstruction.Match[] replacementArms = new MatchInstruction.Match[arms.length];
            for (int i = 0; i < arms.length; ++i) {
                int variantIndex;
                LetInstruction li;
                Instruction replacement;
                if (arms[i] instanceof MatchInstruction.DeconstructionMatch) {
                    Instruction deconstructOps;
                    MatchInstruction.DeconstructionMatch dm = (MatchInstruction.DeconstructionMatch)arms[i];
                    Instruction body = dm.getHandler();
                    String constructorName = dm.getConstructor().getName();
                    Object[] paramNames = dm.getConstructor().getParameterNames();
                    Binding[] deconstructionBindings = dm.getBindings();
                    if (!adtm.m_constructors.containsKey(constructorName)) {
                        throw new XylemError("ERR_SYSTEM", "VDTMap for type:" + adt.getName() + " doesn't specify mapping for constructor:" + constructorName);
                    }
                    VirtualDataTypeMap.ConstructorMapping cm = (VirtualDataTypeMap.ConstructorMapping)adtm.m_constructors.get(constructorName);
                    HashMap<Object, IdentifierInstruction> namemap = new HashMap<Object, IdentifierInstruction>();
                    Integer ident = ReductionHelper.generateIntermediateIdentifier2();
                    namemap.put(cm.m_deconstructVariable.getName(), new IdentifierInstruction(ident));
                    Instruction findTuple = deconstructOps = cm.m_deconstructCode.assignNewNames(namemap);
                    LetInstruction tuple_parent = null;
                    while (findTuple instanceof LetInstruction) {
                        LetInstruction li2 = (LetInstruction)findTuple;
                        findTuple = li2.getBody();
                        tuple_parent = li2;
                    }
                    if (!(findTuple instanceof TupleInstruction)) {
                        throw new XylemError("ERR_SYSTEM", "VDTMap match code should bottom out into a tuple instruction");
                    }
                    Instruction[] ids = ((TupleInstruction)findTuple).getOperands();
                    if (paramNames.length != ids.length) {
                        throw new XylemError("ERR_SYSTEM", "VDTMap for type:" + adt.getName() + " constructor:" + constructorName + " specifies " + paramNames.length + " parameters, but the ADT map requires " + ids.length);
                    }
                    replacement = body;
                    for (int j = 0; j < ids.length; ++j) {
                        LetInstruction li3 = new LetInstruction(deconstructionBindings[j].getName(), ids[j], replacement);
                        replacement = li3;
                    }
                    if (tuple_parent != null) {
                        tuple_parent.setBody(replacement);
                        li = new LetInstruction(ident, toMatch, deconstructOps);
                    } else {
                        li = new LetInstruction(ident, toMatch, replacement);
                    }
                    variantIndex = -1;
                    for (int k = 0; k < adt.m_constructors.length; ++k) {
                        if (!adt.m_constructors[k].getName().equals(constructorName)) continue;
                        variantIndex = k;
                        break;
                    }
                    if (variantIndex == -1) {
                        throw new XylemError("ERR_SYSTEM", "could not find variant " + constructorName);
                    }
                } else {
                    throw new XylemError("ERR_SYSTEM", "VDTMap for type:" + adt.getName() + " must be a deconstruction match!");
                }
                replacement = li;
                replacementArms[i] = new MatchInstruction.LiteralMatch(LiteralInstruction.integerLiteral(variantIndex), replacement.cloneWithNewNames());
            }
            HashMap<Object, Instruction> namemap = new HashMap<Object, Instruction>();
            namemap.put(adtm.m_matchVariable.getName(), toMatch);
            Instruction i = matchCode = adtm.m_matchCode.assignNewNames(namemap);
            LetInstruction i_parent = null;
            while (i instanceof LetInstruction) {
                LetInstruction li = (LetInstruction)i;
                i = li.getBody();
                i_parent = li;
            }
            if (!(i instanceof TupleInstruction)) {
                throw new XylemError("ERR_SYSTEM", "VDTMap match instruction should bottom out into a tuple instruction");
            }
            int idCount = ((TupleInstruction)i).getOperandCount();
            Instruction[] ids = ((TupleInstruction)i).getOperands();
            if (idCount != 1) {
                throw new XylemError("ERR_SYSTEM", "VDTMap toMatch should have a single returned identifier. Buh?");
            }
            if (!(ids[0] instanceof IdentifierInstruction)) {
                throw new XylemError("ERR_SYSTEM", "VDTMap toMatch must be an identifier :" + ids[0] + ":");
            }
            IdentifierInstruction id2 = (IdentifierInstruction)ids[0];
            MatchInstruction replacementMatch = new MatchInstruction((Instruction)id2, replacementArms, mi.getDefault(), mi.canAssumeComplete());
            i_parent.setBody(replacementMatch);
            ChooseInstruction wrap2 = new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), matchCode, null);
            this.m_functionsToUpdate.add(this.m_currentFunction);
            return wrap2.cloneWithNewNames();
        }
        if (n2 instanceof ConstructorInstantiationInstruction) {
            ConstructorInstantiationInstruction cii = (ConstructorInstantiationInstruction)n2;
            AbstractDataType adt = cii.getConstructor().getAbstractDataType();
            if (adt == null || !this.m_vdtmap.hasVDTMapping(adt.getName())) {
                return n2;
            }
            VirtualDataTypeMap.ADTMapping adtm = this.m_vdtmap.getVDTMapping(adt.getName());
            if (!adtm.m_constructors.containsKey(cii.getConstructorName())) {
                throw new XylemError("ERR_SYSTEM", "VDTMap for type:" + adt.getName() + " doesn't specify mapping for constructor:" + cii.getConstructorName());
            }
            VirtualDataTypeMap.ConstructorMapping cm = (VirtualDataTypeMap.ConstructorMapping)adtm.m_constructors.get(cii.getConstructorName());
            Binding[] params = cm.m_constructParameters;
            Instruction[] ops = cii.getOperands();
            if (params.length != ops.length) {
                throw new XylemError("ERR_SYSTEM", "VDTMap for type:" + adt.getName() + " constructor:" + cii.getConstructorName() + " specifies " + params.length + " parameters, but the ADT map requires " + ops.length);
            }
            Instruction replacement = cm.m_constructCode;
            for (int i = 0; i < params.length; ++i) {
                LetInstruction li = new LetInstruction(params[i].getName(), ops[i], replacement);
                replacement = li;
            }
            ChooseInstruction ci = new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), replacement, null);
            replacement = ci;
            this.m_functionsToUpdate.add(this.m_currentFunction);
            return replacement.cloneWithNewNames();
        }
        int c = n2.getTypeParameterCount();
        for (int i = 0; i < c; ++i) {
            if (n2.getTypeParameter(i) == null) {
                throw new RuntimeException();
            }
            n2.setTypeParameter(i, this.convertType(n2.getTypeParameter(i)));
        }
        return n2;
    }

    public void doUpdate(Module m) {
        Iterator ii = this.m_vdtmap.vdtMappingNames().iterator();
        this.m_map = new HashMap();
        while (ii.hasNext()) {
            String name2 = (String)ii.next();
            CompoundType c1 = m.lookupCompoundType(name2);
            if (c1 == null) continue;
            NamedType c = c1.getNamedType();
            this.m_map.put(c, this.m_vdtmap.getTargetType(name2));
        }
        m.optimize(this);
        ModuleSignature ms = m.m_signature;
        if (this.m_functionsToUpdate.isEmpty() && this.deltas.isEmpty()) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                s_logger.logp(Level.FINER, s_className, "doUpdate", "Skipping update for module :" + m.getName() + ":");
            }
            return;
        }
        for (Delta d : this.deltas) {
            if (d.enclosingFunction != null) {
                d.enclosingFunction.setBody(d.replacement.cloneWithNewNames());
                continue;
            }
            d.parent.setChildInstruction(d.index, d.replacement.cloneWithNewNames());
        }
        this.deltas.clear();
        for (Function f2 : this.m_functionsToUpdate) {
            Binding[] b = f2.getParameters();
            Type returnType = f2.getReturnType();
            ii = this.m_vdtmap.vdtMappingNames().iterator();
            TypeEnvironment tenv = f2.getTypeEnvironment();
            while (ii.hasNext()) {
                String name3 = (String)ii.next();
                CompoundType c1 = f2.getTypeEnvironment().getModule().lookupCompoundType(name3);
                Type c = c1.getNamedType().resolveType(tenv);
                for (int bindex = 0; bindex < b.length; ++bindex) {
                    Type btype = b[bindex].getBindingType().resolveType(tenv);
                    if (btype == null || !btype.refersToType(c, tenv.getModule())) continue;
                    HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
                    typeMap.put(c, this.m_vdtmap.getTargetType(name3));
                    b[bindex].setType(b[bindex].getBindingType().resolveType(tenv).replaceType(typeMap));
                }
            }
        }
        final HashMap typeMap = this.m_vdtmap.getTypeMap();
        Optimizer automatono = new Optimizer(){

            @Override
            protected Instruction optimizeStep(Instruction n2) {
                for (int index2 = 0; index2 < n2.getTypeParameterCount(); ++index2) {
                    Type t = n2.getTypeParameter(index2).resolveType(this.m_currentFunction.getTypeEnvironment());
                    n2.setTypeParameter(index2, t.replaceType(typeMap));
                }
                return n2;
            }
        };
        for (Function f3 : m.getFunctions()) {
            automatono.optimizeFunction(f3);
        }
        this.convertADTs(m);
        this.convertADTs(ms);
        this.convertFunctionSignatures(m);
        for (Function f3 : this.m_functionsToUpdate) {
            if (ms.getFunctionSignature(f3.getName()) != null) {
                ms.addFunctionSignature(new FunctionSignature(f3));
            }
            f3.clearReducedTypeInformation();
            try {
                f3.typeCheckReduced(m, new LinkedList());
            }
            catch (Throwable tce) {
                throw new Error(tce.getMessage());
            }
        }
        this.m_functionsToUpdate.clear();
    }

    @Override
    public void optimizeFunction(Function f2) {
        Binding[] b = f2.getParameters();
        Type returnType = f2.getReturnType();
        Iterator ii = this.m_vdtmap.vdtMappingNames().iterator();
        TypeEnvironment tenv = f2.getTypeEnvironment();
        while (ii.hasNext()) {
            String name2 = (String)ii.next();
            CompoundType c1 = f2.getTypeEnvironment().getModule().lookupCompoundType(name2);
            Type c = c1 != null ? c1.getNamedType() : f2.getTypeEnvironment().getModule().lookupTypeAlias(name2);
            if (c == null) continue;
            c = c.resolveType(tenv);
            if (returnType != null && returnType.resolveType(tenv).refersToType(c, tenv.getModule())) {
                this.m_functionsToUpdate.add(f2);
            }
            for (int bindex = 0; bindex < b.length; ++bindex) {
                Type btype = b[bindex].getBindingType().resolveType(tenv);
                if (btype == null || !btype.refersToType(c, tenv.getModule())) continue;
                this.m_functionsToUpdate.add(f2);
            }
        }
        super.optimizeFunction(f2);
    }

    protected void convertADTs(ITypeStore m) {
        boolean worked;
        HashSet<AbstractDataType> done = new HashSet<AbstractDataType>();
        do {
            Iterator i = m.getAbstractDataTypesIterator();
            worked = false;
            while (i.hasNext()) {
                AbstractDataType adt = (AbstractDataType)i.next();
                if (done.contains(adt)) continue;
                for (int j = 0; j < adt.m_constructors.length; ++j) {
                    AbstractDataType.Constructor c = adt.m_constructors[j];
                    for (int k = 0; k < c.m_parameters.length; ++k) {
                        Binding b = c.m_parameters[k];
                        b.setType(this.convertType(b.getBindingType()));
                    }
                }
                done.add(adt);
                worked = true;
            }
        } while (worked);
    }

    protected void convertFunctionSignatures(Module m) {
        Iterator<Function> i = m.getFunctions().iterator();
        while (i.hasNext()) {
            Function f2;
            this.m_currentFunction = f2 = i.next();
            for (int k = 0; k < f2.m_parameters.length; ++k) {
                Binding b = f2.m_parameters[k];
                b.setType(this.convertType(b.getBindingType()));
            }
            f2.setReturnType(this.convertType(f2.getReturnType()));
            FunctionSignature fs = m.getFunctionSignature(this.m_currentFunction.getName());
            if (fs != null) {
                fs.setReturnType(f2.getReturnType());
            }
            this.m_currentFunction = null;
        }
    }

    public Type convertType(Type type2) {
        if (type2 == null) {
            throw new RuntimeException();
        }
        if (this.getCurrentFunction() != null) {
            type2 = type2.resolveType(this.getCurrentFunction().getTypeEnvironment());
        }
        if (type2 instanceof NamedType) {
            NamedType nt = (NamedType)type2;
            Type replacement = this.m_map == null ? null : this.m_map.get(nt);
            if (replacement != null) {
                return replacement;
            }
            return nt;
        }
        int c = type2.getChildTypeCount();
        for (int i = 0; i < c; ++i) {
            type2.setChildType(i, this.convertType(type2.getChildType(i)));
        }
        return type2;
    }

    private class Delta {
        Instruction parent;
        int index;
        Instruction replacement;
        TypeEnvironment tenv;
        BindingEnvironment benv;
        Function enclosingFunction;

        public Delta(Instruction p, int i, Instruction r, TypeEnvironment t, BindingEnvironment b, Function f2) {
            this.parent = p;
            this.index = i;
            this.replacement = r;
            this.tenv = t;
            this.benv = b;
            this.enclosingFunction = f2;
        }
    }
}

