/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import java.util.HashMap;

public class ApplyEvaluator
extends PartialEvaluator {
    public static LambdaInstruction extractLambda(PartialInformationCollector pic, Instruction n2, LetChainManager lcm) {
        if (n2 == null) {
            return null;
        }
        if (n2 instanceof LambdaInstruction) {
            return (LambdaInstruction)n2;
        }
        if (n2 instanceof IdentifierInstruction) {
            return ApplyEvaluator.extractLambda(pic, lcm.lookupBinding(n2), lcm);
        }
        if (n2 instanceof FunctionCallInstruction) {
            FunctionCallInstruction fci = (FunctionCallInstruction)n2;
            if (0 != fci.m_parameters.length) {
                return null;
            }
            Function f2 = lcm.getCurrentFunction().getTypeEnvironment().getModule().getFunction(fci.getFunction());
            if (!(f2.getBody() instanceof LambdaInstruction)) {
                return null;
            }
            return (LambdaInstruction)f2.getBody();
        }
        return null;
    }

    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        ApplyInstruction ai = (ApplyInstruction)x;
        pic.partiallyEvaluate(ai.getLambda(), lcm);
        LambdaInstruction li = ApplyEvaluator.extractLambda(pic, ai.getLambda(), lcm);
        if (li == null) {
            return PartialEvaluationResult.s_emptyResult;
        }
        IBinding[] params = li.getChildInstructionBindings(0);
        Instruction body = li.getBody();
        HashMap map2 = PartialInformationCollector.setupDeconstructionBindingReplacement(ai.m_parameters, params, body, lcm, before2);
        body = body.assignNewNames(map2);
        IdentifierInstruction handler = lcm.insertBody(body, before2);
        return new PartialEvaluationResult((Instruction)handler, true);
    }
}

