/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.instructions.DeepEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import java.util.ArrayList;
import java.util.Iterator;

public class DeepEqualityEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        DeepEqualityInstruction pei = (DeepEqualityInstruction)x;
        pic.partiallyEvaluate(pei.getOperand1(), lcm);
        pic.partiallyEvaluate(pei.getOperand2(), lcm);
        Instruction subst1 = lcm.lookupBinding(pei.getOperand1());
        Instruction subst2 = lcm.lookupBinding(pei.getOperand2());
        if (subst1 == null || subst2 == null) {
            return PartialEvaluationResult.s_emptyResult;
        }
        if (subst1 instanceof LiteralInstruction && subst2 instanceof LiteralInstruction) {
            return new PartialEvaluationResult(((LiteralInstruction)subst1).getValue().equals(((LiteralInstruction)subst2).getValue()) ? LiteralInstruction.booleanTrueLiteral() : LiteralInstruction.booleanFalseLiteral());
        }
        if (subst1 instanceof StreamInstruction && subst2 instanceof StreamInstruction) {
            ArrayList list1 = new ArrayList();
            DeepEqualityEvaluator.accumulateStream((StreamInstruction)subst1, list1, pic, lcm);
            ArrayList list2 = new ArrayList();
            DeepEqualityEvaluator.accumulateStream((StreamInstruction)subst2, list2, pic, lcm);
            if (list1.size() != list2.size()) {
                Iterator i = list1.iterator();
                while (i.hasNext()) {
                    if (i.next() instanceof LiteralInstruction) continue;
                    return PartialEvaluationResult.s_emptyResult;
                }
                i = list2.iterator();
                while (i.hasNext()) {
                    if (i.next() instanceof LiteralInstruction) continue;
                    return PartialEvaluationResult.s_emptyResult;
                }
                return new PartialEvaluationResult(LiteralInstruction.booleanFalseLiteral());
            }
            for (int i = 0; i < list1.size(); ++i) {
                Instruction i2;
                Instruction i1 = (Instruction)list1.get(i);
                if (i1 == null ^ (i2 = (Instruction)list2.get(i)) == null) {
                    return new PartialEvaluationResult(LiteralInstruction.booleanFalseLiteral());
                }
                if (i1 instanceof LiteralInstruction && i2 instanceof LiteralInstruction) {
                    if (((LiteralInstruction)i1).getValue().equals(((LiteralInstruction)i2).getValue())) continue;
                    return new PartialEvaluationResult(LiteralInstruction.booleanFalseLiteral());
                }
                if (i1 == null || i1.equals(i2)) continue;
                return PartialEvaluationResult.s_emptyResult;
            }
            return new PartialEvaluationResult(LiteralInstruction.booleanTrueLiteral());
        }
        return PartialEvaluationResult.s_emptyResult;
    }
}

