/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ForEachEvaluator
extends PartialEvaluator {
    public static final int s_loopUnrollThreshold = 10;

    protected static boolean checkInstruction(PartialInformationCollector pic, Instruction n2) {
        if (n2 instanceof ChooseInstruction) {
            return ForEachEvaluator.checkChooseInstruction(pic, (ChooseInstruction)n2);
        }
        if (n2 instanceof MatchInstruction) {
            return ForEachEvaluator.checkMatchInstruction(pic, (MatchInstruction)n2);
        }
        if (n2 instanceof StreamInstruction) {
            return ForEachEvaluator.checkStreamInstruction(pic, (StreamInstruction)n2);
        }
        return false;
    }

    protected static boolean checkStreamInstruction(PartialInformationCollector pic, StreamInstruction si) {
        int c = si.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            Instruction x = si.getChildInstruction(i);
            if (!(pic.resolveType(x) instanceof StreamType)) continue;
            return false;
        }
        return true;
    }

    protected static boolean checkChooseInstruction(PartialInformationCollector pic, ChooseInstruction ci) {
        BindingEnvironment benv = pic.getCurrentBindingEnvironment();
        for (ChooseInstruction.Case cic : ci.m_cases) {
            Instruction innerBody = NavigationUtilities.resolveReducedIdentifier(NavigationUtilities.skipLets(cic.getHandler()), benv);
            if (ForEachEvaluator.checkInstruction(pic, innerBody)) continue;
            return false;
        }
        Instruction def = ci.getDefaultHandler();
        if (def != null) {
            Instruction innerBody = NavigationUtilities.resolveReducedIdentifier(NavigationUtilities.skipLets(def), benv);
            return ForEachEvaluator.checkInstruction(pic, innerBody);
        }
        return true;
    }

    protected static boolean checkMatchInstruction(PartialInformationCollector pic, MatchInstruction ci) {
        BindingEnvironment benv = pic.getCurrentBindingEnvironment();
        int c = ci.getMatches().length;
        for (int i = 0; i < c; ++i) {
            MatchInstruction.Match cic = ci.getMatches()[i];
            Instruction innerBody = NavigationUtilities.resolveReducedIdentifier(NavigationUtilities.skipLets(cic.getHandler()), benv);
            if (ForEachEvaluator.checkInstruction(pic, innerBody)) continue;
            return false;
        }
        Instruction def = ci.getDefault();
        if (def != null) {
            Instruction innerBody = NavigationUtilities.resolveReducedIdentifier(NavigationUtilities.skipLets(def), benv);
            return ForEachEvaluator.checkInstruction(pic, innerBody);
        }
        return true;
    }

    protected static void implantForEach(ForEachInstruction fei2, Instruction x, int child2, HashMap bindings) {
        Instruction y = x.getChildInstruction(child2);
        if (y instanceof LetInstruction) {
            LetInstruction leti = (LetInstruction)y;
            bindings.put(leti.getVariable(), leti);
            ForEachEvaluator.implantForEach(fei2, y, 1, bindings);
        } else if (y instanceof IdentifierInstruction) {
            IdentifierInstruction ii = (IdentifierInstruction)y;
            LetInstruction leti = (LetInstruction)bindings.get(ii.getVariable());
            if (leti != null) {
                x.setChildInstruction(child2, leti.getValue().cloneReduced());
                ForEachEvaluator.implantForEach(fei2, x, child2, bindings);
            } else {
                ForEachInstruction fei3 = (ForEachInstruction)fei2.cloneWithNewNames();
                Object ident = fei3.getVarName();
                x.setChildInstruction(child2, new LetInstruction(ident, ii, fei3.getBody()));
            }
        } else if (y instanceof ChooseInstruction) {
            ChooseInstruction ci = (ChooseInstruction)y;
            int c = ci.m_cases.length;
            Instruction def = ci.getDefaultHandler();
            int j = 1;
            if (def != null) {
                ++j;
                ForEachEvaluator.implantForEach(fei2, ci, 0, bindings);
            }
            for (int i = 0; i < c; ++i) {
                ForEachEvaluator.implantForEach(fei2, ci, j, bindings);
                j += 2;
            }
        } else if (y instanceof MatchInstruction) {
            MatchInstruction ci = (MatchInstruction)y;
            int c = ci.getMatches().length;
            Instruction def = ci.getDefault();
            int j = 1;
            if (def != null) {
                ++j;
                ForEachEvaluator.implantForEach(fei2, ci, 0, bindings);
            }
            for (int i = 0; i < c; ++i) {
                ForEachEvaluator.implantForEach(fei2, ci, j, bindings);
                ++j;
            }
        } else if (y instanceof StreamInstruction) {
            StreamInstruction si = (StreamInstruction)y;
            ForEachInstruction fei3 = (ForEachInstruction)fei2.cloneWithNewNames();
            Integer ident = ReductionHelper.generateIntermediateIdentifier2();
            fei3.setSource(new IdentifierInstruction(ident));
            x.setChildInstruction(child2, new LetInstruction(ident, si, fei3));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    protected static void unrollLoop(PartialInformationCollector pic, Instruction body, String loopvar, StreamInstruction source, LetInstruction before2, LetChainManager lcm, ArrayList results) {
        int c = source.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            Instruction x = source.getChildInstruction(i);
            if (pic.resolveType(x) instanceof StreamType) {
                ForEachEvaluator.unrollLoop(pic, body, loopvar, (StreamInstruction)lcm.lookupBinding(x), before2, lcm, results);
                continue;
            }
            HashMap<String, IdentifierInstruction> map2 = new HashMap<String, IdentifierInstruction>();
            IdentifierInstruction newloopvar = lcm.insertBody(x.cloneWithNewNames(), before2);
            map2.put(loopvar, newloopvar);
            Instruction body2 = body.assignNewNames(map2);
            results.add(lcm.insertBody(body2, before2));
        }
    }

    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        PartialEvaluationResult per;
        ForEachInstruction fei;
        block9: {
            TypeEnvironment tenv;
            BindingEnvironment benv;
            Instruction src;
            block10: {
                Set freeBindings;
                fei = (ForEachInstruction)x;
                pic.partiallyEvaluate(fei.getSource(), lcm);
                src = lcm.lookupBinding(fei.getSource());
                if (fei.getIndexVar() != null && !(freeBindings = fei.getBody().accumulateFreeBindingsInOrder(pic.getCurrentBindingEnvironment())).contains(fei.getIndexBinding())) {
                    fei.setIndexVar(null);
                }
                benv = pic.getCurrentBindingEnvironment();
                tenv = pic.getCurrentTypeEnvironment();
                if (!(src instanceof StreamInstruction) || src.getChildInstructionCount() >= 10 || !(src.getType(tenv, benv).resolveType(tenv) instanceof StreamType)) break block9;
                if (fei.getIndexVar() == null) break block10;
                HashSet set2 = new HashSet();
                fei.getBody().accumulateFreeBindings(set2, benv);
                if (set2.contains(fei.getIndexBinding())) break block9;
            }
            StreamInstruction si = (StreamInstruction)src;
            ArrayList<IdentifierInstruction> list = new ArrayList<IdentifierInstruction>();
            ArrayList list2 = new ArrayList();
            ForEachEvaluator.accumulateStream(si, list2, pic, lcm);
            Type elementType = ((StreamType)fei.getType(tenv, benv).resolveType(tenv)).getElementType();
            if (list2.size() == 0) {
                return new PartialEvaluationResult(new StreamInstruction(elementType));
            }
            for (Instruction y : list2) {
                if (y.getType(tenv, benv).resolveType(tenv) instanceof StreamType) {
                    if (list2.size() == 1) {
                        fei.setSource(y);
                        return new PartialEvaluationResult(null, true);
                    }
                    ForEachInstruction fei2 = (ForEachInstruction)fei.cloneWithNewNames();
                    fei2.setBody(fei2.getBody().cloneReduced());
                    fei2.setSource(y);
                    list.add(lcm.insertBody(fei2, before2));
                    continue;
                }
                Instruction body2 = fei.getBody();
                HashMap<Object, Instruction> map2 = new HashMap<Object, Instruction>();
                map2.put(fei.getVarName(), y);
                list.add(lcm.insertBody(body2.assignNewNames(map2), before2));
            }
            return new PartialEvaluationResult((Instruction)new StreamInstruction(elementType, list), true);
        }
        if ((per = pic.partiallyEvaluateBody(fei.getBody(), fei, 1, lcm)).getReplacement() != null) {
            fei.setBody(per.getReplacement());
        }
        return PartialEvaluationResult.s_emptyResult;
    }
}

