/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import java.util.HashMap;

public class FunctionCallEvaluator
extends PartialEvaluator {
    protected int m_depth = 0;
    private static final int m_maxDepth = 2;

    protected boolean allowInlining(FunctionCallInstruction fci, Function f2, BindingEnvironment benv) {
        return f2.getBody().isStatic(f2.getBindingEnvironment());
    }

    public Class[] getSupportedInstructionClasses() {
        return new Class[]{FunctionCallInstruction.class};
    }

    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        FunctionCallInstruction fci = (FunctionCallInstruction)x;
        Instruction[] params = new Instruction[fci.m_parameters.length];
        for (int j = 0; j < params.length; ++j) {
            pic.partiallyEvaluate(fci.m_parameters[j], lcm);
        }
        if (this.m_depth == 2) {
            return PartialEvaluationResult.s_emptyResult;
        }
        ++this.m_depth;
        Function f2 = lcm.getCurrentFunction().getTypeEnvironment().getModule().getFunction(fci.getFunction());
        if (!this.allowInlining(fci, f2, pic.getCurrentBindingEnvironment())) {
            --this.m_depth;
            if (f2 == lcm.m_currentFunction) {
                return PartialEvaluationResult.s_emptyResult;
            }
            Module module = f2.getTypeEnvironment().getModule();
            return new PartialEvaluationResult(null, false, module.getPartialInformation(f2.getName()));
        }
        Instruction body = f2.getBody();
        HashMap map2 = PartialInformationCollector.setupDeconstructionBindingReplacement(fci.m_parameters, f2.m_parameters, body, lcm, before2);
        body = body.assignNewNames(map2);
        IdentifierInstruction handler = lcm.insertBody(body, before2);
        --this.m_depth;
        return new PartialEvaluationResult((Instruction)handler, true);
    }
}

