/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IdentifierConsolidator;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

public class FunctionCallValueSpecializerEvaluator
extends PartialEvaluator {
    public static String generateIntermediateIdentifier() {
        return OptimizerUtilities.generateIntermediateIdentifier("fcwl");
    }

    private static FunctionCallInstruction getSpecializedFunction(Function genericFunction, FunctionCallInstruction fci, Instruction[] args, int[] positions, BindingEnvironment benv, TypeEnvironment tenv, PartialInformationCollector pic) {
        Binding oldBinding;
        int i;
        ValueSpecializedDerivative deriv = new ValueSpecializedDerivative(benv, args, positions);
        Function newFunc = genericFunction.lookupDerivative(deriv);
        Module program = genericFunction.getTypeEnvironment().getModule();
        String bodyIdent = FunctionCallValueSpecializerEvaluator.generateIntermediateIdentifier();
        Instruction newBody = genericFunction.getBody().cloneWithoutTypeInformation();
        int num_parameters = genericFunction.m_parameters.length - deriv.m_args.length;
        TreeSet set2 = new TreeSet();
        for (i = 0; i < deriv.m_args.length; ++i) {
            deriv.m_args[i].accumulateFreeBindings(set2, benv);
        }
        Binding[] parameters = new Binding[num_parameters += set2.size()];
        Instruction[] newParameters = new Instruction[num_parameters];
        int j = 0;
        int last_copied = -1;
        Iterator iter = set2.iterator();
        HashMap<Object, IdentifierInstruction> freeBindingNewNameMap = new HashMap<Object, IdentifierInstruction>();
        while (iter.hasNext()) {
            IBinding binding = (IBinding)iter.next();
            freeBindingNewNameMap.put(binding.getName(), new IdentifierInstruction(ReductionHelper.generateIntermediateIdentifier2()));
        }
        for (i = 0; i < deriv.m_args.length; ++i) {
            for (int k = last_copied + 1; k < deriv.m_position[i]; ++k) {
                oldBinding = genericFunction.m_parameters[k];
                parameters[j] = new Binding(oldBinding.getName(), oldBinding.getBindingType());
                newParameters[j] = fci.getParameters()[k];
                if (set2.contains(parameters[j])) {
                    return null;
                }
                ++j;
            }
            last_copied = deriv.m_position[i];
            newBody = new LetInstruction(genericFunction.m_parameters[deriv.m_position[i]].getName(), deriv.m_args[i].assignNewNames(freeBindingNewNameMap), newBody);
            if (!set2.contains(genericFunction.m_parameters[deriv.m_position[i]])) continue;
            return null;
        }
        for (int k = last_copied + 1; k < fci.getParameterCount(); ++k) {
            oldBinding = genericFunction.m_parameters[k];
            parameters[j] = new Binding(oldBinding.getName(), oldBinding.getBindingType());
            newParameters[j] = fci.getParameters()[k];
            if (set2.contains(parameters[j])) {
                return null;
            }
            ++j;
        }
        for (IBinding binding : set2) {
            Instruction newName = (Instruction)freeBindingNewNameMap.get(binding.getName());
            if (newName instanceof IdentifierInstruction) {
                parameters[j] = new Binding(((IdentifierInstruction)newName).getVariable(), Binding.resolveBindingType(binding, tenv, benv));
                newParameters[j] = newName;
                ++j;
            }
            if (null != Binding.resolveBindingType(binding, tenv, benv)) continue;
        }
        if (newFunc == null) {
            newFunc = new Function(genericFunction.generateNewFixupName(), parameters, newBody);
            newFunc.setMemoizeResult(genericFunction.getMemoizeResult());
            newFunc.m_comment = genericFunction.getComment();
            newFunc.setConstraints(genericFunction.getConstraints());
            newFunc.m_resolvedConstraintTypes = new HashMap(genericFunction.m_resolvedConstraintTypes);
            program.addFunction(newFunc);
            genericFunction.registerDerivative(deriv, newFunc);
        } else {
            int k = 23;
        }
        FunctionCallInstruction newFuncCall = new FunctionCallInstruction(newFunc.getName(), newParameters);
        return newFuncCall;
    }

    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction n2, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        return PartialEvaluationResult.s_emptyResult;
    }

    static final class ValueSpecializedDerivative {
        BindingEnvironment m_benv;
        Instruction[] m_args;
        int[] m_position;

        ValueSpecializedDerivative(BindingEnvironment benv, Instruction arg2, int position2) {
            this.m_benv = benv;
            this.m_args = new Instruction[]{arg2};
            this.m_position = new int[]{position2};
            ValueSpecializedDerivative.canonicalize(this.m_args, this.m_benv);
        }

        ValueSpecializedDerivative(BindingEnvironment benv, Instruction[] args, int[] positions) {
            this.m_benv = benv;
            this.m_args = args;
            this.m_position = positions;
            ValueSpecializedDerivative.canonicalize(this.m_args, this.m_benv);
        }

        private static void canonicalize(Instruction[] args, BindingEnvironment benv) {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof LambdaInstruction)) continue;
                LambdaInstruction lambda2 = (LambdaInstruction)args[i];
                args[i] = new IdentifierConsolidator().processLambda(lambda2, benv);
            }
        }

        public String toString() {
            String ans = "(ValueSpecializedDerivative ";
            for (int i = 0; i < this.m_args.length; ++i) {
                if (i != 0) {
                    ans = ans + ", ";
                }
                ans = ans + "(" + this.m_position[i] + ": " + this.m_args[i].toString() + ")";
            }
            ans = ans + ")";
            return ans;
        }

        public int hashCode() {
            int ans = 0;
            for (int i = 0; i < this.m_args.length; ++i) {
                ans += 2 * i * this.m_args[i].hashCode() + 3 * i * this.m_position[i];
            }
            return ans;
        }

        public boolean equals(Object arg0) {
            if (arg0 == null) {
                return false;
            }
            if (!(arg0 instanceof ValueSpecializedDerivative)) {
                return false;
            }
            ValueSpecializedDerivative other2 = (ValueSpecializedDerivative)arg0;
            Instruction[] arg0args = other2.m_args;
            int[] arg0positions = other2.m_position;
            if (arg0args.length != this.m_args.length) {
                return false;
            }
            for (int i = 0; i < this.m_args.length; ++i) {
                if (this.m_position[i] != arg0positions[i]) {
                    return false;
                }
                if (this.m_args[i].equals(arg0args[i])) continue;
                return false;
            }
            return true;
        }
    }
}

