/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LetChainManager {
    private static final Logger s_logger = LoggerUtil.getLogger(LetChainManager.class);
    private static final String s_className = LetChainManager.class.getName();
    protected Instruction m_baseInstruction;
    protected Instruction m_targetInstruction;
    protected LetInstruction m_outerLet;
    protected LetInstruction m_innerLet;
    protected Type m_baseType;
    protected LiteralInstruction m_baseNull;
    protected LetChainManager m_parent;
    protected Function m_currentFunction;
    protected Instruction m_parentInstruction;
    protected int m_parentIndex;

    public LetChainManager(Instruction baseInstruction, Function f2) {
        this(baseInstruction, null, f2, null, -1);
    }

    public LetChainManager(Instruction baseInstruction, LetChainManager parent2, Function f2, Instruction parentInstruction, int parentIndex) {
        this.m_baseInstruction = baseInstruction;
        try {
            this.m_baseType = baseInstruction.getType(f2.getTypeEnvironment(), f2.getBindingEnvironment()).resolveType(f2.getTypeEnvironment());
        }
        catch (Exception e) {
            throw new XylemError("ERR_SYSTEM", "error getting type for " + baseInstruction + ": " + e);
        }
        this.m_baseNull = new LiteralInstruction(this.m_baseType, null);
        this.m_parent = parent2;
        this.m_currentFunction = f2;
        this.m_parentInstruction = parentInstruction;
        this.m_parentIndex = parentIndex;
        this.m_targetInstruction = baseInstruction;
        LetInstruction parentLet = null;
        while (this.m_targetInstruction instanceof LetInstruction) {
            LetInstruction leti = (LetInstruction)this.m_targetInstruction;
            if (parentLet != null) {
                leti.m_parent = parentLet;
            }
            leti.m_lcm = this;
            this.m_innerLet = leti;
            if (this.m_outerLet == null) {
                this.m_outerLet = this.m_innerLet;
            }
            this.m_targetInstruction = this.m_innerLet.getBody();
            parentLet = this.m_innerLet;
        }
    }

    protected void addAndTypeCheckLet(LetInstruction leti, LetInstruction before2, Set usedIdentifiers_) throws TypeCheckException {
        if (before2 != null && before2.m_lcm != this) {
            before2.m_lcm.addAndTypeCheckLet(leti, before2, usedIdentifiers_);
            return;
        }
        LetInstruction parent2 = this.getLetParent(before2);
        if (leti.hasBeenTypeChecked()) {
            throw new IllegalArgumentException();
        }
        if (leti.getValue() == null) {
            throw new XylemError("ERR_SYSTEM", "xx" + leti);
        }
        BindingEnvironment benv = this.getCurrentFunction().getBindingEnvironment();
        leti.setBody(this.m_baseNull);
        leti.m_lcm = this;
        if (before2 == null) {
            if (this.m_outerLet == null) {
                this.m_outerLet = leti;
                if (this.m_parentInstruction != null) {
                    this.m_parentInstruction.setChildInstruction(this.m_parentIndex, this.m_outerLet);
                } else {
                    this.m_currentFunction.setBody(this.m_outerLet);
                }
            }
            Instruction body = null;
            if (this.m_innerLet != null) {
                body = this.m_innerLet.getBody();
                this.m_innerLet.setBody(leti);
                leti.m_parent = this.m_innerLet;
                leti.typeCheckReduced(this.m_currentFunction.getTypeEnvironment(), benv, new LinkedList<Function>());
            } else {
                leti.typeCheckReduced(this.m_currentFunction.getTypeEnvironment(), benv, new LinkedList<Function>());
                body = this.m_targetInstruction;
            }
            this.m_innerLet = leti;
            leti.setBody(body);
            if (body instanceof LetInstruction) {
                LetInstruction leti2 = (LetInstruction)body;
                leti2.m_parent = leti;
                leti2.m_lcm = this;
            }
        } else {
            if (before2 == this.m_outerLet) {
                this.m_outerLet = leti;
                if (this.m_parentInstruction != null) {
                    this.m_parentInstruction.setChildInstruction(this.m_parentIndex, this.m_outerLet);
                } else {
                    this.m_currentFunction.setBody(this.m_outerLet);
                }
            }
            leti.typeCheckReduced(this.m_currentFunction.getTypeEnvironment(), benv, new LinkedList<Function>());
            if (parent2 != null) {
                parent2.setBody(leti);
                leti.m_parent = parent2;
            }
            leti.setBody(before2);
            before2.m_parent = leti;
        }
    }

    public Instruction insertBody2(Instruction n2, LetInstruction before2) {
        while (n2 instanceof LetInstruction) {
            LetInstruction leti = (LetInstruction)n2.cloneShallow();
            try {
                this.addAndTypeCheckLet(leti, before2, null);
            }
            catch (TypeCheckException e) {
                FFDCUtil.log(e, this);
                String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Type error transferring let " + leti});
                s_logger.logp(Level.WARNING, s_className, "insertBody2", message, e);
                return null;
            }
            n2 = ((LetInstruction)n2).getBody();
        }
        if (n2 instanceof IdentifierInstruction) {
            return n2;
        }
        if (n2 instanceof LiteralInstruction) {
            return n2;
        }
        Integer ident = ReductionHelper.generateIntermediateIdentifier2();
        try {
            this.addAndTypeCheckLet(new LetInstruction(ident, n2, null), before2, null);
        }
        catch (TypeCheckException e) {
            FFDCUtil.log(e, this);
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Type error"});
            s_logger.logp(Level.WARNING, s_className, "insertBody2", message, e);
            return null;
        }
        return new IdentifierInstruction(ident);
    }

    public Instruction insertBodyWithoutClone(Instruction n2, LetInstruction before2) {
        while (n2 instanceof LetInstruction) {
            LetInstruction leti = (LetInstruction)n2;
            Instruction body = leti.getBody();
            try {
                this.addAndTypeCheckLet(leti, before2, null);
            }
            catch (TypeCheckException e) {
                FFDCUtil.log(e, this);
                String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Type error transferring let " + leti});
                s_logger.logp(Level.WARNING, s_className, "insertBodyWithoutClone", message, e);
                return null;
            }
            n2 = body;
        }
        if (n2 instanceof IdentifierInstruction) {
            return n2;
        }
        if (n2 instanceof LiteralInstruction) {
            return n2;
        }
        Integer ident = ReductionHelper.generateIntermediateIdentifier2();
        try {
            this.addAndTypeCheckLet(new LetInstruction(ident, n2, null), before2, null);
        }
        catch (TypeCheckException e) {
            FFDCUtil.log(e, this);
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Type error"});
            s_logger.logp(Level.WARNING, s_className, "insertBodyWithoutClone", message, e);
            return null;
        }
        return new IdentifierInstruction(ident);
    }

    public IdentifierInstruction insertBody(Instruction n2, LetInstruction before2) {
        return this.insertBodyWithNameHelper(ReductionHelper.generateIntermediateIdentifier2(), n2, before2, false);
    }

    public IdentifierInstruction insertBodyWithNameForced(Object varName, Instruction n2, LetInstruction before2) {
        return this.insertBodyWithNameHelper(varName, n2, before2, true);
    }

    public IdentifierInstruction insertBodyWithNameHelper(Object varName, Instruction n2, LetInstruction before2, boolean forced) {
        Set usedIdentifiers = null;
        while (n2 instanceof LetInstruction) {
            LetInstruction leti = (LetInstruction)n2.cloneShallow();
            try {
                this.addAndTypeCheckLet(leti, before2, usedIdentifiers);
            }
            catch (TypeCheckException e) {
                FFDCUtil.log(e, this);
                String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Type error transferring let " + leti});
                s_logger.logp(Level.WARNING, s_className, "insertBodyWithNameHelper", message, e);
                return null;
            }
            n2 = ((LetInstruction)n2).getBody();
        }
        if (!forced && n2 instanceof IdentifierInstruction) {
            return (IdentifierInstruction)n2;
        }
        try {
            this.addAndTypeCheckLet(new LetInstruction(varName, n2, null), before2, usedIdentifiers);
        }
        catch (TypeCheckException e) {
            FFDCUtil.log(e, this);
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Type error"});
            s_logger.logp(Level.WARNING, s_className, "insertBodyWithNameHelper", message, e);
            return null;
        }
        IdentifierInstruction ii = new IdentifierInstruction(varName);
        Instruction.propagateInfo(n2, ii);
        return ii;
    }

    public Instruction lookupBinding(Object var) {
        IBinding b = this.findBinding(var);
        if (b == null) {
            return null;
        }
        if (b.getLet() == null) {
            return null;
        }
        Instruction x = b.getLet().getValue();
        if (x instanceof IdentifierInstruction) {
            return this.lookupBinding(x);
        }
        return x;
    }

    public IBinding findBinding(Object var) {
        BindingEnvironment benv = this.m_currentFunction.getBindingEnvironment();
        if (benv == null) {
            throw new RuntimeException();
        }
        IBinding b = benv.getVariableBinding(var);
        if (b != null || this.m_parent == null) {
            return b;
        }
        return this.m_parent.findBinding(var);
    }

    public Instruction lookupBinding(Instruction n2) {
        if (n2 instanceof IdentifierInstruction) {
            return this.lookupBinding(((IdentifierInstruction)n2).getVariable());
        }
        if (n2 instanceof LiteralInstruction) {
            return n2;
        }
        throw new IllegalArgumentException();
    }

    public Instruction graftFinalBody(Instruction n2) {
        LetInstruction leti = this.m_outerLet;
        if (leti != null) {
            while (true) {
                leti.m_lcm = null;
                leti.m_parent = null;
                Instruction body = leti.getBody();
                if (!(body instanceof LetInstruction)) break;
                leti = (LetInstruction)body;
            }
        }
        if (n2 == null) {
            return this.m_outerLet == null ? this.m_baseInstruction : this.m_outerLet;
        }
        if (this.m_innerLet != null) {
            this.m_innerLet.setBody(n2);
            return this.m_outerLet;
        }
        return n2;
    }

    protected LetInstruction getLetParent(LetInstruction x) {
        if (x == null) {
            return null;
        }
        return x.m_parent;
    }

    public Function getCurrentFunction() {
        return this.m_currentFunction;
    }

    public Instruction getTargetInstruction() {
        return this.m_targetInstruction;
    }
}

