/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NotInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.AbstractDataObjectPI;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MatchEvaluator
extends PartialEvaluator {
    private static final Logger s_logger = LoggerUtil.getLogger(MatchEvaluator.class);
    private static final String s_className = MatchEvaluator.class.getName();

    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        int i;
        MatchInstruction.DeconstructionMatch dm;
        MatchInstruction mi = (MatchInstruction)x;
        Instruction def = null;
        Set defInfo = null;
        MatchInstruction.Match[] matches2 = mi.getMatches();
        MatchInstruction.Match savedMatch = null;
        boolean isLiteralMatch = matches2[0] instanceof MatchInstruction.LiteralMatch;
        boolean incremental = false;
        Instruction toMatch = mi.getToMatch();
        Object toMatchValue = null;
        AbstractDataObjectPI adopi = null;
        Set toMatchSet = pic.partiallyEvaluate(toMatch, lcm);
        if (isLiteralMatch) {
            while (toMatch != null && toMatch instanceof IdentifierInstruction) {
                toMatch = lcm.lookupBinding(toMatch);
            }
            toMatchValue = PartialEvaluator.extractLiteralValue(pic, toMatch, lcm);
        } else if (null != toMatchSet) {
            adopi = AbstractDataObjectPI.extractAbstractDataObjectPI(toMatchSet);
        }
        if (!isLiteralMatch && adopi == null && matches2.length == 1 && mi.getDefault() == null && (dm = (MatchInstruction.DeconstructionMatch)matches2[0]).getHandler() instanceof IdentifierInstruction) {
            IdentifierInstruction ii = (IdentifierInstruction)dm.getHandler();
            Object var = ii.getVariable();
            Binding[] bindings = dm.getBindings();
            for (i = 0; i < bindings.length; ++i) {
                if (!bindings[i].getName().equals(var)) continue;
                return PartialEvaluationResult.s_emptyResult;
            }
        }
        int literalTrueResults = 0;
        int literalFalseResults = 0;
        ArrayList<Instruction> handlers = new ArrayList<Instruction>();
        ArrayList<MatchInstruction.Match> cases = new ArrayList<MatchInstruction.Match>();
        for (i = 0; i < matches2.length; ++i) {
            MatchInstruction.Match m;
            savedMatch = m = matches2[i];
            PartialEvaluationResult per = pic.partiallyEvaluateBody(m.getHandler(), mi, mi.getChildInstructionIndex(m.getHandler()), lcm);
            Instruction subst2 = per.getReplacement();
            if (subst2 != null) {
                m.setHandler(subst2);
            }
            if (isLiteralMatch) {
                MatchInstruction.LiteralMatch lm = (MatchInstruction.LiteralMatch)m;
                Object resultLiteral = PartialEvaluator.extractLiteralValue(pic, NavigationUtilities.skipLets(m.getHandler()), lcm);
                if (resultLiteral != null) {
                    if (resultLiteral.equals(Boolean.TRUE)) {
                        ++literalTrueResults;
                    } else if (resultLiteral.equals(Boolean.FALSE)) {
                        ++literalFalseResults;
                    }
                }
                if (toMatchValue == null) {
                    cases.add(lm);
                    handlers.add(matches2[i].getHandler());
                    continue;
                }
                if (!lm.getLiteral().getValue().equals(toMatchValue)) continue;
                def = subst2 == null ? lm.getHandler() : subst2;
                defInfo = per.getPartialInformation();
                break;
            }
            if (adopi == null) {
                cases.add(matches2[i]);
                handlers.add(matches2[i].getHandler());
                continue;
            }
            MatchInstruction.DeconstructionMatch dm2 = (MatchInstruction.DeconstructionMatch)m;
            HashSet freeBindings = new HashSet();
            dm2.getHandler().accumulateNonLiteralFreeBindings(freeBindings, lcm.getCurrentFunction().getBindingEnvironment());
            freeBindings.retainAll(Arrays.asList(dm2.getBindings()));
            if (dm2.getConstructor() != adopi.getConstructor()) continue;
            Instruction[] params = new Instruction[adopi.m_parameters.length];
            boolean outOfReach = false;
            for (int j = 0; j < params.length; ++j) {
                if (adopi.m_parameters[j] != null) {
                    params[j] = adopi.m_parameters[j].getInstruction();
                    if (!(params[j] instanceof IdentifierInstruction)) continue;
                    if (!adopi.m_parameters[j].getFunctionName().equals(lcm.getCurrentFunction().getName())) {
                        outOfReach = true;
                        break;
                    }
                    Instruction y = lcm.lookupBinding(params[j]);
                    if (null == y && params[j] instanceof IdentifierInstruction) {
                        Object usedName = ((IdentifierInstruction)params[j]).getVariable();
                        Binding[] functionParams = pic.m_currentFunction.getParameters();
                        for (int k = 0; k < functionParams.length; ++k) {
                            if (!functionParams[k].getName().equals(usedName)) continue;
                            y = params[j];
                            break;
                        }
                    }
                    if (y != null || !freeBindings.contains(dm2.getBindings()[j])) continue;
                    outOfReach = true;
                    break;
                }
                if (!freeBindings.contains(dm2.getBindings()[j])) continue;
                outOfReach = true;
                break;
            }
            if (outOfReach) {
                cases.add(dm2);
                handlers.add(matches2[i].getHandler());
                continue;
            }
            def = dm2.getHandler();
            HashMap map2 = PartialInformationCollector.setupDeconstructionBindingReplacement(params, dm2.getBindings(), def, lcm, before2);
            def = def.assignNewNames(map2);
            def = lcm.insertBody(def, before2);
            incremental = true;
            break;
        }
        Object resultLiteral = null;
        if (def == null && mi.getDefault() != null) {
            PartialEvaluationResult per = pic.partiallyEvaluateBody(mi.getDefault(), mi, 0, lcm);
            Instruction subst1 = per.getReplacement();
            def = subst1 != null ? subst1 : mi.getDefault();
            resultLiteral = PartialEvaluator.extractLiteralValue(pic, NavigationUtilities.skipLets(mi.getDefault()), lcm);
            if (resultLiteral != null) {
                if (resultLiteral.equals(Boolean.TRUE)) {
                    ++literalTrueResults;
                } else if (resultLiteral.equals(Boolean.FALSE)) {
                    ++literalFalseResults;
                }
            }
            handlers.add(def);
        }
        if (mi.getDefault() != null && matches2.length == 1 && literalTrueResults == 1 && literalFalseResults == 1) {
            Instruction replacement = new PrimitiveEqualityInstruction(mi.getToMatch(), ((MatchInstruction.LiteralMatch)matches2[0]).getLiteral());
            if (resultLiteral.equals(Boolean.TRUE)) {
                replacement = new NotInstruction(lcm.insertBody(replacement, before2));
            }
            return new PartialEvaluationResult(replacement, incremental, Collections.EMPTY_SET);
        }
        if (def != null && cases.isEmpty()) {
            def = def.cloneWithNewNames();
            IdentifierInstruction n2 = lcm.insertBody(def, before2);
            return new PartialEvaluationResult((Instruction)n2, incremental, defInfo == null ? Collections.EMPTY_SET : defInfo);
        }
        AbstractDataObjectPI adopiOut = OptimizerUtilities.findCommonalities(pic, handlers, lcm);
        HashSet<AbstractDataObjectPI> set2 = new HashSet<AbstractDataObjectPI>();
        if (cases.isEmpty() && savedMatch != null) {
            if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                s_logger.logp(Level.FINE, s_className, "extractPartialInformation", "Tried to filter all cases out of a match: " + mi);
            }
            cases.add(savedMatch);
        }
        MatchInstruction.Match[] cases2 = new MatchInstruction.Match[cases.size()];
        cases.toArray(cases2);
        mi.setMatches(cases2);
        mi.setDefault(def);
        if (adopiOut != null) {
            set2.add(adopiOut);
        }
        return new PartialEvaluationResult(set2);
    }
}

