/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NegateInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;

public class NegateEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        NegateInstruction neg = (NegateInstruction)x;
        pic.partiallyEvaluate(neg.getOperand(), lcm);
        Object opVal = PartialEvaluator.extractLiteralValue(pic, neg.getOperand(), lcm);
        Type resType = pic.resolveType(neg);
        if (!(resType instanceof INumericalType)) {
            throw new XylemError("ERR_SYSTEM", "The operand of a negation operation must be of a numeric type.");
        }
        INumericalType nResType = (INumericalType)((Object)resType);
        if (opVal == null) {
            return PartialEvaluationResult.s_emptyResult;
        }
        return new PartialEvaluationResult(new LiteralInstruction(resType, nResType.evaluateOperation(pic.getIntegerSettings(), opVal, null, 16)));
    }
}

