/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.ReductionHelper;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.BinaryPrimopInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LengthInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ParallelForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamRepeatInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamRepeatStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.RepeatedStreamPI;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.ConstructorDataType;
import com.ibm.xltxe.rnm1.xylem.types.ICollectionType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class ParallelForEachEvaluator
extends PartialEvaluator {
    private static final boolean PARALLEL_FOR_EACH_EVALUATOR_TURNED_ON = true;
    private static final boolean RETURN_OFTEN = true;

    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        int numOutputs;
        ParallelForEachInstruction pfei = (ParallelForEachInstruction)x;
        TypeEnvironment tenv = pic.getCurrentTypeEnvironment();
        BindingEnvironment benv = pic.getCurrentBindingEnvironment();
        boolean modified = false;
        Instruction[] src = pfei.getSources();
        Set[] partialInfoOnSources = new Set[src.length];
        for (int i = 0; i < src.length; ++i) {
            partialInfoOnSources[i] = pic.partiallyEvaluate(src[i], lcm);
        }
        PartialEvaluationResult per = pic.partiallyEvaluateBody(pfei.getBody(), pfei, pfei.getChildInstructionCount() - 1, lcm);
        if (per.getReplacement() != null) {
            pfei.setBody(per.getReplacement());
        }
        Binding[] bindingNames = pfei.getElementBindings();
        Instruction[] sources = pfei.getSources();
        Set freeBindings = pfei.getBody().accumulateFreeBindingsInOrder(pic.getCurrentBindingEnvironment());
        for (int i = bindingNames.length - 1; i >= 0; --i) {
            if (!freeBindings.contains(bindingNames[i])) {
                pfei.removeBinding(i);
                modified = true;
                continue;
            }
            RepeatedStreamPI rspi = RepeatedStreamPI.extractRepeatedStreamInformation(partialInfoOnSources[i]);
            if (null == rspi) continue;
            Instruction instr = rspi.getEntry().getInstruction();
            LetInstruction newLet = new LetInstruction(bindingNames[i].getName(), instr, pfei.getBody());
            pfei.setBody(newLet);
            pfei.removeBinding(i);
            benv.setVariableBinding(newLet);
            modified = true;
        }
        if (0 == pfei.getElementBindings().length) {
            IdentifierInstruction numLoops = lcm.insertBody(new LengthInstruction(sources[0]), before2);
            Integer pfeName = ReductionHelper.generateIntermediateIdentifier2();
            IdentifierInstruction ans = lcm.insertBody(pfei.getBody(), before2);
            AbstractDataType adt = pfei.getBodyADT(pic.getCurrentTypeEnvironment());
            if (1 != adt.m_constructors.length) {
                throw new XylemError("ERR_SYSTEM", "Parallel-foreach has type that is ADT with (" + adt.m_constructors.length + ") constructors, not 1.");
            }
            AbstractDataType.Constructor constructor = adt.m_constructors[0];
            int numParams = constructor.m_parameters.length;
            Instruction[] loopedParams = new Instruction[numParams];
            for (int i = 0; i < numParams; ++i) {
                IdentifierInstruction value2 = lcm.insertBody(new MatchInstruction((Instruction)ans, constructor, i), before2);
                Type type2 = value2.getType(pic.getCurrentTypeEnvironment(), pic.getCurrentBindingEnvironment());
                BinaryPrimopInstruction repeatInstruction = null;
                repeatInstruction = type2 instanceof StreamType ? new StreamRepeatStreamInstruction(value2, numLoops) : new StreamRepeatInstruction(value2, numLoops);
                loopedParams[i] = lcm.insertBody(repeatInstruction, before2);
            }
            IdentifierInstruction newAns = lcm.insertBody(new ConstructorInstantiationInstruction(adt.m_constructors[0], loopedParams), before2);
            int ksjfd = 0;
            ++ksjfd;
            return new PartialEvaluationResult((Instruction)newAns, true);
        }
        if (modified) {
            return new PartialEvaluationResult((Instruction)pfei, true);
        }
        IBinding[] pfeiBindings = pfei.getElementBindings();
        IBinding[] pfeiBodyFreeBindings = pfei.getBody().accumulateFreeBindingsAsArray(benv);
        HashSet<LetInstruction> inLoopBindings = new HashSet<LetInstruction>();
        IBinding[] inLoopBindingsArray = new IBinding[]{};
        if (pfei.getBody() instanceof LetInstruction) {
            LetInstruction leti;
            LetInstruction newBody = leti = (LetInstruction)pfei.getBody();
            LetInstruction lastLet = null;
            while (null != leti) {
                Set set2 = leti.getValue().accumulateFreeBindingsInOrder(benv);
                IBinding[] freeBindingsInValue = new IBinding[set2.size()];
                set2.toArray(freeBindingsInValue);
                if (!this.isOverlap(pfeiBindings, freeBindingsInValue) && !this.isOverlap(inLoopBindingsArray, freeBindingsInValue)) {
                    lcm.insertBodyWithNameForced(leti.getVariable(), leti.getValue(), before2);
                    if (null == lastLet) {
                        pfei.setBody(leti.getBody());
                    } else {
                        lastLet.setBody(leti.getBody());
                    }
                } else {
                    inLoopBindings.add(leti);
                    inLoopBindingsArray = new IBinding[inLoopBindings.size()];
                    inLoopBindings.toArray(inLoopBindingsArray);
                    lastLet = leti;
                }
                leti = leti.getBody() instanceof LetInstruction ? (LetInstruction)leti.getBody() : null;
            }
        }
        Instruction targetInstruction = pfei.getBody();
        Instruction targetParent = pfei;
        while (targetInstruction instanceof LetInstruction) {
            targetParent = targetInstruction;
            targetInstruction = ((LetInstruction)targetInstruction).getBody();
        }
        if (pfei.getElementBindings().length > 0 && pfei.getBodyADT((TypeEnvironment)tenv).m_constructors[0].m_parameters.length > 1 && targetInstruction instanceof ConstructorInstantiationInstruction && ((ConstructorInstantiationInstruction)targetInstruction).getConstructorName().equals(pfei.getBodyADT((TypeEnvironment)tenv).m_constructors[0].getName())) {
            ConstructorInstantiationInstruction cii = (ConstructorInstantiationInstruction)targetInstruction;
            Instruction body = pfei.getBody();
            Set pfeiFreeBindings = pfei.accumulateFreeBindingsInOrder(benv);
            IBinding[] pfeiFreeBindingsArray = new IBinding[pfeiFreeBindings.size()];
            pfeiFreeBindings.toArray(pfeiFreeBindingsArray);
            Binding[] bindings = pfei.getBodyADT((TypeEnvironment)tenv).m_constructors[0].m_parameters;
            for (int i = 0; i < bindings.length; ++i) {
                int bindingIndex;
                int bindingIndex2;
                int bindingIndex3;
                if (!(cii.m_parameters[i] instanceof IdentifierInstruction)) continue;
                IBinding thisBinding = ((IdentifierInstruction)cii.m_parameters[i]).getBinding(benv);
                Object thisBindingName = null;
                Type thisBindingType = cii.m_parameters[i].getType(tenv, benv);
                boolean OutputCanBeMovedOut = false;
                if (pfeiFreeBindings.contains(thisBinding)) {
                    OutputCanBeMovedOut = true;
                }
                if (!OutputCanBeMovedOut && thisBinding instanceof LetInstruction) {
                    LetInstruction myLet = (LetInstruction)thisBinding;
                    Set valuePISet = pic.partiallyEvaluate(cii.m_parameters[i], lcm);
                    RepeatedStreamPI rspi = RepeatedStreamPI.extractRepeatedStreamInformation(valuePISet);
                    if (null != rspi) {
                        Instruction entry = rspi.getEntry().m_instruction;
                        if (entry instanceof LiteralInstruction) {
                            IdentifierInstruction replacement = lcm.insertBody(entry, before2);
                            cii.m_parameters[i] = replacement;
                            thisBinding = replacement.getBinding();
                            thisBindingName = replacement.getVariable();
                            thisBindingType = entry.getType(tenv, benv);
                            OutputCanBeMovedOut = true;
                        } else if (entry instanceof IdentifierInstruction) {
                            IBinding entryBinding = ((IdentifierInstruction)entry).getBinding();
                            Object entryName = ((IdentifierInstruction)entry).getVariable();
                            if (pfeiFreeBindings.contains(entryBinding) || this.arrayContainsBindingWithName(pfeiFreeBindingsArray, entryName)) {
                                cii.m_parameters[i] = entry;
                                thisBinding = ((IdentifierInstruction)entry).getBinding();
                                thisBindingName = ((IdentifierInstruction)entry).getVariable();
                                thisBindingType = entry.getType(tenv, benv);
                                OutputCanBeMovedOut = true;
                            }
                        }
                        int k = 324;
                    }
                }
                if (!OutputCanBeMovedOut) continue;
                ConstructorDataType oldType = (ConstructorDataType)pfei.getBodyADT(tenv);
                Binding[] oldBindings = oldType.m_constructors[0].m_parameters;
                Binding[] newBindings = new Binding[oldBindings.length - 1];
                for (bindingIndex3 = 0; bindingIndex3 < i; ++bindingIndex3) {
                    newBindings[bindingIndex3] = oldBindings[bindingIndex3];
                }
                for (bindingIndex3 = i + 1; bindingIndex3 < oldBindings.length; ++bindingIndex3) {
                    newBindings[bindingIndex3 - 1] = oldBindings[bindingIndex3];
                }
                String newName = oldType.getName() + "_m";
                AbstractDataType.Constructor[] newConstructors = new AbstractDataType.Constructor[]{new AbstractDataType.Constructor(newName, newBindings)};
                ConstructorDataType newType = new ConstructorDataType(newName, newConstructors);
                Instruction[] newCiiParams = new Instruction[cii.m_parameters.length - 1];
                for (bindingIndex2 = 0; bindingIndex2 < i; ++bindingIndex2) {
                    newCiiParams[bindingIndex2] = cii.m_parameters[bindingIndex2];
                }
                for (bindingIndex2 = i + 1; bindingIndex2 < oldBindings.length; ++bindingIndex2) {
                    newCiiParams[bindingIndex2 - 1] = cii.m_parameters[bindingIndex2];
                }
                ConstructorInstantiationInstruction newCii = new ConstructorInstantiationInstruction(newConstructors[0], newCiiParams);
                pic.getCurrentModule().addAbstractDataType(newType);
                pfei.setBodyADTType(new NamedType(newType.getName()));
                if (targetParent instanceof LetInstruction) {
                    ((LetInstruction)targetParent).setBody(newCii);
                } else if (targetParent instanceof ParallelForEachInstruction) {
                    ((ParallelForEachInstruction)targetParent).setBody(newCii);
                } else {
                    throw new XylemError("ERR_SYSTEM", "targetParent isn't Let or PFE");
                }
                IdentifierInstruction newPfei = lcm.insertBody(pfei, before2);
                Instruction[] reconstructionValues = new IdentifierInstruction[oldBindings.length];
                for (bindingIndex = 0; bindingIndex < i; ++bindingIndex) {
                    reconstructionValues[bindingIndex] = lcm.insertBody(new MatchInstruction((Instruction)newPfei, newConstructors[0], bindingIndex), before2);
                }
                for (bindingIndex = i + 1; bindingIndex < oldBindings.length; ++bindingIndex) {
                    reconstructionValues[bindingIndex] = lcm.insertBody(new MatchInstruction((Instruction)newPfei, newConstructors[0], bindingIndex - 1), before2);
                }
                IdentifierInstruction repeatCount = lcm.insertBody(new LengthInstruction(reconstructionValues[0 == i ? 1 : 0]), before2);
                reconstructionValues[i] = thisBindingType instanceof StreamType ? lcm.insertBody(new StreamRepeatStreamInstruction(new IdentifierInstruction(null != thisBinding ? thisBinding.getName() : thisBindingName), repeatCount), before2) : lcm.insertBody(new StreamRepeatInstruction(new IdentifierInstruction(null != thisBinding ? thisBinding.getName() : thisBindingName), repeatCount), before2);
                ConstructorInstantiationInstruction ans = new ConstructorInstantiationInstruction(oldType.m_constructors[0], reconstructionValues);
                return new PartialEvaluationResult((Instruction)ans, true);
            }
        }
        int numSources = pfei.getSources().length;
        Instruction parentPFEI = null;
        LinkedList<MatchInstruction> storedMatches = new LinkedList<MatchInstruction>();
        for (int sourceNum = 0; sourceNum < numSources; ++sourceNum) {
            Instruction sourceInstr = lcm.lookupBinding(pfei.getSources()[sourceNum]);
            if (!(sourceInstr instanceof MatchInstruction)) {
                parentPFEI = null;
                break;
            }
            MatchInstruction match = (MatchInstruction)sourceInstr;
            Binding binding = match.getMemberToExtract(benv);
            Instruction toMatch = lcm.lookupBinding(match.getToMatch());
            if (!(toMatch instanceof ParallelForEachInstruction)) break;
            if (null != parentPFEI && parentPFEI != toMatch) {
                parentPFEI = null;
                break;
            }
            parentPFEI = (ParallelForEachInstruction)toMatch;
            storedMatches.add(match);
        }
        if (null != parentPFEI) {
            ParallelForEachInstruction newPfei = (ParallelForEachInstruction)parentPFEI.cloneReduced();
            Instruction bottom = newPfei.getBody();
            LetInstruction leti = null;
            while (bottom instanceof LetInstruction) {
                leti = (LetInstruction)bottom;
                bottom = leti.getBody();
            }
            Integer parentPFEIvar = ReductionHelper.generateIntermediateIdentifier2();
            leti.setBody(new LetInstruction(parentPFEIvar, bottom, pfei.cloneWithNewNames()));
            leti = (LetInstruction)leti.getBody();
            bottom = leti.getBody();
            Object[] matchVars = new Object[storedMatches.size()];
            Instruction[] matchIIs = new Instruction[storedMatches.size()];
            Iterator matchIter = storedMatches.iterator();
            int matchIndex = 0;
            while (matchIter.hasNext()) {
                MatchInstruction match = (MatchInstruction)((MatchInstruction)matchIter.next()).cloneWithNewNames();
                matchVars[matchIndex] = ReductionHelper.generateIntermediateIdentifier2();
                matchIIs[matchIndex] = new IdentifierInstruction(matchVars[matchIndex]);
                match.setToMatch(new IdentifierInstruction(parentPFEIvar));
                leti.setBody(new LetInstruction(matchVars[matchIndex], match, bottom));
                leti = (LetInstruction)leti.getBody();
                ++matchIndex;
            }
            ParallelForEachInstruction pfe = (ParallelForEachInstruction)bottom;
            pfe = new ParallelForEachInstruction(matchIIs, pfe.getElementVars(), pfe.getBody(), pfe.getBodyADTNamedType());
            leti.setBody(pfe);
            return new PartialEvaluationResult((Instruction)newPfei, true);
        }
        if (1 == pfei.getElementBindings().length && 1 == (numOutputs = pfei.getBodyADT((TypeEnvironment)tenv).m_constructors[0].m_parameters.length)) {
            Instruction newBody;
            Integer oldBodyIdent = ReductionHelper.generateIntermediateIdentifier2();
            IdentifierInstruction oldBodyInstr = new IdentifierInstruction(oldBodyIdent);
            Instruction leti = pfei.getBody();
            LetInstruction parent2 = null;
            while (leti instanceof LetInstruction) {
                parent2 = (LetInstruction)leti;
                leti = ((LetInstruction)leti).getBody();
            }
            LetInstruction nonParallelBody = new LetInstruction(oldBodyIdent, leti, new MatchInstruction((Instruction)oldBodyInstr, pfei.getBodyADT((TypeEnvironment)tenv).m_constructors[0], 0));
            if (null == parent2) {
                newBody = nonParallelBody;
            } else {
                parent2.setBody(nonParallelBody);
                newBody = pfei.getBody();
            }
            Object pfeiIndexVar = pfei.getIndexVar();
            ForEachInstruction foreach = null != pfeiIndexVar ? new ForEachInstruction(pfei.getSources()[0], pfei.getElementVars()[0], newBody, (ICollectionType)((Object)pfei.getSources()[0].getType(tenv, benv))) : new ForEachInstruction(pfei.getSources()[0], pfei.getElementVars()[0], pfei.getIndexVar(), newBody, (ICollectionType)((Object)pfei.getSources()[0].getType(tenv, benv)));
            IdentifierInstruction foreachInstr = lcm.insertBody(foreach, before2);
            ConstructorInstantiationInstruction replacement = new ConstructorInstantiationInstruction(pfei.getBodyADT((TypeEnvironment)tenv).m_constructors[0], new Instruction[]{foreachInstr});
            return new PartialEvaluationResult((Instruction)replacement, true);
        }
        Instruction firstSource = lcm.lookupBinding(pfei.getSources()[0]);
        if (1 == pfei.getElementBindings().length && firstSource instanceof StreamInstruction) {
            StreamInstruction stream2 = (StreamInstruction)firstSource;
            int streamLength = stream2.getChildInstructionCount();
            boolean jfew = true;
        }
        if (modified) {
            return new PartialEvaluationResult((Instruction)pfei, true);
        }
        return PartialEvaluationResult.s_emptyResult;
    }

    private static Set recursivelyAccumulateNonLetFreeBindings(Instruction n2, BindingEnvironment benv) {
        HashSet baseSet = new HashSet();
        HashSet<IBinding> finalSet = new HashSet<IBinding>();
        HashSet<IBinding> doneSet = new HashSet<IBinding>();
        n2.accumulateFreeBindings(baseSet, benv);
        while (!baseSet.isEmpty()) {
            IBinding binding = (IBinding)baseSet.iterator().next();
            baseSet.remove(binding);
            doneSet.add(binding);
            if (binding instanceof LetInstruction) {
                LetInstruction leti = (LetInstruction)binding;
                leti.getValue().accumulateFreeBindings(baseSet, benv);
                continue;
            }
            finalSet.add(binding);
        }
        return finalSet;
    }

    private boolean isOverlap(IBinding[] a, IBinding[] b) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < b.length; ++j) {
                if (a[i] != b[j]) continue;
                return true;
            }
        }
        return false;
    }

    private boolean arrayContainsBindingWithName(IBinding[] a, Object name2) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].getName().equals(name2)) continue;
            return true;
        }
        return false;
    }
}

