/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IdentifierConsolidator;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.Optimizer;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NotInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.ADTMatchEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.EvaluatorDiscoveringPartialInformationCollector;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.FLD2ForEachEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.ForEachEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.FunctionCallEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.MatchEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class PartialEvaluationOptimizer
extends Optimizer {
    protected HashMap<Class<? extends Instruction>, Collection<PartialEvaluator>> m_evaluators = new HashMap(499);
    protected HashSet<String> m_functions = new HashSet();
    protected HashSet<String> m_functionsIfStaticArg = new HashSet();
    public HashSet<String> m_entryPoints = new HashSet();
    public IdentifierConsolidator m_ic;
    private IntegerSettings m_is;

    public PartialEvaluationOptimizer(Set<String> entryPoints, IntegerSettings is2) {
        this.m_entryPoints.addAll(entryPoints);
        this.m_is = is2;
        this.baseSetup();
    }

    public PartialEvaluationOptimizer(IntegerSettings is2) {
        this.m_entryPoints.add("main");
        this.m_is = is2;
        this.baseSetup();
    }

    protected void baseSetup() {
        this.addEvaluator(ForEachInstruction.class, new ForEachEvaluator());
        this.addEvaluator(ForEachInstruction.class, new FLD2ForEachEvaluator());
        this.addEvaluator(MatchInstruction.class, new ADTMatchEvaluator());
        this.addEvaluator(MatchInstruction.class, new MatchEvaluator());
        this.setupFunctionCallEvaluators();
    }

    public PartialInformationCollector createInitialFuncInfoCollector(Instruction n2, Map evaluators, Function f2) {
        return new EvaluatorDiscoveringPartialInformationCollector(n2, evaluators, f2, this.m_is);
    }

    @Override
    public Instruction optimize(Instruction n2) {
        PartialInformationCollector pic = this.createInitialFuncInfoCollector(n2, this.m_evaluators, this.m_currentFunction);
        pic.m_identifierConsolidator = this.m_ic;
        Instruction result0 = pic.doPartialEvaluation().getReplacement();
        if (result0 == null) {
            result0 = n2;
        } else {
            result0 = result0.removeAliases(new HashMap());
            Function f2 = this.getCurrentFunction();
            result0.typeCheckReduced(f2.getTypeEnvironment(), f2.getBindingEnvironment(), new LinkedList<Function>());
        }
        return result0;
    }

    protected void addEvaluator(Class<? extends Instruction> x, PartialEvaluator pe) {
        Collection<PartialEvaluator> c = this.m_evaluators.get(x);
        if (c == null) {
            c = new ArrayList<PartialEvaluator>();
            this.m_evaluators.put(x, c);
        }
        c.add(pe);
    }

    public void addEvaluator(PartialEvaluator pe) {
        Class<? extends Instruction>[] x = pe.getSupportedInstructionClasses();
        for (int i = 0; i < x.length; ++i) {
            this.addEvaluator(x[i], pe);
        }
    }

    @Override
    public void optimizeFunction(Function f2) {
        if (this.m_entryPoints.contains(f2.getName())) {
            PartialInformationCollector pic = this.createInitialFuncInfoCollector(f2.getBody(), this.m_evaluators, f2);
            pic.m_identifierConsolidator = this.m_ic;
            pic.doPartialEvaluationFromFunction(f2);
        }
    }

    protected void setupFunctionCallEvaluators() {
        this.addEvaluator(FunctionCallInstruction.class, new FunctionCallEvaluator(){

            @Override
            protected boolean allowInlining(FunctionCallInstruction fci, Function f2, BindingEnvironment benv) {
                LetInstruction leti;
                Instruction value2;
                if (PartialEvaluationOptimizer.this.m_functionsIfStaticArg.contains(f2.getName())) {
                    return fci.getOperands()[0].isStatic(benv);
                }
                Instruction effectiveBody = f2.getBody();
                while (effectiveBody instanceof LetInstruction && ((value2 = (leti = (LetInstruction)effectiveBody).getValue()) instanceof LiteralInstruction || value2 instanceof IdentifierInstruction)) {
                    effectiveBody = leti.getBody();
                }
                if (effectiveBody instanceof FunctionCallInstruction) {
                    FunctionCallInstruction fci2 = (FunctionCallInstruction)effectiveBody;
                    Function f22 = f2.getTypeEnvironment().getModule().getFunction(fci2.getFunction());
                    if (!f2.getMemoizeResult() || f22.getMemoizeResult()) {
                        return true;
                    }
                } else if (effectiveBody instanceof MatchInstruction) {
                    MatchInstruction mi = (MatchInstruction)effectiveBody;
                    if (mi.getDefault() == null && mi.getMatches().length == 1) {
                        NotInstruction noti;
                        Instruction instr = mi.getMatches()[0].getHandler();
                        if (instr instanceof IdentifierInstruction) {
                            return true;
                        }
                        if (instr instanceof NotInstruction && (noti = (NotInstruction)instr).getOperand() instanceof IdentifierInstruction) {
                            return true;
                        }
                    }
                } else if (effectiveBody instanceof ConstructorInstantiationInstruction) {
                    return true;
                }
                if (f2.getInlineHint()) {
                    return true;
                }
                if (f2.getBody().isStatic(f2.getBindingEnvironment())) {
                    return true;
                }
                return PartialEvaluationOptimizer.this.m_functions.contains(f2.getName());
            }
        });
    }
}

