/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.NavigationUtilities;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class PartialEvaluator {
    public abstract PartialEvaluationResult extractPartialInformation(Instruction var1, PartialInformationCollector var2, LetInstruction var3, LetChainManager var4);

    public Class<? extends Instruction>[] getSupportedInstructionClasses() {
        return new Class[0];
    }

    public static final Object extractLiteralValue(PartialInformationCollector pic, Instruction n2, LetChainManager lcm) {
        if (n2 == null) {
            return null;
        }
        if (n2 instanceof LiteralInstruction) {
            return ((LiteralInstruction)n2).getValue();
        }
        if (n2 instanceof IdentifierInstruction) {
            return PartialEvaluator.extractLiteralValue(pic, lcm.lookupBinding(n2), lcm);
        }
        return null;
    }

    public static final Integer extractIntegerValue(PartialInformationCollector pic, Instruction n2, LetChainManager lcm) {
        Object obj = PartialEvaluator.extractLiteralValue(pic, n2, lcm);
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return null;
    }

    public static final Object[] extractStreamOfLiteralsValue(PartialInformationCollector pic, Instruction n2, LetChainManager lcm) {
        if (n2 == null) {
            return null;
        }
        if (n2 instanceof StreamInstruction) {
            StreamInstruction stream2 = (StreamInstruction)n2;
            int num = stream2.getChildInstructionCount();
            Object[] ans = new Object[num];
            for (int i = 0; i < num; ++i) {
                Instruction child2 = stream2.getChildInstruction(i);
                if (!(child2 instanceof LiteralInstruction)) {
                    return null;
                }
                ans[i] = ((LiteralInstruction)child2).getValue();
            }
            return ans;
        }
        if (n2 instanceof IdentifierInstruction) {
            return PartialEvaluator.extractStreamOfLiteralsValue(pic, lcm.lookupBinding(n2), lcm);
        }
        return null;
    }

    public static final LiteralInstruction.KnownValue extractKnownValue(PartialInformationCollector pic, Instruction n2, LetChainManager lcm) {
        if (n2 == null) {
            return null;
        }
        if (n2 instanceof LiteralInstruction) {
            return new LiteralInstruction.KnownValue(((LiteralInstruction)n2).getValue());
        }
        if (n2 instanceof StreamInstruction) {
            StreamInstruction stream2 = (StreamInstruction)n2;
            int num = stream2.getChildInstructionCount();
            Object[] ans = new Object[num];
            for (int i = 0; i < num; ++i) {
                Instruction child2 = stream2.getChildInstruction(i);
                if (!(child2 instanceof LiteralInstruction)) {
                    return null;
                }
                ans[i] = ((LiteralInstruction)child2).getValue();
            }
            return new LiteralInstruction.KnownValue(ans);
        }
        if (n2 instanceof IdentifierInstruction) {
            return PartialEvaluator.extractKnownValue(pic, lcm.lookupBinding(n2), lcm);
        }
        return null;
    }

    public static final Iterator accumulateStream(StreamInstruction si, PartialInformationCollector pic, LetChainManager lcm) {
        AccumulatedStreamIterator asi = new AccumulatedStreamIterator();
        PartialEvaluator.accumulateStreamInner(si, asi.m_list, pic, lcm);
        return asi;
    }

    private static final void accumulateStreamInner(StreamInstruction si, List list, PartialInformationCollector pic, LetChainManager lcm) {
        if (si.isStoredAsString()) {
            String s = si.getStringContent();
            if (s.length() > 0) {
                list.add(s);
            }
        } else {
            int c = si.getChildInstructionCount();
            for (int i = 0; i < c; ++i) {
                Instruction n2 = si.getChildInstruction(i);
                pic.partiallyEvaluate(n2, lcm);
                Instruction y = lcm.lookupBinding(n2);
                if (y instanceof StreamInstruction) {
                    PartialEvaluator.accumulateStreamInner((StreamInstruction)y, list, pic, lcm);
                    continue;
                }
                list.add(NavigationUtilities.resolveIdentifierAliases(n2, pic.getCurrentBindingEnvironment()));
            }
        }
    }

    public static final void accumulateStream(StreamInstruction si, List list, PartialInformationCollector pic, LetChainManager lcm) {
        int c = si.getChildInstructionCount();
        for (int i = 0; i < c; ++i) {
            Instruction n2 = si.getChildInstruction(i);
            pic.partiallyEvaluate(n2, lcm);
            Instruction y = lcm.lookupBinding(n2);
            if (y instanceof StreamInstruction) {
                PartialEvaluator.accumulateStream((StreamInstruction)y, list, pic, lcm);
                continue;
            }
            list.add(NavigationUtilities.resolveIdentifierAliases(n2, pic.getCurrentBindingEnvironment()));
        }
    }

    public static final Instruction moveToBottom(Instruction body, Object bodyIdent, Instruction c) {
        return PartialEvaluator.moveToBottom(body, bodyIdent, c, null);
    }

    public static final Instruction moveToBottom(Instruction body, Object bodyIdent, Instruction c, BindingEnvironment benv) {
        LetInstruction newLet;
        Instruction a = body;
        LetInstruction b = null;
        while (a instanceof LetInstruction) {
            b = (LetInstruction)a;
            a = b.getBody();
        }
        if (b != null) {
            newLet = new LetInstruction(bodyIdent, a, c);
            b.setBody(newLet);
            c = body;
        } else {
            newLet = new LetInstruction(bodyIdent, a, c);
            c = newLet;
        }
        if (benv != null) {
            benv.setVariableBinding(newLet);
        }
        return c;
    }

    private static final class AccumulatedStreamIterator
    implements Iterator {
        ArrayList m_list = new ArrayList();
        String m_subPartStream;
        int m_part = 0;
        int m_subPart = 0;

        private AccumulatedStreamIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.m_part < this.m_list.size() || this.m_subPartStream != null && this.m_subPart < this.m_subPartStream.length();
        }

        public Object next() {
            Object result2;
            if (this.m_subPartStream != null) {
                if (this.m_subPart < this.m_subPartStream.length()) {
                    return LiteralInstruction.charLiteral(this.m_subPartStream.charAt(this.m_subPart++));
                }
                this.m_subPartStream = null;
            }
            if ((result2 = this.m_list.get(this.m_part++)) instanceof String) {
                this.m_subPartStream = (String)result2;
                this.m_subPart = 1;
                return LiteralInstruction.charLiteral(this.m_subPartStream.charAt(0));
            }
            return result2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

