/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.BindingEnvironment;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.IBinding;
import com.ibm.xltxe.rnm1.xylem.IdentifierConsolidator;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.IntegerSettings;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.DeadLetEliminatorOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.FlattenStreamOptimizer;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.DefaultEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.LoggerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PartialInformationCollector {
    private static final Logger s_logger = LoggerUtil.getLogger(PartialInformationCollector.class);
    private static final String s_className = PartialInformationCollector.class.getName();
    protected Map m_evaluators;
    protected PartialEvaluator m_defaultEvaluator;
    protected Instruction m_baseInstruction;
    protected DeadLetEliminatorOptimizer m_deadLetEliminator;
    protected FlattenStreamOptimizer m_fso;
    protected LetChainManager m_baseLetChainManager;
    public LinkedList m_callStack;
    public HashSet m_completedFunctions;
    protected HashSet m_overflowFunctions;
    protected Function m_currentFunction;
    protected IntegerSettings m_integerSettings;
    protected IdentifierConsolidator m_identifierConsolidator = null;
    protected int m_evaluationStackDepth = 0;
    protected int m_evaluationStackLimit = 250;
    public boolean m_allowFunctionRecursion = true;
    public boolean m_requestRedo = false;
    static final int s_retryLimit = 10;
    private LinkedList m_emptyLinkedList = new LinkedList();

    public PartialInformationCollector(Instruction baseInstruction, Map evaluators, Function f2, IntegerSettings is2) {
        this(baseInstruction, evaluators, new DefaultEvaluator(), f2, is2);
    }

    public PartialInformationCollector(Instruction baseInstruction, Map evaluators, PartialEvaluator defaultEvaluator, Function f2, IntegerSettings is2) {
        this(baseInstruction, evaluators, defaultEvaluator, f2, is2, new DeadLetEliminatorOptimizer(), new FlattenStreamOptimizer(), new HashSet());
    }

    protected PartialInformationCollector(Instruction baseInstruction, Map evaluators, PartialEvaluator defaultEvaluator, Function f2, IntegerSettings is2, DeadLetEliminatorOptimizer dleo, FlattenStreamOptimizer fso, HashSet overflowFunctions) {
        this.m_evaluators = evaluators;
        this.m_defaultEvaluator = defaultEvaluator;
        this.m_baseInstruction = baseInstruction;
        this.m_baseLetChainManager = new LetChainManager(baseInstruction, f2);
        this.m_callStack = new LinkedList();
        this.m_completedFunctions = new HashSet();
        this.m_currentFunction = f2;
        this.m_integerSettings = is2;
        this.m_deadLetEliminator = dleo;
        this.m_fso = fso;
        this.m_overflowFunctions = overflowFunctions;
    }

    public PartialInformationCollector getFunctionSubcollector(Function f2) {
        PartialInformationCollector subcollector = this.createSubcollector(f2, this.m_integerSettings);
        this.shareState(subcollector);
        return subcollector;
    }

    public PartialInformationCollector createSubcollector(Function f2, IntegerSettings is2) {
        return new PartialInformationCollector(f2.getBody(), this.m_evaluators, this.m_defaultEvaluator, f2, is2, this.m_deadLetEliminator, this.m_fso, this.m_overflowFunctions);
    }

    public void shareState(PartialInformationCollector recipient) {
        recipient.m_identifierConsolidator = this.m_identifierConsolidator;
        recipient.m_callStack = this.m_callStack;
        recipient.m_completedFunctions = this.m_completedFunctions;
        recipient.m_evaluationStackDepth = this.m_evaluationStackDepth;
    }

    public void partiallyEvaluateFunction(Function f2) {
        String name2 = f2.getName();
        if (this.m_completedFunctions.contains(name2)) {
            return;
        }
        if (this.m_callStack.contains(name2)) {
            return;
        }
        if (this.m_evaluationStackDepth > this.m_evaluationStackLimit) {
            if (this.m_callStack.size() == 1) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "partiallyEvaluateFunction", "Function " + this.m_currentFunction.getName() + " is too big for stack limit, even when being evaluated alone; requesting called function " + name2 + " be evaluated separately");
                }
                this.m_overflowFunctions.add(f2);
            } else {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "partiallyEvaluateFunction", "Preventing stack overflow in partial evaluator by postponing " + name2);
                }
                this.m_overflowFunctions.add(this.m_currentFunction);
            }
        } else {
            PartialEvaluationResult peResult;
            try {
                while (true) {
                    this.m_callStack.addLast(name2);
                    PartialInformationCollector pic = this.getFunctionSubcollector(f2);
                    peResult = pic.doPartialEvaluationInternal();
                    Instruction result2 = peResult.getReplacement();
                    if (result2 == null) {
                        result2 = f2.getBody();
                    } else {
                        result2 = this.m_deadLetEliminator.optimize(result2, f2);
                        result2 = result2.removeAliases(new HashMap());
                    }
                    f2.setBody(result2);
                    this.m_fso.optimizeFunction(f2);
                    this.m_deadLetEliminator.optimizeFunction(f2);
                    if (this.m_identifierConsolidator != null) {
                        this.m_identifierConsolidator.processFunction(f2);
                    }
                    this.m_callStack.removeLast();
                    this.m_completedFunctions.add(name2);
                    if (pic.m_evaluationStackDepth != this.m_evaluationStackDepth && LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                        s_logger.logp(Level.FINE, s_className, "partiallyEvaluateFunction", "PIC evaluation depth not equal to evaluation stack depth: " + pic.m_evaluationStackDepth + " from " + this.m_evaluationStackDepth);
                    }
                    if (pic.m_requestRedo) {
                        if (!LoggerUtil.isAnyTracingEnabled() || !s_logger.isLoggable(Level.FINE)) continue;
                        s_logger.logp(Level.FINE, s_className, "partiallyEvaluateFunction", "Redoing function " + f2.getName());
                        continue;
                    }
                    break;
                }
            }
            catch (PartialEvaluationStackOverflow peso) {
                if (peso.m_depth / 2 > this.m_evaluationStackDepth) {
                    if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                        s_logger.logp(Level.FINE, s_className, "partiallyEvaluateFunction", "StackOverflow during optimization of '" + peso.m_fName + "' at depth " + peso.m_depth + "\n" + "\tpostponing evaluation of tree starting with " + name2 + " at depth " + this.m_evaluationStackDepth);
                    }
                    this.m_overflowFunctions.add(this.m_currentFunction);
                    return;
                }
                throw peso;
            }
            catch (StackOverflowError soe) {
                throw new PartialEvaluationStackOverflow(this.m_evaluationStackDepth, name2);
            }
            Module module = f2.getTypeEnvironment().getModule();
            module.setPartialInformation(f2.getName(), peResult.getPartialInformation());
        }
    }

    public PartialEvaluationResult runEvaluators(Instruction n2, LetInstruction before2, LetChainManager lcm) {
        Instruction result2;
        PartialEvaluationResult per;
        ++this.m_evaluationStackDepth;
        Instruction lastKnownGood = null;
        int retries = 0;
        while (true) {
            PartialEvaluator pe;
            if (n2 == null || n2 instanceof IdentifierInstruction || n2 instanceof LiteralInstruction) {
                throw new IllegalArgumentException("argument " + n2);
            }
            if (this.m_allowFunctionRecursion && n2 instanceof FunctionCallInstruction) {
                this.partiallyEvaluateFunction(this.m_currentFunction.getTypeEnvironment().getModule().getFunction(((FunctionCallInstruction)n2).getFunction()));
            }
            Collection evaluators = this.getEvaluators(n2.getClass());
            per = null;
            Iterator i = evaluators.iterator();
            while (i.hasNext() && (per = (pe = (PartialEvaluator)i.next()).extractPartialInformation(n2, this, before2, lcm)).getReplacement() == null) {
            }
            result2 = per.getReplacement();
            if (result2 instanceof LetInstruction) {
                throw new UnsupportedOperationException();
            }
            if (result2 != null) {
                this.typeCheckReplacement(n2, result2, lcm, before2);
            }
            if (!per.isIncremental()) break;
            ++retries;
            lastKnownGood = result2;
            if (result2 instanceof IdentifierInstruction) {
                Instruction result22 = lcm.lookupBinding(result2);
                if (result22 == null) {
                    --this.m_evaluationStackDepth;
                    return per;
                }
                LetInstruction leti = lcm.findBinding(((IdentifierInstruction)result2).getVariable()).getLet();
                if (leti != null && leti.m_partialInformation != null) {
                    --this.m_evaluationStackDepth;
                    return per;
                }
                result2 = result22;
            }
            if (result2 instanceof LiteralInstruction) {
                --this.m_evaluationStackDepth;
                return per;
            }
            if (retries == 10) {
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINE)) {
                    s_logger.logp(Level.FINE, s_className, "runEvaluators", "Retry limit hit; stopping: " + result2);
                }
                --this.m_evaluationStackDepth;
                return per;
            }
            n2 = result2;
        }
        Boolean alpha1 = new Boolean(result2 != null);
        Instruction[] alpha2 = new Instruction[]{lastKnownGood};
        if (alpha2[0] != null && !alpha1.booleanValue()) {
            per = new PartialEvaluationResult(lastKnownGood, false, per.getPartialInformation());
        }
        --this.m_evaluationStackDepth;
        return per;
    }

    public Collection getEvaluators(Class c) {
        ArrayList<PartialEvaluator> coll = this.getInstalledEvaluators(c);
        if (coll == null || coll.size() == 0) {
            coll = new ArrayList<PartialEvaluator>();
            coll.add(this.m_defaultEvaluator);
        }
        return coll;
    }

    public Collection getInstalledEvaluators(Class c) {
        Collection coll = (Collection)this.m_evaluators.get(c);
        return coll;
    }

    public PartialEvaluationResult runDefaultEvaluator(Instruction n2, LetInstruction before2, LetChainManager lcm) {
        return this.m_defaultEvaluator.extractPartialInformation(n2, this, before2, lcm);
    }

    public void doPartialEvaluationFromFunction(Function f2) {
        this.partiallyEvaluateFunction(f2);
        this.processOverflowFunctions();
    }

    protected void processOverflowFunctions() {
        while (!this.m_overflowFunctions.isEmpty()) {
            for (Function f2 : this.m_overflowFunctions) {
                this.m_completedFunctions.remove(f2.getName());
            }
            Iterator i = this.m_overflowFunctions.iterator();
            this.m_overflowFunctions = new HashSet();
            while (i.hasNext()) {
                Function f2;
                f2 = (Function)i.next();
                if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
                    s_logger.logp(Level.FINER, s_className, "processOverflowFunctions", "Partially evaluating overflow function " + f2.getName());
                }
                this.partiallyEvaluateFunction(f2);
            }
        }
    }

    public PartialEvaluationResult doPartialEvaluation() {
        PartialEvaluationResult per = this.doPartialEvaluationInternal();
        this.processOverflowFunctions();
        return per;
    }

    protected PartialEvaluationResult doPartialEvaluationInternal() {
        if (this.m_baseLetChainManager.m_targetInstruction instanceof LiteralInstruction) {
            return PartialEvaluationResult.s_emptyResult;
        }
        if (this.m_baseLetChainManager.m_targetInstruction instanceof IdentifierInstruction) {
            this.partiallyEvaluate(this.m_baseLetChainManager.m_targetInstruction, this.m_baseLetChainManager);
            LetInstruction result2 = this.m_baseLetChainManager.m_outerLet == null ? null : this.m_baseLetChainManager.m_outerLet;
            return new PartialEvaluationResult(result2);
        }
        PartialEvaluationResult result3 = this.runEvaluators(this.m_baseLetChainManager.m_targetInstruction, null, this.m_baseLetChainManager);
        Instruction n2 = result3.getReplacement();
        if (n2 instanceof LiteralInstruction) {
            return result3;
        }
        return new PartialEvaluationResult(this.m_baseLetChainManager.graftFinalBody(n2), result3.isIncremental(), result3.getPartialInformation());
    }

    private static String arrayToString(Object[] arr) {
        String ans = "[";
        if (arr.length > 0) {
            ans = null == arr[0] ? ans + "null" : ans + arr[0].toString();
        }
        for (int i = 1; i < arr.length; ++i) {
            ans = null == arr[i] ? ans + ", null" : ans + ", " + arr[i].toString();
        }
        ans = ans + "]";
        return ans;
    }

    public static HashMap setupDeconstructionBindingReplacement(Instruction[] params, IBinding[] bindings, Instruction body, LetChainManager lcm, LetInstruction before2) {
        if (params.length > bindings.length) {
            throw new RuntimeException("replaceDeconstructionBindings(" + PartialInformationCollector.arrayToString(params) + ", " + PartialInformationCollector.arrayToString(bindings) + ")");
        }
        HashMap<Object, Instruction> map2 = new HashMap<Object, Instruction>();
        for (int k = 0; k < params.length; ++k) {
            Instruction param = params[k];
            if (param == null) continue;
            map2.put(bindings[k].getName(), param);
        }
        return map2;
    }

    public PartialEvaluationResult partiallyEvaluateBody(Instruction n2, Instruction parent2, int parentIndex, LetChainManager lcm) {
        LetChainManager lcm2 = new LetChainManager(n2, lcm, lcm.m_currentFunction, parent2, parentIndex);
        Instruction oldBase = n2;
        n2 = lcm2.m_targetInstruction;
        if (n2 instanceof IdentifierInstruction) {
            Instruction newBase;
            Set info = this.partiallyEvaluate(n2, lcm2);
            Instruction instruction2 = newBase = lcm2.m_outerLet == null ? oldBase : lcm2.m_outerLet;
            if (newBase != oldBase) {
                return new PartialEvaluationResult(newBase, info);
            }
            return new PartialEvaluationResult(info);
        }
        if (n2 instanceof LiteralInstruction) {
            return PartialEvaluationResult.s_emptyResult;
        }
        PartialEvaluationResult per = this.runEvaluators(lcm2.m_targetInstruction, null, lcm2);
        Instruction n22 = per.getReplacement();
        if (n22 instanceof LiteralInstruction) {
            return new PartialEvaluationResult(n22, per.getPartialInformation());
        }
        return new PartialEvaluationResult(lcm2.graftFinalBody(n22), per.getPartialInformation());
    }

    public Set partiallyEvaluate(Instruction n2, LetChainManager lcm) {
        if (!(n2 instanceof IdentifierInstruction)) {
            if (n2 instanceof LiteralInstruction) {
                return Collections.EMPTY_SET;
            }
            throw new IllegalArgumentException("Should not occur in reduced code: (" + n2.getClass() + ")" + n2);
        }
        IBinding b = lcm.findBinding(((IdentifierInstruction)n2).getVariable());
        if (b == null) {
            throw new RuntimeException();
        }
        if (b.getLet() == null) {
            return Collections.EMPTY_SET;
        }
        LetInstruction leti = b.getLet();
        Set set2 = leti.m_partialInformation;
        if (set2 != null) {
            return set2;
        }
        Instruction value2 = leti.getValue();
        if (value2 instanceof LiteralInstruction) {
            return Collections.EMPTY_SET;
        }
        if (value2 instanceof IdentifierInstruction) {
            set2 = this.partiallyEvaluate(value2, lcm);
            return set2;
        }
        if (value2 == null) {
            throw new XylemError("ERR_SYSTEM", "null value for binding " + b + " " + lcm.getCurrentFunction());
        }
        PartialEvaluationResult per = this.runEvaluators(value2, leti, lcm);
        leti.m_partialInformation = set2 = per.getPartialInformation();
        Instruction replacement = per.getReplacement();
        if (replacement != null) {
            this.replaceLetValue(b.getLet(), replacement);
            if (replacement instanceof IdentifierInstruction && (set2 == null || set2.isEmpty())) {
                leti.m_partialInformation = set2 = this.partiallyEvaluate(replacement, lcm);
            }
        }
        return set2;
    }

    protected void replaceLetValue(LetInstruction let, Instruction replacement) {
        let.setValue(replacement);
    }

    protected void typeCheckReplacement(Instruction toReplace, Instruction replacement, LetChainManager lcm, LetInstruction before2) {
        replacement.typeCheckReduced(this.getCurrentTypeEnvironment(), this.getCurrentBindingEnvironment(), this.m_emptyLinkedList);
    }

    public Type resolveType(Instruction n2) {
        BindingEnvironment benv;
        TypeEnvironment tenv = this.m_currentFunction.getTypeEnvironment();
        Type t = n2.getType(tenv, benv = this.m_currentFunction.getBindingEnvironment());
        if (t == null) {
            throw new RuntimeException();
        }
        return t.resolveType(tenv);
    }

    public Module getCurrentModule() {
        return this.m_currentFunction.getTypeEnvironment().getModule();
    }

    public IntegerSettings getIntegerSettings() {
        return this.m_integerSettings;
    }

    public TypeEnvironment getCurrentTypeEnvironment() {
        return this.m_currentFunction.getTypeEnvironment();
    }

    public BindingEnvironment getCurrentBindingEnvironment() {
        return this.m_currentFunction.getBindingEnvironment();
    }

    public void setIdentifierConsolidator(IdentifierConsolidator ic) {
        this.m_identifierConsolidator = ic;
    }

    public LetChainManager getBaseLetChainManager() {
        return this.m_baseLetChainManager;
    }

    private static class PartialEvaluationStackOverflow
    extends RuntimeException {
        int m_depth;
        String m_fName;

        PartialEvaluationStackOverflow(int depth, String fName) {
            this.m_depth = depth;
            this.m_fName = fName;
        }
    }
}

