/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveArithmeticInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import com.ibm.xltxe.rnm1.xylem.types.INumericalType;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;

public class PrimitiveArithmeticEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        PrimitiveArithmeticInstruction pei = (PrimitiveArithmeticInstruction)x;
        pic.partiallyEvaluate(pei.getOperand1(), lcm);
        pic.partiallyEvaluate(pei.getOperand2(), lcm);
        Object o1 = PartialEvaluator.extractLiteralValue(pic, pei.getOperand1(), lcm);
        Object o2 = PartialEvaluator.extractLiteralValue(pic, pei.getOperand2(), lcm);
        Type t = pic.resolveType(pei);
        if (!(t instanceof INumericalType)) {
            throw new XylemError("ERR_SYSTEM", "Only numerical types are supported by the numerical operators; found " + t);
        }
        INumericalType nt = (INumericalType)((Object)t);
        if (o1 == null || o2 == null) {
            return PartialEvaluationResult.s_emptyResult;
        }
        return new PartialEvaluationResult(new LiteralInstruction(t, nt.evaluateOperation(pic.getIntegerSettings(), o1, o2, pei.getOperation())));
    }
}

