/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NotInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;

public class PrimitiveEqualityEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        PrimitiveEqualityInstruction pei = (PrimitiveEqualityInstruction)x;
        Instruction op1 = pei.getOperand1();
        Instruction op2 = pei.getOperand2();
        pic.partiallyEvaluate(op1, lcm);
        pic.partiallyEvaluate(op2, lcm);
        Object o1 = PartialEvaluator.extractLiteralValue(pic, op1, lcm);
        Object o2 = PartialEvaluator.extractLiteralValue(pic, op2, lcm);
        if (o1 == null && o2 == null) {
            return PartialEvaluationResult.s_emptyResult;
        }
        if (o1 != null && o2 != null) {
            return new PartialEvaluationResult(o1.equals(o2) ? LiteralInstruction.booleanTrueLiteral() : LiteralInstruction.booleanFalseLiteral());
        }
        if (Boolean.TRUE.equals(o1)) {
            return new PartialEvaluationResult(op2);
        }
        if (Boolean.TRUE.equals(o2)) {
            return new PartialEvaluationResult(op1);
        }
        if (Boolean.FALSE.equals(o1)) {
            return new PartialEvaluationResult(new NotInstruction(op2));
        }
        if (Boolean.FALSE.equals(o2)) {
            return new PartialEvaluationResult(new NotInstruction(op1));
        }
        return PartialEvaluationResult.s_emptyResult;
    }
}

