/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.RoundInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;

public class RoundEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        RoundInstruction ni = (RoundInstruction)x;
        Instruction operand2 = ni.getOperand();
        pic.partiallyEvaluate(operand2, lcm);
        Object y = RoundEvaluator.extractLiteralValue(pic, operand2, lcm);
        if (y != null) {
            if (y instanceof Double) {
                return new PartialEvaluationResult(LiteralInstruction.doubleLiteral(Math.round((Double)y)));
            }
            if (y instanceof Float) {
                return new PartialEvaluationResult(LiteralInstruction.floatLiteral(Math.round(((Float)y).floatValue())));
            }
            if (y instanceof Integer) {
                return new PartialEvaluationResult(LiteralInstruction.integerLiteral((Integer)y));
            }
            if (y instanceof Long) {
                return new PartialEvaluationResult(LiteralInstruction.longLiteral((Long)y));
            }
        }
        return PartialEvaluationResult.s_emptyResult;
    }
}

