/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamElementInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;

public class StreamElementEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        StreamElementInstruction sei = (StreamElementInstruction)x;
        pic.partiallyEvaluate(sei.getOperand1(), lcm);
        pic.partiallyEvaluate(sei.getOperand2(), lcm);
        Instruction streami = lcm.lookupBinding(sei.getOperand1());
        Instruction indexi = lcm.lookupBinding(sei.getOperand2());
        if (!(indexi instanceof LiteralInstruction)) {
            return PartialEvaluationResult.s_emptyResult;
        }
        if (!(streami instanceof StreamInstruction)) {
            return PartialEvaluationResult.s_emptyResult;
        }
        StreamInstruction streamsi = (StreamInstruction)streami;
        int index2 = (Integer)((LiteralInstruction)indexi).getValue();
        Type streamType = streamsi.getType(pic.getCurrentTypeEnvironment(), pic.getCurrentBindingEnvironment());
        if (streamsi.isString()) {
            String str = streamsi.getStringContent();
            if (str.length() <= index2) {
                throw new ArrayIndexOutOfBoundsException("index=" + index2 + " str='" + str + "'");
            }
            return new PartialEvaluationResult(LiteralInstruction.charLiteral(str.charAt(index2)));
        }
        for (int i = 0; i <= index2; ++i) {
            Instruction instr = streamsi.getElements()[i];
            Type instrType = instr.getType(pic.getCurrentTypeEnvironment(), pic.getCurrentBindingEnvironment());
            if (streamType.equals(instrType, pic.getCurrentTypeEnvironment())) {
                return PartialEvaluationResult.s_emptyResult;
            }
            if (instrType.getStreamType().equals(streamType)) continue;
            return PartialEvaluationResult.s_emptyResult;
        }
        Instruction ans = streamsi.getElements()[index2];
        return new PartialEvaluationResult(ans);
    }
}

