/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.optimizers.partialeval;

import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.SubstreamInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.LetChainManager;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluationResult;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialEvaluator;
import com.ibm.xltxe.rnm1.xylem.optimizers.partialeval.PartialInformationCollector;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SubstreamEvaluator
extends PartialEvaluator {
    @Override
    public PartialEvaluationResult extractPartialInformation(Instruction x, PartialInformationCollector pic, LetInstruction before2, LetChainManager lcm) {
        Instruction start;
        Instruction source;
        boolean changed = false;
        SubstreamInstruction ssi = (SubstreamInstruction)x;
        boolean sourceKnown = false;
        boolean startKnown = false;
        Instruction len = null;
        boolean lenKnown = false;
        if (ssi.getChildInstructionCount() == 2) {
            source = ssi.getChildInstruction(0);
            start = ssi.getChildInstruction(1);
            lenKnown = true;
        } else {
            source = ssi.getChildInstruction(1);
            start = ssi.getChildInstruction(2);
            len = ssi.getChildInstruction(0);
        }
        int startPosition = 0;
        pic.partiallyEvaluate(start, lcm);
        Integer i = (Integer)SubstreamEvaluator.extractLiteralValue(pic, start, lcm);
        if (i != null) {
            startPosition = i;
            startKnown = true;
        }
        int copyLength = 0;
        if (len != null) {
            pic.partiallyEvaluate(len, lcm);
            i = (Integer)SubstreamEvaluator.extractLiteralValue(pic, len, lcm);
            if (i != null) {
                copyLength = i;
                lenKnown = true;
            }
        }
        pic.partiallyEvaluate(source, lcm);
        Instruction srcTmp = lcm.lookupBinding(source);
        if (srcTmp == null || !(srcTmp instanceof StreamInstruction)) {
            return PartialEvaluationResult.s_emptyResult;
        }
        StreamInstruction src = (StreamInstruction)srcTmp;
        LinkedList values2 = new LinkedList();
        PartialEvaluator.accumulateStream(src, values2, pic, lcm);
        sourceKnown = true;
        Iterator it = values2.iterator();
        while (it.hasNext()) {
            if (it.next() instanceof LiteralInstruction) continue;
            sourceKnown = false;
            break;
        }
        if (sourceKnown && startKnown && lenKnown) {
            return new PartialEvaluationResult(len == null ? this.calculateSubStream(src.getElementType(), values2, startPosition) : this.calculateSubStream(src.getElementType(), values2, startPosition, copyLength));
        }
        return PartialEvaluationResult.s_emptyResult;
    }

    protected Instruction calculateSubStream(Type type2, List values2, int startPos) {
        return this.calculateSubStream(type2, values2, startPos, values2.size() - startPos);
    }

    protected Instruction calculateSubStream(Type type2, List values2, int startPos, int copyLength) {
        return new StreamInstruction(type2, values2.subList(startPos, startPos + copyLength));
    }
}

