/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.parser;

import com.ibm.xltxe.rnm1.xylem.parser.ParserException;
import com.ibm.xltxe.rnm1.xylem.parser.ParserSource;
import com.ibm.xltxe.rnm1.xylem.parser.SourceResolver;
import com.ibm.xltxe.rnm1.xylem.res.XylemMsg;
import com.ibm.xltxe.rnm1.xylem.utils.XylemError;
import com.ibm.xml.ras.FFDCUtil;
import com.ibm.xml.ras.LoggerUtil;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassLoaderSourceResolver
extends SourceResolver {
    protected ClassLoader m_classLoader;
    private static final Logger s_logger = LoggerUtil.getLogger(ClassLoaderSourceResolver.class);
    private static final String s_className = ClassLoaderSourceResolver.class.getName();

    public ClassLoaderSourceResolver() {
        this(null);
    }

    public ClassLoaderSourceResolver(ClassLoader cl) {
        this.m_classLoader = cl == null ? this.getClass().getClassLoader() : cl;
    }

    @Override
    public ParserSource resolve(ParserSource base2, String urlName) throws ParserException {
        URL url;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINER)) {
            s_logger.logp(Level.FINER, s_className, "resolve", "resolving '" + urlName + "' cl=" + this.m_classLoader);
        }
        if (null == this.m_classLoader) {
            url = this.getClass().getResource(urlName);
            if (null == url) {
                url = ClassLoader.getSystemResource(urlName);
            }
        } else {
            url = this.m_classLoader.getResource(urlName);
        }
        if (null == url) {
            String message = XylemMsg.createXylemMessage("ERR_SYSTEM", new Object[]{"Resource not found '" + urlName + "'"});
            XylemError error2 = new XylemError(message);
            FFDCUtil.log(error2, this);
            s_logger.logp(Level.SEVERE, s_className, "resolve", message);
            throw error2;
        }
        return new ParserSource(url);
    }
}

