/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.parser;

import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.IMatchDestructable;
import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.instructions.AbsoluteValueInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.AndInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ApplyInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ArbitraryIntegerPrecisionInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.AssertTypeInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.AssignmentInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.AutomatonInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.BeginInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.BuildLazyStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.BuildMultiStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.CharStreamToJavaStringInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ChooseInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ConstructorInstantiationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.CostCenterInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.DeepEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.DelayInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ForceInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.GetNonNullValueInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.HexEscapeInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IsJavaNullInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IsNullValueInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.JavaArrayLookupInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.JavaDowncastInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.JavaMethodInvocationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LambdaInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LazyStreamElementInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LengthInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LetOnceInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LocalizeMessageInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LoopInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.Match2Instruction;
import com.ibm.xltxe.rnm1.xylem.instructions.MatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ModuleFunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NaNInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NegateInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NewJavaObjectInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NonNullValueInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NotInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.NumericalComparisonInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.OnceInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.OrInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ParallelForEachInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveArithmeticInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveEqualityInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PrimitiveToStringInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ProcessStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.PureInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.RangeInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ReadJavaConstantInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ReadJavaFieldInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.ReadSlotInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.RoundInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.SlotInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.SortStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StaticMemberInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StaticMethodInvocationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamElementInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamRepeatInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.SubstreamAfterInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.SubstreamBeforeInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.SubstreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TagInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TestStreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TryCatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleMatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TypeMatchInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.UnionInjectInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.UntagInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.parser.IFormHandler;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xltxe.rnm1.xylem.parser.ParserException;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.DecimalType;
import com.ibm.xltxe.rnm1.xylem.types.ICollectionType;
import com.ibm.xltxe.rnm1.xylem.types.PrimitiveNumericalType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xml.ras.LoggerUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CoreFormHandler
implements IFormHandler {
    private static final Logger s_logger = LoggerUtil.getLogger(CoreFormHandler.class);
    private static final String s_className = CoreFormHandler.class.getName();
    private static BasicForm[] s_basicForms = new BasicForm[]{new BasicForm("cost-center", 2, CostCenterInstruction.class), new BasicForm("delay", 1, DelayInstruction.class), new BasicForm("force", 1, ForceInstruction.class), new BasicForm("pure", 1, PureInstruction.class), new BasicForm("length", 1, LengthInstruction.class), new BasicForm("once!", 1, OnceInstruction.class), new BasicForm("not", 1, NotInstruction.class), new BasicForm("negate", 1, NegateInstruction.class), new BasicForm("abs", 1, AbsoluteValueInstruction.class), new BasicForm("round", 1, RoundInstruction.class), new BasicForm("range", 2, RangeInstruction.class), new BasicForm("eq?", 2, PrimitiveEqualityInstruction.class), new BasicForm("nan?", 1, NaNInstruction.class), new BasicForm("equals?", 2, DeepEqualityInstruction.class), new BasicForm("hex-escape", 1, HexEscapeInstruction.class), new BasicForm("stream-element", 2, StreamElementInstruction.class), new BasicForm("non-null-value", 1, NonNullValueInstruction.class), new BasicForm("is-null-value", 1, IsNullValueInstruction.class), new BasicForm("is-java-null", 1, IsJavaNullInstruction.class), new BasicForm("get-non-null-value", 1, GetNonNullValueInstruction.class), new BasicForm("arbitrary-integer-precision?", 2, ArbitraryIntegerPrecisionInstruction.class)};
    static long dummyDebugCount = 0L;

    public static int getBasicFormSize() {
        return s_basicForms.length;
    }

    public static Class getBasicFormClass(int i) {
        return CoreFormHandler.s_basicForms[i].m_class;
    }

    public static String getBasicFormName(int i) {
        return CoreFormHandler.s_basicForms[i].m_name;
    }

    @Override
    public Instruction parseForm(String formName, Parser parser, ITypeStore ts) throws ParserException {
        Instruction[] initialValues;
        ArrayList<Object> al;
        boolean wrapResult;
        Object y;
        Instruction body;
        Object type2;
        char ch;
        String field;
        boolean isPure;
        TypeVariable tvar;
        Instruction[] values2;
        Instruction value2;
        int i;
        if (LoggerUtil.isAnyTracingEnabled() && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, s_className, "parseForm", "processing " + formName);
        }
        for (i = 0; i < s_basicForms.length; ++i) {
            BasicForm bf = s_basicForms[i];
            if (!bf.m_name.equals(formName)) continue;
            Class[] classes = new Class[bf.m_parameters];
            Instruction[] params = new Instruction[classes.length];
            for (int j = 0; j < classes.length; ++j) {
                classes[j] = Instruction.class;
                params[j] = parser.parseExpression(ts);
            }
            parser.parseCloseParen();
            try {
                return (Instruction)bf.m_class.getConstructor(classes).newInstance(params);
            }
            catch (Exception e) {
                throw new ParserException("Internal error", e);
            }
        }
        if (formName.equals("let")) {
            Object varName = parser.parseName();
            value2 = parser.parseExpression(ts);
            Instruction body2 = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new LetInstruction(varName, value2, body2);
        }
        if (formName.equals("let!")) {
            Object varName = parser.parseName();
            value2 = parser.parseExpression(ts);
            Instruction body3 = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new LetOnceInstruction(varName, value2, body3);
        }
        if (formName.equals("lazy-stream-element")) {
            Instruction stream2 = parser.parseExpression(ts);
            Instruction index2 = parser.parseExpression(ts);
            Object varName = parser.parseName();
            Instruction body4 = parser.parseExpression(ts);
            Instruction otherwise = parser.parseExpression(ts, false);
            if (otherwise != null) {
                parser.parseCloseParen();
            }
            return new LazyStreamElementInstruction(stream2, index2, varName, body4, otherwise);
        }
        if (formName.equals("let*")) {
            LinkedList<Object> names = new LinkedList<Object>();
            values2 = new LinkedList();
            parser.parseOpenParen();
            while (parser.parseOpenParenOrEnd()) {
                names.add(parser.parseName());
                values2.add(parser.parseExpression(ts));
                parser.parseCloseParen();
            }
            Instruction body5 = parser.parseExpression(ts);
            parser.parseCloseParen();
            Instruction[] params = new Instruction[names.size()];
            Binding[] bindings = new Binding[values2.size()];
            int i2 = 0;
            while (!values2.isEmpty()) {
                params[i2] = (Instruction)values2.removeLast();
                bindings[i2] = new Binding(names.removeLast());
                ++i2;
            }
            return OptimizerUtilities.replaceDeconstructionBindings(params, bindings, body5);
        }
        if (formName.equals("set!")) {
            Instruction var = parser.parseExpression(ts);
            value2 = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new AssignmentInstruction(var, value2);
        }
        if (formName.equals("get!")) {
            Instruction var = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new ReadSlotInstruction(var);
        }
        if (formName.equals("char-stream-to-java-string")) {
            Instruction var = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new CharStreamToJavaStringInstruction(var);
        }
        if (formName.equals("try")) {
            String exceptionClass = parser.parseIdentifier();
            Instruction expr = parser.parseExpression(ts);
            Instruction handler = parser.parseExpression(ts, false);
            if (handler != null) {
                parser.parseCloseParen();
            }
            return new TryCatchInstruction(exceptionClass, expr, handler);
        }
        if (formName.equals("union-inject")) {
            Type type3 = parser.parseTypeName(ts);
            int index3 = Integer.parseInt(parser.parseIdentifier());
            int size = Integer.parseInt(parser.parseIdentifier());
            Instruction expr = parser.parseExpression(ts);
            return new UnionInjectInstruction(type3, index3, size, expr);
        }
        if (formName.equals("stream")) {
            Type type4 = parser.parseTypeName(ts);
            values2 = parser.parseRemainingExpressions(ts);
            return new StreamInstruction(type4, values2);
        }
        if (formName.equals("begin")) {
            Instruction[] values3 = parser.parseRemainingExpressions(ts);
            return new BeginInstruction(values3);
        }
        if (formName.equals("tuple")) {
            Instruction[] values4 = parser.parseRemainingExpressions(ts);
            return new TupleInstruction(values4);
        }
        if (formName.equals("stream-s")) {
            Instruction[] values5 = parser.parseRemainingExpressions(ts);
            tvar = new TypeVariable();
            StreamType st = new StreamType(tvar);
            for (int i3 = 0; i3 < values5.length; ++i3) {
                values5[i3] = new AssertTypeInstruction(values5[i3], st);
                values5[i3].setSourceFilename(parser.getCurrentURL());
                values5[i3].setSourceLineNumber(parser.getLineNumber());
            }
            return new StreamInstruction((Type)tvar, values5);
        }
        if (formName.equals("stream-e")) {
            Instruction[] values6 = parser.parseRemainingExpressions(ts);
            tvar = new TypeVariable();
            for (int i4 = 0; i4 < values6.length; ++i4) {
                values6[i4] = new AssertTypeInstruction(values6[i4], tvar);
                values6[i4].setSourceFilename(parser.getCurrentURL());
                values6[i4].setSourceLineNumber(parser.getLineNumber());
            }
            return new StreamInstruction((Type)tvar, values6);
        }
        if (formName.equals("construct")) {
            String name2 = parser.parseIdentifier();
            values2 = parser.parseRemainingExpressions(ts);
            return new ConstructorInstantiationInstruction(name2, values2);
        }
        if (formName.equals("sort")) {
            List<Instruction> values7 = Arrays.asList(parser.parseRemainingExpressions(ts));
            Instruction src = values7.get(0);
            values7 = values7.subList(1, values7.size());
            Instruction[] keyGenerators = values7.subList(0, values7.size() / 2).toArray(new Instruction[0]);
            Instruction[] comparators = values7.subList(values7.size() / 2, values7.size()).toArray(new Instruction[0]);
            return new SortStreamInstruction(src, keyGenerators, comparators);
        }
        if (formName.equals("call-module-function")) {
            String module = parser.parseIdentifier();
            String name3 = parser.parseIdentifier();
            Instruction[] values8 = parser.parseRemainingExpressions(ts);
            return new ModuleFunctionCallInstruction(module, name3, values8);
        }
        if (formName.equals("localize-message")) {
            Instruction msgfile = parser.parseExpression(ts);
            Instruction msgid = parser.parseExpression(ts);
            Instruction[] values9 = parser.parseRemainingExpressions(ts);
            return new LocalizeMessageInstruction(msgfile, msgid, values9);
        }
        if (formName.equals("apply") || formName.equals("apply!")) {
            isPure = formName.equals("apply");
            Instruction fn2 = parser.parseExpression(ts);
            Instruction[] values10 = parser.parseRemainingExpressions(ts);
            return new ApplyInstruction(fn2, values10, isPure);
        }
        if (formName.equals("lookup-java-array")) {
            Instruction fn3 = parser.parseExpression(ts);
            values2 = parser.parseRemainingExpressions(ts);
            return new JavaArrayLookupInstruction(fn3, values2);
        }
        if (formName.equals("new-java-object")) {
            Type type5 = parser.parseTypeName(ts);
            values2 = parser.parseRemainingExpressions(ts);
            return new NewJavaObjectInstruction(values2, type5);
        }
        if (formName.equals("java-downcast")) {
            Type type6 = parser.parseTypeName(ts);
            Instruction obj = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new JavaDowncastInstruction(obj, type6);
        }
        if (formName.equals("read-java-field")) {
            Instruction obj = parser.parseExpression(ts);
            field = parser.parseIdentifier();
            parser.parseCloseParen();
            return new ReadJavaFieldInstruction(obj, field);
        }
        if (formName.equals("read-java-constant")) {
            Instruction obj = parser.parseExpression(ts);
            field = parser.parseIdentifier();
            parser.parseCloseParen();
            return new ReadJavaConstantInstruction(obj, field);
        }
        if (formName.equals("java-method-invoke") || formName.equals("static-method-invoke")) {
            ch = parser.read();
            type2 = null;
            if (ch == '@') {
                type2 = parser.parseTypeName(ts);
            } else {
                parser.unread(ch);
            }
            Instruction obj = null;
            if (formName.equals("java-method-invoke")) {
                obj = parser.parseExpression(ts);
            }
            String method = parser.parseIdentifier();
            Instruction[] values11 = parser.parseRemainingExpressions(ts);
            if (formName.equals("java-method-invoke")) {
                return new JavaMethodInvocationInstruction(method, obj, values11, (Type)type2);
            }
            return new StaticMethodInvocationInstruction(method, values11, (Type)type2);
        }
        if (formName.equals("java-static-field-ref")) {
            ch = parser.read();
            type2 = null;
            if (ch == '@') {
                type2 = parser.parseTypeName(ts);
            } else {
                parser.unread(ch);
            }
            while (Character.isWhitespace(ch = parser.readStripComments())) {
            }
            String clazz = parser.parseStringLiteral();
            while (Character.isWhitespace(ch = parser.readStripComments())) {
            }
            String member = parser.parseStringLiteral();
            parser.parseCloseParen();
            return new StaticMemberInstruction(clazz, member, (Type)type2);
        }
        if (formName.equals("and")) {
            Instruction[] values12 = parser.parseRemainingExpressions(ts);
            return new AndInstruction(values12);
        }
        if (formName.equals("or")) {
            Instruction[] values13 = parser.parseRemainingExpressions(ts);
            return new OrInstruction(values13);
        }
        if (formName.equals("assert-type")) {
            Type type7 = parser.parseTypeName(ts);
            body = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new AssertTypeInstruction(body, type7);
        }
        if (formName.equals("primitive-cast")) {
            Type type8 = parser.parseTypeName(ts);
            body = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new JavaDowncastInstruction(body, type8);
        }
        if (formName.equals("java-null")) {
            Type type9 = parser.parseTypeName(ts);
            parser.parseCloseParen();
            return LiteralInstruction.nullLiteral(type9);
        }
        if (formName.equals("stream-repeat")) {
            Instruction x = parser.parseExpression(ts);
            y = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new StreamRepeatInstruction(x, (Instruction)y);
        }
        if (formName.equals("stream-repeat-stream")) {
            Instruction x = parser.parseExpression(ts);
            y = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new StreamRepeatInstruction(x, (Instruction)y);
        }
        if (formName.equals("slot!")) {
            Instruction value3 = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new SlotInstruction(value3);
        }
        if (formName.equals("tag")) {
            String name4 = parser.parseIdentifier();
            value2 = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new TagInstruction(name4, value2);
        }
        if (formName.equals("untag")) {
            String name5 = parser.parseIdentifier();
            value2 = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new UntagInstruction(name5, value2);
        }
        if (formName.equals("foreach") || formName.equals("foreach-c")) {
            Object varName = parser.parseName();
            type2 = null;
            if (varName.equals("@")) {
                type2 = (ICollectionType)((Object)parser.parseTypeName(ts));
                varName = parser.parseName();
            }
            Instruction source = parser.parseExpression(ts);
            Object loopindexvar = null;
            if (formName.equals("foreach-c")) {
                loopindexvar = parser.parseName();
            }
            Instruction body6 = parser.parseExpression(ts);
            parser.parseCloseParen();
            return type2 == null ? new ForEachInstruction(source, varName, loopindexvar, body6) : new ForEachInstruction(source, varName, loopindexvar, body6, (ICollectionType)type2);
        }
        if (formName.equals("parallel-foreach")) {
            LinkedList<Object> vars = new LinkedList<Object>();
            LinkedList<Instruction> sources = new LinkedList<Instruction>();
            Type bodyADTType = null;
            char ch2 = parser.read();
            if (ch2 == '@') {
                bodyADTType = parser.parseTypeName(ts);
            } else {
                parser.unread(ch2);
            }
            parser.parseOpenParen();
            while (parser.parseOpenParenOrEnd()) {
                vars.add(parser.parseName());
                sources.add(parser.parseExpression(ts));
                parser.parseCloseParen();
            }
            Instruction body7 = parser.parseExpression(ts);
            parser.parseCloseParen();
            Instruction[] params = sources.toArray(new Instruction[0]);
            Object[] varNames = vars.toArray(new Object[0]);
            ParallelForEachInstruction pfei = new ParallelForEachInstruction(params, varNames, body7, bodyADTType);
            return pfei;
        }
        if (formName.equals("big-integer")) {
            String x = parser.parseIdentifier();
            parser.parseCloseParen();
            return new LiteralInstruction(BigIntegerType.s_bigIntegerType, new BigInteger(x));
        }
        if (formName.equals("big-decimal")) {
            String x = parser.parseIdentifier();
            parser.parseCloseParen();
            return new LiteralInstruction(DecimalType.s_decimalType, new BigDecimal(x));
        }
        if (formName.equals("substream-after")) {
            Instruction x = parser.parseExpression(ts);
            y = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new SubstreamAfterInstruction(x, (Instruction)y);
        }
        if (formName.equals("substream")) {
            Instruction x = parser.parseExpression(ts);
            y = parser.parseExpression(ts);
            Instruction z = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new SubstreamInstruction(x, (Instruction)y, z, true);
        }
        if (formName.equals("substream-1")) {
            Instruction x = parser.parseExpression(ts);
            y = parser.parseExpression(ts);
            Instruction z = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new SubstreamInstruction(x, (Instruction)y, z, false);
        }
        if (formName.equals("substream-before")) {
            Instruction x = parser.parseExpression(ts);
            y = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new SubstreamBeforeInstruction(x, (Instruction)y);
        }
        if (formName.equals("primitive-to-string")) {
            Instruction x = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new PrimitiveToStringInstruction(x);
        }
        if (formName.equals("process-stream") || formName.equals("process-stream-c") || formName.equals("process-stream-i") || formName.equals("process-stream-ic") || formName.equals("test-stream") || formName.equals("test-stream-c")) {
            wrapResult = formName.startsWith("process-stream-i");
            boolean testStream = formName.startsWith("test-stream");
            boolean counted = formName.charAt(formName.length() - 1) == 'c';
            Type typeObj = null;
            Instruction source = parser.parseExpression(ts);
            if (source instanceof IdentifierInstruction && ((IdentifierInstruction)source).getVariable().equals("@")) {
                typeObj = parser.parseTypeName(ts);
                source = parser.parseExpression(ts);
            }
            Instruction hint = parser.parseExpression(ts);
            Object elementVar = parser.parseName();
            Object hintVar = parser.parseName();
            Object indexVar = null;
            if (counted) {
                indexVar = parser.parseName();
            }
            Instruction body8 = parser.parseExpression(ts);
            parser.parseCloseParen();
            if (testStream) {
                if (typeObj == null) {
                    return new TestStreamInstruction(source, hint, elementVar, hintVar, indexVar, body8);
                }
                try {
                    return new TestStreamInstruction(source, hint, elementVar, hintVar, indexVar, body8, (ICollectionType)((Object)typeObj));
                }
                catch (ClassCastException cce) {
                    throw new ParserException(typeObj.getClass().getSimpleName() + " is not a ICollectionType!: " + typeObj, parser.getCurrentURL(), parser.getLineNumber(), parser.getOffsetInLine());
                }
            }
            return new ProcessStreamInstruction(wrapResult, source, hint, elementVar, hintVar, indexVar, body8, typeObj);
        }
        if (formName.equals("choose")) {
            ArrayList<ChooseInstruction.Case> al2 = new ArrayList<ChooseInstruction.Case>();
            Instruction defaultHandler = null;
            while (parser.parseOpenParenOrEnd()) {
                String token = parser.parseIdentifier();
                if (token.equals("otherwise")) {
                    defaultHandler = parser.parseExpression(ts);
                    parser.parseCloseParen();
                    parser.parseCloseParen();
                    break;
                }
                if (token.equals("when")) {
                    Instruction condition = parser.parseExpression(ts);
                    Instruction handler = parser.parseExpression(ts);
                    parser.parseCloseParen();
                    al2.add(new ChooseInstruction.Case(condition, handler));
                    continue;
                }
                throw new ParserException("Unexpected token: " + token, parser.getCurrentURL(), parser.getLineNumber(), parser.getOffsetInLine());
            }
            ChooseInstruction.Case[] cases = new ChooseInstruction.Case[al2.size()];
            al2.toArray(cases);
            return new ChooseInstruction(cases, defaultHandler);
        }
        if (formName.equals("match")) {
            Instruction toMatch = parser.parseExpression(ts);
            al = new ArrayList<Object>();
            Instruction defaultHandler = null;
            while (parser.parseOpenParenOrEnd()) {
                String token = parser.parseIdentifier();
                if (token.equals("else") || token.equals("otherwise")) {
                    defaultHandler = parser.parseExpression(ts);
                    parser.parseCloseParen();
                    parser.parseCloseParen();
                    break;
                }
                if (token.equals("case")) {
                    Instruction n2;
                    int i5;
                    Object[] bindings;
                    Instruction condition = parser.parseExpression(ts);
                    Instruction handler = parser.parseExpression(ts);
                    parser.parseCloseParen();
                    if (condition instanceof LiteralInstruction) {
                        al.add(new MatchInstruction.LiteralMatch((LiteralInstruction)condition, handler));
                        continue;
                    }
                    if (condition instanceof FunctionCallInstruction) {
                        FunctionCallInstruction cii = (FunctionCallInstruction)condition;
                        bindings = new Object[cii.m_parameters.length];
                        for (i5 = 0; i5 < bindings.length; ++i5) {
                            n2 = cii.m_parameters[i5];
                            if (!(n2 instanceof IdentifierInstruction)) {
                                throw new ParserException("Constructor match can only contain identifiers", parser.getCurrentURL(), parser.getLineNumber(), parser.getOffsetInLine());
                            }
                            bindings[i5] = ((IdentifierInstruction)n2).getVariable();
                        }
                        al.add(new MatchInstruction.DeconstructionMatch(cii.getFunction(), bindings, handler));
                        continue;
                    }
                    if (condition instanceof TupleInstruction) {
                        if (!al.isEmpty()) {
                            throw new ParserException("Cannot mix tuple case with other cases in match", parser.getCurrentURL(), parser.getLineNumber());
                        }
                        TupleInstruction ti = (TupleInstruction)condition;
                        bindings = new Object[ti.m_parameters.length];
                        for (i5 = 0; i5 < bindings.length; ++i5) {
                            n2 = ti.m_parameters[i5];
                            if (!(n2 instanceof IdentifierInstruction)) {
                                throw new ParserException("Tuple match can only contain identifiers", parser.getCurrentURL(), parser.getLineNumber());
                            }
                            bindings[i5] = ((IdentifierInstruction)n2).getVariable();
                        }
                        parser.parseCloseParen();
                        return new TupleMatchInstruction(toMatch, bindings, handler);
                    }
                    throw new ParserException("Unexpected condition " + condition, parser.getCurrentURL(), parser.getLineNumber());
                }
                throw new ParserException("Unexpected token: " + token, parser.getCurrentURL(), parser.getLineNumber());
            }
            MatchInstruction.Match[] matches2 = new MatchInstruction.Match[al.size()];
            al.toArray(matches2);
            return new MatchInstruction(toMatch, matches2, defaultHandler);
        }
        if (formName.equals("match2")) {
            Instruction toMatch = parser.parseExpression(ts);
            al = new ArrayList();
            Instruction defaultHandler = null;
            while (parser.parseOpenParenOrEnd()) {
                String token = parser.parseIdentifier();
                if (token.equals("else") || token.equals("otherwise")) {
                    defaultHandler = parser.parseExpression(ts);
                    parser.parseCloseParen();
                    parser.parseCloseParen();
                    break;
                }
                if (token.equals("case")) {
                    Instruction condition = parser.parseExpression(ts);
                    if (!(condition instanceof IMatchDestructable)) {
                        throw new ParserException("Invalid pattern in match2", parser.getCurrentURL(), parser.getLineNumber());
                    }
                    Instruction handler = parser.parseExpression(ts);
                    parser.parseCloseParen();
                    al.add(new Match2Instruction.Match(condition, handler));
                    continue;
                }
                throw new ParserException("Unexpected token: " + token, parser.getCurrentURL(), parser.getLineNumber());
            }
            Match2Instruction.Match[] matches3 = new Match2Instruction.Match[al.size()];
            al.toArray(matches3);
            return new Match2Instruction(toMatch, matches3, defaultHandler);
        }
        if (formName.equals("type-match")) {
            Instruction toMatch = parser.parseExpression(ts);
            al = new ArrayList();
            Instruction defaultHandler = null;
            while (parser.parseOpenParenOrEnd()) {
                String token = parser.parseIdentifier();
                if (token.equals("else") || token.equals("otherwise")) {
                    defaultHandler = parser.parseExpression(ts);
                    parser.parseCloseParen();
                    parser.parseCloseParen();
                    break;
                }
                if (token.equals("case")) {
                    Type type10 = parser.parseTypeName(ts);
                    Object binding = parser.parseName();
                    Instruction handler = parser.parseExpression(ts);
                    parser.parseCloseParen();
                    al.add(new TypeMatchInstruction.Match(type10, binding, handler));
                    continue;
                }
                throw new ParserException("Unexpected token: " + token, parser.getCurrentURL(), parser.getLineNumber());
            }
            TypeMatchInstruction.Match[] matches4 = new TypeMatchInstruction.Match[al.size()];
            al.toArray(matches4);
            return new TypeMatchInstruction(toMatch, matches4, defaultHandler);
        }
        if (formName.equals("tuple-match")) {
            Instruction toMatch = parser.parseExpression(ts);
            parser.parseOpenParen();
            Object[] vars = parser.parseRemainingIdentifiersNames();
            parser.parseCloseParen();
            Instruction body9 = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new TupleMatchInstruction(toMatch, vars, body9);
        }
        if (formName.equals("build-lazy-stream")) {
            parser.parseOpenParen();
            Object[] vars = parser.parseRemainingIdentifiers();
            parser.parseCloseParen();
            initialValues = new Instruction[vars.length];
            for (int i6 = 0; i6 < vars.length; ++i6) {
                initialValues[i6] = parser.parseExpression(ts);
            }
            Instruction body10 = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new BuildLazyStreamInstruction(initialValues, vars, body10);
        }
        if (formName.equals("build-multi-stream")) {
            parser.parseOpenParen();
            Object[] vars = parser.parseRemainingIdentifiers();
            parser.parseCloseParen();
            initialValues = new Instruction[vars.length];
            for (int i7 = 0; i7 < vars.length; ++i7) {
                initialValues[i7] = parser.parseExpression(ts);
            }
            Instruction body11 = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new BuildMultiStreamInstruction(initialValues, vars, body11);
        }
        if (formName.equals("lambda") || formName.equals("lambda!")) {
            Object x;
            isPure = formName.equals("lambda");
            parser.parseOpenParen();
            ArrayList<Binding> list = new ArrayList<Binding>();
            while ((x = parser.parseName(false)) != null) {
                Binding b = new Binding(x);
                char ch3 = parser.readStripComments();
                if (ch3 != '@') {
                    parser.unread(ch3);
                } else {
                    b.setType(parser.parseTypeName(ts));
                }
                list.add(b);
            }
            parser.parseCloseParen();
            Binding[] bindings = new Binding[list.size()];
            list.toArray(bindings);
            Instruction body12 = parser.parseExpression(ts);
            parser.parseCloseParen();
            return new LambdaInstruction(body12, bindings, isPure);
        }
        if (formName.equals("loop") || formName.equals("loop!")) {
            isPure = formName.equals("loop");
            y = parser.parseName(true);
            LinkedList<Object> names = new LinkedList<Object>();
            LinkedList<Instruction> values14 = new LinkedList<Instruction>();
            parser.parseOpenParen();
            while (parser.parseOpenParenOrEnd()) {
                names.add(parser.parseName());
                values14.add(parser.parseExpression(ts));
                parser.parseCloseParen();
            }
            Instruction body13 = parser.parseExpression(ts);
            parser.parseCloseParen();
            Instruction[] params = new Instruction[names.size()];
            Binding[] bindings = new Binding[values14.size()];
            int i8 = 0;
            while (!values14.isEmpty()) {
                params[i8] = (Instruction)values14.removeFirst();
                bindings[i8] = new Binding(names.removeFirst());
                ++i8;
            }
            return new LoopInstruction(y, body13, bindings, params, isPure);
        }
        if (formName.equals("automaton") || formName.equals("automaton-i") || formName.equals("automaton-c") || formName.equals("automaton-ic")) {
            wrapResult = formName.equals("automaton-i");
            Instruction source = parser.parseExpression(ts);
            ICollectionType type11 = null;
            if (source instanceof IdentifierInstruction && ((IdentifierInstruction)source).getVariable().equals("@")) {
                type11 = (ICollectionType)((Object)parser.parseTypeName(ts));
                source = parser.parseExpression(ts);
            }
            Instruction initialState = parser.parseExpression(ts);
            Type adt = parser.parseTypeName(ts);
            Object loopIndexVar = null;
            if (formName.equals("automaton-c") || formName.equals("automaton-ic")) {
                loopIndexVar = parser.parseName();
            }
            ArrayList<AutomatonInstruction.Match> al3 = new ArrayList<AutomatonInstruction.Match>();
            Instruction defaultHandler = null;
            Object defaultState = null;
            Object defaultElement = null;
            while (parser.parseOpenParenOrEnd()) {
                String token = parser.parseIdentifier();
                if (token.equals("else") || token.equals("otherwise")) {
                    defaultState = parser.parseName();
                    defaultElement = parser.parseName();
                    defaultHandler = parser.parseExpression(ts);
                    parser.parseCloseParen();
                    parser.parseCloseParen();
                    break;
                }
                if (token.equals("state")) {
                    int state = parser.parseInteger();
                    Instruction condition = parser.parseExpression(ts);
                    Instruction handler = parser.parseExpression(ts);
                    Instruction nextState = parser.parseExpression(ts);
                    parser.parseCloseParen();
                    if (condition instanceof LiteralInstruction) {
                        al3.add(new AutomatonInstruction.LiteralMatch(state, (LiteralInstruction)condition, handler, nextState));
                        continue;
                    }
                    if (condition instanceof FunctionCallInstruction) {
                        FunctionCallInstruction cii = (FunctionCallInstruction)condition;
                        AutomatonInstruction.BindingOrLiteral[] bindings = new AutomatonInstruction.BindingOrLiteral[cii.m_parameters.length];
                        for (int i9 = 0; i9 < bindings.length; ++i9) {
                            Instruction instr = cii.m_parameters[i9];
                            if (instr instanceof IdentifierInstruction) {
                                bindings[i9] = new AutomatonInstruction.BindingOrLiteral(((IdentifierInstruction)instr).getVariable());
                                continue;
                            }
                            if (instr instanceof LiteralInstruction) {
                                bindings[i9] = new AutomatonInstruction.BindingOrLiteral((LiteralInstruction)instr);
                                continue;
                            }
                            if (instr instanceof StreamInstruction) {
                                StreamInstruction streamInstr = (StreamInstruction)instr;
                                int numChildren = streamInstr.getChildInstructionCount();
                                LiteralInstruction[] instrs = new LiteralInstruction[numChildren];
                                for (int j = 0; j < numChildren; ++j) {
                                    Instruction childInstr = streamInstr.getChildInstruction(j);
                                    if (!(childInstr instanceof LiteralInstruction)) {
                                        throw new ParserException("Illegal non-literal part of stream (" + childInstr + ") in constructor match");
                                    }
                                    instrs[j] = (LiteralInstruction)childInstr;
                                }
                                bindings[i9] = new AutomatonInstruction.BindingOrLiteral(instrs);
                                continue;
                            }
                            throw new ParserException("Illegal expression (" + instr.getClass() + ") in constructor match");
                        }
                        al3.add(new AutomatonInstruction.DeconstructionMatch(state, cii.getFunction(), bindings, handler, nextState));
                        continue;
                    }
                    if (condition instanceof IdentifierInstruction) {
                        al3.add(new AutomatonInstruction.LiteralWildcardMatch(state, ((IdentifierInstruction)condition).getVariable(), handler, nextState));
                        continue;
                    }
                    throw new ParserException("Unexpected condition " + condition);
                }
                throw new ParserException("Unexpected token: " + token, parser.getCurrentURL(), parser.getLineNumber());
            }
            AutomatonInstruction.Match[] matches5 = new AutomatonInstruction.Match[al3.size()];
            al3.toArray(matches5);
            return type11 == null ? new AutomatonInstruction(source, initialState, matches5, defaultHandler, adt, defaultState, defaultElement, loopIndexVar, wrapResult) : new AutomatonInstruction(source, initialState, matches5, defaultHandler, adt, defaultState, defaultElement, loopIndexVar, wrapResult, type11);
        }
        for (i = 0; i < PrimitiveNumericalType.getOperatorSize(); ++i) {
            String s = PrimitiveNumericalType.getOperator(i);
            if (!s.equals(formName)) continue;
            Instruction x = parser.parseExpression(ts);
            Instruction y2 = parser.parseExpression(ts);
            parser.parseCloseParen();
            return PrimitiveNumericalType.isComparisonOperator(i) ? new NumericalComparisonInstruction(x, y2, i) : new PrimitiveArithmeticInstruction(x, y2, i);
        }
        return null;
    }

    @Override
    public void registerForms(Parser parser) {
        int i;
        parser.registerForm("let", this);
        parser.registerForm("let!", this);
        parser.registerForm("set!", this);
        parser.registerForm("get!", this);
        parser.registerForm("slot!", this);
        parser.registerForm("begin", this);
        parser.registerForm("stream", this);
        parser.registerForm("stream-s", this);
        parser.registerForm("stream-e", this);
        parser.registerForm("assert-type", this);
        parser.registerForm("primitive-cast", this);
        parser.registerForm("stream-element", this);
        parser.registerForm("stream-repeat", this);
        parser.registerForm("foreach", this);
        parser.registerForm("foreach-c", this);
        parser.registerForm("parallel-foreach", this);
        parser.registerForm("automaton", this);
        parser.registerForm("automaton-i", this);
        parser.registerForm("automaton-c", this);
        parser.registerForm("automaton-ic", this);
        parser.registerForm("construct", this);
        parser.registerForm("call-module-function", this);
        parser.registerForm("primitive-to-string", this);
        parser.registerForm("choose", this);
        parser.registerForm("match", this);
        parser.registerForm("match2", this);
        parser.registerForm("substream-after", this);
        parser.registerForm("substream-before", this);
        parser.registerForm("and", this);
        parser.registerForm("or", this);
        parser.registerForm("tuple", this);
        parser.registerForm("tuple-match", this);
        parser.registerForm("process-stream", this);
        parser.registerForm("process-stream-i", this);
        parser.registerForm("process-stream-c", this);
        parser.registerForm("process-stream-ic", this);
        parser.registerForm("type-match", this);
        parser.registerForm("let*", this);
        parser.registerForm("substream", this);
        parser.registerForm("substream-1", this);
        parser.registerForm("build-multi-stream", this);
        parser.registerForm("build-lazy-stream", this);
        parser.registerForm("lazy-stream-element", this);
        parser.registerForm("loop", this);
        parser.registerForm("lambda", this);
        parser.registerForm("apply", this);
        parser.registerForm("test-stream", this);
        parser.registerForm("test-stream-c", this);
        parser.registerForm("localize-message", this);
        parser.registerForm("char-stream-to-java-string", this);
        parser.registerForm("big-integer", this);
        parser.registerForm("big-decimal", this);
        parser.registerForm("static-method-invoke", this);
        parser.registerForm("java-method-invoke", this);
        parser.registerForm("java-static-field-ref", this);
        parser.registerForm("new-java-object", this);
        parser.registerForm("java-null", this);
        parser.registerForm("java-downcast", this);
        parser.registerForm("read-java-field", this);
        parser.registerForm("read-java-constant", this);
        parser.registerForm("lookup-java-array", this);
        parser.registerForm("sort", this);
        parser.registerForm("try", this);
        parser.registerForm("tag", this);
        parser.registerForm("untag", this);
        parser.registerForm("union-inject", this);
        for (i = 0; i < PrimitiveNumericalType.getOperatorSize(); ++i) {
            parser.registerForm(PrimitiveNumericalType.getOperator(i), this);
        }
        for (i = 0; i < s_basicForms.length; ++i) {
            parser.registerForm(CoreFormHandler.s_basicForms[i].m_name, this);
        }
    }

    public static class BasicForm {
        public String m_name;
        public int m_parameters;
        public Class m_class;

        BasicForm(String name2, int parameters, Class klass) {
            this.m_name = name2;
            this.m_parameters = parameters;
            this.m_class = klass;
        }
    }
}

