/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.parser;

import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.parser.ITypeHandler;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xltxe.rnm1.xylem.parser.ParserException;
import com.ibm.xltxe.rnm1.xylem.types.BigIntegerType;
import com.ibm.xltxe.rnm1.xylem.types.BooleanType;
import com.ibm.xltxe.rnm1.xylem.types.ByteType;
import com.ibm.xltxe.rnm1.xylem.types.CharType;
import com.ibm.xltxe.rnm1.xylem.types.DecimalType;
import com.ibm.xltxe.rnm1.xylem.types.DoubleType;
import com.ibm.xltxe.rnm1.xylem.types.FloatType;
import com.ibm.xltxe.rnm1.xylem.types.IntType;
import com.ibm.xltxe.rnm1.xylem.types.IntegerType;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.LongType;
import com.ibm.xltxe.rnm1.xylem.types.ShortType;
import com.ibm.xltxe.rnm1.xylem.types.UnitType;

public class CoreTypeHandler
implements ITypeHandler {
    @Override
    public Type parseType(String typeName, Parser parser) throws ParserException {
        if (typeName.equals("int")) {
            return IntType.s_intType;
        }
        if (typeName.equals("integer")) {
            return IntegerType.s_integerType;
        }
        if (typeName.equals("unit")) {
            return UnitType.s_unitType;
        }
        if (typeName.equals("char")) {
            return CharType.s_charType;
        }
        if (typeName.equals("byte")) {
            return ByteType.s_byteType;
        }
        if (typeName.equals("short")) {
            return ShortType.s_shortType;
        }
        if (typeName.equals("double")) {
            return DoubleType.s_doubleType;
        }
        if (typeName.equals("float")) {
            return FloatType.s_floatType;
        }
        if (typeName.equals("long")) {
            return LongType.s_longType;
        }
        if (typeName.equals("BigDecimal") || typeName.equals("Decimal") || typeName.equals("java.math.BigDecimal")) {
            return DecimalType.s_decimalType;
        }
        if (typeName.equals("BigInteger") || typeName.equals("java.math.BigInteger")) {
            return BigIntegerType.s_bigIntegerType;
        }
        if (typeName.equals("String") || typeName.equals("java.lang.String")) {
            return JavaObjectType.s_javaStringType;
        }
        if (typeName.equals("boolean")) {
            return BooleanType.s_booleanType;
        }
        return null;
    }

    @Override
    public void registerTypes(Parser parser) {
        parser.registerType("int", this);
        parser.registerType("integer", this);
        parser.registerType("unit", this);
        parser.registerType("char", this);
        parser.registerType("byte", this);
        parser.registerType("double", this);
        parser.registerType("boolean", this);
        parser.registerType("BigDecimal", this);
        parser.registerType("Decimal", this);
        parser.registerType("java.math.BigDecimal", this);
        parser.registerType("BigInteger", this);
        parser.registerType("java.math.BigInteger", this);
        parser.registerType("String", this);
        parser.registerType("java.lang.String", this);
        parser.registerType("float", this);
        parser.registerType("short", this);
        parser.registerType("long", this);
    }
}

