/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.parser;

import com.ibm.xltxe.rnm1.xylem.AbstractTypeStore;
import com.ibm.xltxe.rnm1.xylem.Binding;
import com.ibm.xltxe.rnm1.xylem.Function;
import com.ibm.xltxe.rnm1.xylem.FunctionSignature;
import com.ibm.xltxe.rnm1.xylem.Functor;
import com.ibm.xltxe.rnm1.xylem.FunctorApplicationDirective;
import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.Instruction;
import com.ibm.xltxe.rnm1.xylem.Module;
import com.ibm.xltxe.rnm1.xylem.ModuleSignature;
import com.ibm.xltxe.rnm1.xylem.ModuleSignatureStore;
import com.ibm.xltxe.rnm1.xylem.Program;
import com.ibm.xltxe.rnm1.xylem.TopLevelModuleImportDirective;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.TypeCheckException;
import com.ibm.xltxe.rnm1.xylem.TypeEnvironment;
import com.ibm.xltxe.rnm1.xylem.instructions.FunctionCallInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.IdentifierInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.LiteralInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StaticMethodInvocationInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.StreamInstruction;
import com.ibm.xltxe.rnm1.xylem.instructions.TupleInstruction;
import com.ibm.xltxe.rnm1.xylem.optimizers.OptimizerUtilities;
import com.ibm.xltxe.rnm1.xylem.parser.CoreFormHandler;
import com.ibm.xltxe.rnm1.xylem.parser.CoreTypeHandler;
import com.ibm.xltxe.rnm1.xylem.parser.IFormHandler;
import com.ibm.xltxe.rnm1.xylem.parser.ITypeHandler;
import com.ibm.xltxe.rnm1.xylem.parser.IXMLTypeParser;
import com.ibm.xltxe.rnm1.xylem.parser.ParserException;
import com.ibm.xltxe.rnm1.xylem.parser.ParserSource;
import com.ibm.xltxe.rnm1.xylem.parser.SourceResolver;
import com.ibm.xltxe.rnm1.xylem.parser.TypeParser;
import com.ibm.xltxe.rnm1.xylem.types.AbstractDataType;
import com.ibm.xltxe.rnm1.xylem.types.ConstructorDataType;
import com.ibm.xltxe.rnm1.xylem.types.VirtualDataTypeMap;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class Parser {
    protected HashMap m_formHandlers = new HashMap();
    protected HashMap m_typeHandlers = new HashMap();
    protected IXMLTypeParser m_xmlTypeParser = null;
    protected URL m_baseURL = null;
    protected ArrayList m_typeFixups = new ArrayList();
    protected TypeParser typeParser = new TypeParser(this);
    protected ArrayList m_parsedLibrary = new ArrayList();
    protected ModuleSignatureStore m_knownModuleSignatures;
    protected HashMap m_typeVariables;
    protected HashMap m_importedJavaStaticMethods = new HashMap();
    protected ParserSource m_currentSource;
    protected ArrayList m_sourceStack = new ArrayList();
    protected SourceResolver m_sourceResolver;
    public static final boolean REQUIRED = true;
    static final String s_hextable = "0123456789abcdef";

    public Parser(SourceResolver sr, ParserSource ps) {
        this(sr, ps, new ModuleSignatureStore(new LinkedList<URL>()));
    }

    public Parser(SourceResolver sr, ParserSource ps, ModuleSignatureStore mss) {
        this.m_knownModuleSignatures = mss;
        new CoreFormHandler().registerForms(this);
        new CoreTypeHandler().registerTypes(this);
        this.m_currentSource = ps;
        this.m_sourceResolver = sr;
        if (ps != null) {
            this.m_baseURL = ps.m_currentURL;
        }
    }

    public void reset(String s) {
        this.m_currentSource = new ParserSource(new StringReader(s));
    }

    public void registerForm(String formName, IFormHandler fh) {
        this.m_formHandlers.put(formName, fh);
    }

    public void registerModuleSignature(String name2, ModuleSignature ms) {
        this.m_knownModuleSignatures.registerModuleSignature(name2, ms);
    }

    public void registerType(String typeName, ITypeHandler th) {
        this.m_typeHandlers.put(typeName, th);
    }

    public void registerXMLTypeParser(IXMLTypeParser xmlTypeParser) {
        this.m_xmlTypeParser = xmlTypeParser;
    }

    public IXMLTypeParser getXMLTypeParser() {
        return this.m_xmlTypeParser;
    }

    public void unread(char ch) throws ParserException {
        this.m_currentSource.unread(ch);
    }

    protected char read() throws ParserException {
        char ch = this.m_currentSource.read(false);
        return ch;
    }

    protected char read(boolean noErrorAtEnd) throws ParserException {
        char ch = this.m_currentSource.read(noErrorAtEnd);
        return ch;
    }

    public char readStripComments(boolean noErrorAtEnd) throws ParserException {
        char n2 = this.read(noErrorAtEnd);
        if (n2 == ';') {
            while ((n2 = this.read(noErrorAtEnd)) != '\n') {
            }
        }
        return n2;
    }

    public char readStripComments() throws ParserException {
        return this.readStripComments(false);
    }

    public int getOffsetInLine() {
        return this.m_currentSource.m_offset;
    }

    public int getLineNumber() {
        return this.m_currentSource.m_lineNumber;
    }

    public URL getCurrentURL() {
        return this.m_currentSource.m_currentURL;
    }

    public void parseOpenParen() throws ParserException {
        char ch;
        while (Character.isWhitespace(ch = this.readStripComments())) {
        }
        if (ch != '(') {
            throw new ParserException("Expected ( but found " + ch, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
    }

    public boolean parseOpenParenOrEnd() throws ParserException {
        char ch;
        while (Character.isWhitespace(ch = this.readStripComments())) {
        }
        if (ch != '(') {
            if (ch == ')') {
                return false;
            }
            throw new ParserException("Expected ( or ) but found " + ch, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        return true;
    }

    public String parseFormProlog() throws ParserException {
        this.parseOpenParen();
        String identifier = this.parseIdentifier(true);
        return identifier;
    }

    public String parseFormPrologOrEnd() throws ParserException {
        if (!this.parseOpenParenOrEnd()) {
            return null;
        }
        return this.parseIdentifier(true);
    }

    public void parseCloseParen() throws ParserException {
        char ch;
        while (Character.isWhitespace(ch = this.readStripComments())) {
        }
        if (ch != ')') {
            throw new ParserException("Expected ) but found " + ch, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
    }

    public Instruction parseForm(ITypeStore ts) throws ParserException {
        String formProlog = this.parseFormProlog();
        if (formProlog != null && !this.hasNonGeneralTypeAnnotationHandling(formProlog)) {
            char ch = this.readStripComments();
            Type instructionType = null;
            if (ch == '@') {
                instructionType = this.typeParser.parseTypeName(ts);
            } else {
                this.unread(ch);
            }
        }
        Instruction formInstruction = this.parseForm(formProlog, ts);
        return formInstruction;
    }

    private boolean hasNonGeneralTypeAnnotationHandling(String formProlog) {
        return formProlog.equals("function") || formProlog.equals("coerce") || formProlog.equals("terminate") || formProlog.equals("get-runtime-property") || formProlog.equals("static-method-invoke") || formProlog.equals("java-method-invoke") || formProlog.equals("java-static-field-ref") || formProlog.equals("foreach") || formProlog.equals("foreach-c") || formProlog.equals("parallel-foreach") || formProlog.startsWith("process-stream") || formProlog.startsWith("test-stream") || formProlog.startsWith("process-XDMSequence") || formProlog.startsWith("process-XDMSequence-i") || formProlog.startsWith("process-XDMSequence-stream") || formProlog.startsWith("process-XDMSequence-stream-i") || formProlog.startsWith("process-stream-XDMSequence") || formProlog.startsWith("process-stream-XDMSequence-i") || formProlog.startsWith("test-XDMSequence");
    }

    public Instruction parseForm(String formName, ITypeStore ts) throws ParserException {
        Instruction x;
        IFormHandler fh = (IFormHandler)this.m_formHandlers.get(formName);
        if (fh == null) {
            StaticMethodSpec sms = (StaticMethodSpec)this.m_importedJavaStaticMethods.get(formName);
            if (sms != null) {
                x = new StaticMethodInvocationInstruction(sms.m_class, sms.m_methodName, this.parseRemainingExpressions(ts), sms.m_returnType);
                if (x.getChildInstructionCount() != sms.m_parameterTypes.length) {
                    throw new ParserException("Invalid number of parameters to static Java method", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                }
            } else {
                x = new FunctionCallInstruction(formName, this.parseRemainingExpressions(ts));
            }
        } else {
            x = fh.parseForm(formName, this, ts);
        }
        if (this.getCurrentURL() != null) {
            x.setSourceFilename(this.getCurrentURL());
        }
        x.setSourceLineNumber(this.getLineNumber());
        return x;
    }

    public String parseIdentifier() throws ParserException {
        return this.parseIdentifier(true);
    }

    public String parseIdentifier(boolean required) throws ParserException {
        String identifier = null;
        StringBuffer sb = new StringBuffer();
        while (true) {
            char ch;
            if (Character.isWhitespace(ch = this.readStripComments(true)) || ch == '@' || ch == TypeParser.XMLTYPE_OPEN_CHAR || ch == '\u0000') {
                String s = sb.toString();
                if (s.length() == 0) {
                    if (ch != '@') continue;
                    identifier = "@";
                    break;
                }
                if (ch == '@' || ch == TypeParser.XMLTYPE_OPEN_CHAR) {
                    this.unread(ch);
                }
                identifier = s;
                break;
            }
            if (ch == ')' || ch == '(') {
                this.unread(ch);
                if (sb.length() == 0) {
                    if (required) {
                        throw new ParserException("Unexpected \"" + ch + "\"", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    identifier = null;
                    break;
                }
                identifier = sb.toString();
                break;
            }
            sb.append(ch);
        }
        return identifier;
    }

    public String parseTypeIdentifier(boolean required) throws ParserException {
        String identifier = null;
        StringBuffer sb = new StringBuffer();
        while (true) {
            char ch;
            if (Character.isWhitespace(ch = this.readStripComments()) || ch == '@' || ch == TypeParser.XMLTYPE_OPEN_CHAR || ch == TypeParser.XMLTYPE_CLOSE_CHAR) {
                String s = sb.toString();
                if (ch == TypeParser.XMLTYPE_OPEN_CHAR || ch == TypeParser.XMLTYPE_CLOSE_CHAR) {
                    this.unread(ch);
                    identifier = s.length() != 0 ? s : null;
                    break;
                }
                if (s.length() == 0) {
                    if (ch != '@') continue;
                    identifier = "@";
                    break;
                }
                if (ch == '@') {
                    this.unread(ch);
                }
                identifier = s;
                break;
            }
            if (!Character.isLetterOrDigit(ch) && ch != ':' && ch != '_' && ch != '-') {
                this.unread(ch);
                if (sb.length() == 0) {
                    if (required) {
                        throw new ParserException("Unexpected \"" + ch + "\"", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    identifier = null;
                    break;
                }
                identifier = sb.toString();
                break;
            }
            sb.append(ch);
        }
        return identifier;
    }

    public Type parseTypeName(ITypeStore ts) throws ParserException {
        return this.typeParser.parseTypeName(ts, true);
    }

    public Type parseTypeName(ITypeStore ts, boolean required) throws ParserException {
        return this.typeParser.parseTypeName(ts, required);
    }

    public Instruction[] parseRemainingExpressions(ITypeStore ts) throws ParserException {
        ArrayList<Instruction> al = new ArrayList<Instruction>();
        while (true) {
            Instruction n2;
            if ((n2 = this.parseExpression(ts, false)) == null) {
                Instruction[] values2 = new Instruction[al.size()];
                al.toArray(values2);
                return values2;
            }
            al.add(n2);
        }
    }

    public Object[] parseRemainingIdentifiers() throws ParserException {
        ArrayList<String> al = new ArrayList<String>();
        String n2;
        while ((n2 = this.parseIdentifier(false)) != null) {
            al.add(n2);
        }
        return al.toArray();
    }

    public Object[] parseRemainingIdentifiersNames() throws ParserException {
        ArrayList<Object> al = new ArrayList<Object>();
        Object n2;
        while ((n2 = this.parseName(false)) != null) {
            al.add(n2);
        }
        return al.toArray();
    }

    public Instruction parseExpression(ITypeStore ts) throws ParserException {
        return this.parseExpression(ts, true);
    }

    public Instruction parseExpression(ITypeStore ts, boolean required) throws ParserException {
        char ch;
        while (Character.isWhitespace(ch = this.readStripComments())) {
        }
        if (ch == '(') {
            this.unread(ch);
            return this.parseForm(ts);
        }
        if (ch == ')') {
            if (required) {
                throw new ParserException("Unexpected ')'", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            return null;
        }
        if (ch == '\"') {
            StreamInstruction i = StreamInstruction.charStreamLiteral(this.parseStringLiteral());
            i.setSourceFilename(this.m_currentSource.m_currentURL);
            i.setSourceLineNumber(this.m_currentSource.m_lineNumber);
            return i;
        }
        if (ch == '\'') {
            char ch2 = this.read();
            if (ch2 == '\\') {
                ch2 = this.resolveEscapeSequence();
            }
            if (this.read() != '\'') {
                throw new ParserException("Malformed character literal", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            return LiteralInstruction.charLiteral(ch2);
        }
        if (Character.isDigit(ch) || ch == '-' || ch == '.') {
            this.unread(ch);
            return this.parseNumber();
        }
        this.unread(ch);
        Object identifier = this.parseName(required);
        if (!required && identifier == null) {
            return null;
        }
        if (identifier.equals("true")) {
            return LiteralInstruction.booleanTrueLiteral();
        }
        if (identifier.equals("false")) {
            return LiteralInstruction.booleanFalseLiteral();
        }
        if (identifier.equals("unit")) {
            return LiteralInstruction.unitLiteral();
        }
        if (identifier.equals("floatNaN")) {
            return LiteralInstruction.floatLiteral(Float.NaN);
        }
        if (identifier.equals("floatPosINF")) {
            return LiteralInstruction.floatLiteral(Float.POSITIVE_INFINITY);
        }
        if (identifier.equals("floatNegINF")) {
            return LiteralInstruction.floatLiteral(Float.NEGATIVE_INFINITY);
        }
        if (identifier.equals("doubleNaN")) {
            return LiteralInstruction.doubleLiteral(Double.NaN);
        }
        if (identifier.equals("doublePosINF")) {
            return LiteralInstruction.doubleLiteral(Double.POSITIVE_INFINITY);
        }
        if (identifier.equals("doubleNegINF")) {
            return LiteralInstruction.doubleLiteral(Double.NEGATIVE_INFINITY);
        }
        IdentifierInstruction x = new IdentifierInstruction(identifier);
        if (this.getCurrentURL() != null) {
            x.setSourceFilename(this.getCurrentURL());
        }
        x.setSourceLineNumber(this.getLineNumber());
        return x;
    }

    long hex2long(String s) {
        int len = s.length();
        String x = s.toLowerCase();
        if (!x.startsWith("0x")) {
            throw new NumberFormatException("Expected long hex value, saw: " + s);
        }
        if (len > 19) {
            throw new NumberFormatException("Too many digits in long hex value: " + s);
        }
        long result2 = 0L;
        for (int i = 2; i < len - 1; ++i) {
            int hexit = s_hextable.indexOf(x.charAt(i));
            if (hexit < 0) {
                throw new NumberFormatException("Bad digit in long hex value: " + s);
            }
            result2 = result2 << 4 | (long)hexit;
        }
        return result2;
    }

    int hex2int(String s) {
        int len = s.length();
        String x = s.toLowerCase();
        if (!x.startsWith("0x")) {
            throw new NumberFormatException("Expected hex value, saw: " + s);
        }
        if (len > 10) {
            throw new NumberFormatException("Too many digits in hex value: " + s);
        }
        int result2 = 0;
        for (int i = 2; i < len; ++i) {
            result2 = result2 << 4 | s_hextable.indexOf(x.charAt(i)) - 1;
        }
        return result2;
    }

    public Instruction parseNumber() throws ParserException {
        String x = this.parseIdentifier(true);
        try {
            if (x.endsWith("f")) {
                return LiteralInstruction.floatLiteral(Float.parseFloat(x.substring(0, x.length() - 1)));
            }
            if (x.endsWith("d")) {
                return LiteralInstruction.doubleLiteral(Double.parseDouble(x.substring(0, x.length() - 1)));
            }
            if (x.endsWith("l")) {
                return LiteralInstruction.longLiteral(x.startsWith("0x") | x.startsWith("0X") ? this.hex2long(x) : Long.parseLong(x.substring(0, x.length() - 1)));
            }
            if (x.indexOf(46) == -1) {
                return LiteralInstruction.integerLiteral(x.startsWith("0x") | x.startsWith("0X") ? this.hex2int(x) : Integer.parseInt(x));
            }
            return LiteralInstruction.doubleLiteral(Double.parseDouble(x));
        }
        catch (NumberFormatException nfe) {
            throw new ParserException("Could not parse number: " + x, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
    }

    public int parseInteger() throws ParserException {
        String x = this.parseIdentifier(true);
        return Integer.parseInt(x);
    }

    public Object parseName() throws ParserException {
        return this.parseName(true);
    }

    public Object parseName(boolean required) throws ParserException {
        String x = this.parseIdentifier(required);
        if (null != x && x.length() > 0 && x.charAt(0) == '#') {
            return new Integer(Integer.parseInt(x.substring(1)));
        }
        return x;
    }

    public final char resolveEscapeSequence() throws ParserException {
        char ch = this.read();
        switch (ch) {
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case '\'': {
                return '\'';
            }
            case '\"': {
                return '\"';
            }
            case '\\': {
                return '\\';
            }
            case 'u': {
                char escapedCharacter = '\u0000';
                for (int i = 0; i < 4; ++i) {
                    char hexDigit = Character.toUpperCase(this.read());
                    if (hexDigit >= '0' && hexDigit <= '9') {
                        escapedCharacter = (char)((escapedCharacter << 4) + hexDigit - 48);
                        continue;
                    }
                    if (hexDigit >= 'A' && hexDigit <= 'F') {
                        escapedCharacter = (char)((escapedCharacter << 4) + 10 + hexDigit - 65);
                        continue;
                    }
                    throw new ParserException("A character that is not a hexadecimal digit was encountered in a Unicode escape sequence " + ch, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                }
                return escapedCharacter;
            }
        }
        throw new ParserException("Unknown escape sequence \\" + ch, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
    }

    public String parseStringLiteralFull(boolean required) throws ParserException {
        char ch = this.read();
        if (ch == '\"') {
            return this.parseStringLiteral();
        }
        if (required) {
            throw new ParserException("String Literal must begin with \", read: " + ch, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        this.unread(ch);
        return null;
    }

    public String parseStringLiteralFull() throws ParserException {
        return this.parseStringLiteralFull(true);
    }

    public String parseStringLiteral() throws ParserException {
        StringBuffer sb = new StringBuffer();
        char ch;
        while ((ch = this.read()) != '\"') {
            if (ch == '\\') {
                ch = this.resolveEscapeSequence();
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public boolean parseBooleanLiteral() throws ParserException {
        String x = this.parseIdentifier(true);
        if (x.equals("true")) {
            return true;
        }
        if (x.equals("false")) {
            return false;
        }
        throw new ParserException("Expected true or false; got " + x, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
    }

    protected void parseADT(ITypeStore ts) throws ParserException {
        String constructorName;
        String typeName = this.parseIdentifier(true);
        if (ts.lookupCompoundType(typeName) != null) {
            throw new ParserException("Duplicate type definition for " + typeName, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        ArrayList<AbstractDataType.Constructor> constructors = new ArrayList<AbstractDataType.Constructor>();
        while ((constructorName = this.parseFormPrologOrEnd()) != null) {
            Object x;
            ArrayList<Binding> list = new ArrayList<Binding>();
            while ((x = this.parseName(false)) != null) {
                Binding b = new Binding(x);
                char ch = this.readStripComments();
                if (ch != '@') {
                    throw new ParserException("Abstract data type constructor parameters must have types");
                }
                b.setType(this.typeParser.parseTypeName(ts));
                list.add(b);
            }
            this.parseCloseParen();
            Binding[] bindings = new Binding[list.size()];
            list.toArray(bindings);
            constructors.add(new AbstractDataType.Constructor(constructorName, bindings));
        }
        AbstractDataType.Constructor[] constructors2 = new AbstractDataType.Constructor[constructors.size()];
        constructors.toArray(constructors2);
        ts.addAbstractDataType(this.makeAbstractDataType(typeName, constructors2));
    }

    protected AbstractDataType makeAbstractDataType(String typeName, AbstractDataType.Constructor[] c) {
        return new ConstructorDataType(typeName, c);
    }

    protected void parseTypeAlias(ITypeStore ts) throws ParserException {
        String newTypeName = this.parseIdentifier(true);
        Type aliasedType = this.typeParser.parseTypeName(ts);
        if (aliasedType != null) {
            if (ts.lookupCompoundType(newTypeName) != null || ts.lookupTypeAlias(newTypeName) != null) {
                throw new ParserException("The new type name \"" + newTypeName + "\" specified in a type-alias was previously" + " defined.", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
        } else {
            throw new ParserException("The existing type name specified in a type-alias is unknown.", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        ts.addTypeAlias(newTypeName, aliasedType);
        this.parseCloseParen();
    }

    protected void parseJavaStaticMethodImport(ITypeStore ts) throws ParserException {
        StaticMethodSpec sms = new StaticMethodSpec();
        sms.m_name = this.parseIdentifier(true);
        sms.m_class = this.parseIdentifier(true);
        sms.m_methodName = this.parseIdentifier(true);
        sms.m_returnType = this.typeParser.parseTypeName(ts);
        sms.m_parameterTypes = this.typeParser.parseRemainingTypes(ts);
        this.m_importedJavaStaticMethods.put(sms.m_name, sms);
    }

    protected void parseFunction(Module m) throws ParserException {
        Object x;
        String functionName;
        char ch;
        this.m_typeVariables = new HashMap();
        boolean memoize = false;
        boolean impure = false;
        boolean inline = false;
        while (Character.isWhitespace(ch = this.readStripComments())) {
        }
        this.unread(ch);
        if (ch != '(') {
            String keyword = this.parseIdentifier();
            if (keyword.equals("memoize")) {
                memoize = true;
            } else if (keyword.equals("impure")) {
                impure = true;
            } else if (keyword.equals("inline")) {
                inline = true;
            } else {
                throw new ParserException("Invalid function attribute " + keyword, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
        }
        if (m.getFunction(functionName = this.parseFormProlog()) != null) {
            Function existing = m.getFunction(functionName);
            if (null == existing.m_definitionURL && 0 == existing.m_definitionLineNumber) {
                throw new ParserException("Duplicate function definition for " + functionName, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            throw new ParserException("Duplicate function definition for " + functionName + "\n" + "  First defined at " + existing.m_definitionURL + " line " + existing.m_definitionLineNumber, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        char ch2 = this.readStripComments();
        Type returnType = null;
        if (ch2 == '@') {
            returnType = this.typeParser.parseTypeName(m);
        } else {
            this.unread(ch2);
        }
        ArrayList<Binding> list = new ArrayList<Binding>();
        while ((x = this.parseName(false)) != null) {
            Binding b = new Binding(x);
            ch2 = this.readStripComments();
            if (ch2 != '@') {
                this.unread(ch2);
            } else {
                b.setType(this.typeParser.parseTypeName(m));
            }
            list.add(b);
        }
        this.parseCloseParen();
        Binding[] bindings = new Binding[list.size()];
        list.toArray(bindings);
        Instruction body = this.parseExpression(m);
        Function f2 = new Function(functionName, bindings, body, this.getCurrentURL(), this.getLineNumber());
        if (returnType != null) {
            f2.setReturnType(returnType);
        }
        m.addFunction(f2);
        if (memoize) {
            f2.setMemoizeResult(true);
        }
        if (impure) {
            f2.setImpurity(true);
        }
        if (inline) {
            f2.setInlineHint(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleSignature parseExternalModuleSignature(ParserSource ps) throws ParserException {
        this.m_sourceStack.add(this.m_currentSource);
        try {
            this.m_currentSource = ps;
            if (!"module-signature".equals(this.parseFormProlog())) {
                throw new ParserException("Expected module-signature form at root level", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            ModuleSignature moduleSignature = this.parseModuleSignature();
            return moduleSignature;
        }
        finally {
            this.m_currentSource = (ParserSource)this.m_sourceStack.remove(this.m_sourceStack.size() - 1);
        }
    }

    protected ModuleSignature parseModuleSignature() throws ParserException {
        this.m_typeVariables = new HashMap();
        String typeName = this.parseIdentifier(true);
        if (this.m_knownModuleSignatures.lookupModuleSignature(typeName) != null) {
            throw new ParserException("Duplicate module signature definition for " + typeName, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        ModuleSignature ms = new ModuleSignature(typeName);
        while (true) {
            String formName;
            if ((formName = this.parseFormPrologOrEnd()) == null) {
                this.m_knownModuleSignatures.registerModuleSignature(typeName, ms);
                return ms;
            }
            if (formName.equals("declare-function")) {
                Object x;
                String functionName = this.parseIdentifier(true);
                if (!this.parseIdentifier(true).equals("@")) {
                    throw new ParserException("function signature must include return type", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                }
                Type returnType = this.typeParser.parseTypeName(ms);
                ArrayList<Type> list = new ArrayList<Type>();
                ArrayList<Object> list2 = new ArrayList<Object>();
                while ((x = this.parseName(false)) != null) {
                    char ch = this.readStripComments();
                    if (ch != '@') {
                        throw new ParserException("parameters in function signature must include types", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    list2.add(x);
                    list.add(this.typeParser.parseTypeName(ms));
                }
                Type[] types2 = new Type[list.size()];
                list.toArray(types2);
                Object[] names = new Object[list2.size()];
                list2.toArray(names);
                ms.addFunctionSignature(new FunctionSignature(functionName, names, types2, returnType));
            } else if (formName.equals("declare-datatype")) {
                String type2 = this.parseIdentifier(true);
            } else {
                if (formName.equals("define-datatype")) {
                    this.parseADT(ms);
                    continue;
                }
                if (formName.equals("type-alias")) {
                    this.parseTypeAlias(ms);
                    continue;
                }
                throw new ParserException("Unrecognized keyword: " + formName, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            this.parseCloseParen();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseLibrary(Module program, String libraryName) throws ParserException {
        ParserSource ps = this.m_sourceResolver.resolve(this.m_currentSource, libraryName);
        URL url = ps.m_currentURL;
        if (url == null) {
            throw new ParserException("An error occurred resolving library " + libraryName);
        }
        if (this.m_parsedLibrary.contains(url)) {
            return;
        }
        this.m_parsedLibrary.add(url);
        this.m_sourceStack.add(this.m_currentSource);
        try {
            this.m_currentSource = ps;
            String pfp = this.parseFormProlog();
            if (!"library".equals(pfp)) {
                throw new ParserException("Expected library form at root level of (" + libraryName + "), found " + pfp, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            while (true) {
                String formName;
                if ((formName = this.parseFormPrologOrEnd()) == null) {
                    return;
                }
                if (formName.equals("import-library")) {
                    String libName = this.parseIdentifier(true);
                    this.parseLibrary(program, libName);
                } else if (formName.equals("import-java-static-method")) {
                    this.parseJavaStaticMethodImport(program);
                } else if (formName.equals("declare-datatype")) {
                    String type2 = this.parseIdentifier(true);
                } else if (formName.equals("function")) {
                    this.parseFunction(program);
                } else {
                    if (formName.equals("vdtmap")) {
                        this.parseVDTMap(program);
                        continue;
                    }
                    if (formName.equals("define-datatype")) {
                        this.parseADT(program);
                        continue;
                    }
                    if (!formName.equals("type-alias")) throw new ParserException("Unexpected form " + formName + " in library form", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    this.parseTypeAlias(program);
                    continue;
                }
                this.parseCloseParen();
                continue;
                break;
            }
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            throw new ParserException("I/O error", ioe);
        }
        finally {
            this.m_currentSource = (ParserSource)this.m_sourceStack.remove(this.m_sourceStack.size() - 1);
        }
    }

    public VirtualDataTypeMap parseVDTMap() throws ParserException {
        String formName;
        AbstractTypeStore ats = new AbstractTypeStore();
        VirtualDataTypeMap vdtm = new VirtualDataTypeMap();
        if (!this.parseFormProlog().equals("vdtmap")) {
            throw new ParserException("Virtual data type maps must start with vdtmap", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        while ((formName = this.parseFormPrologOrEnd()) != null) {
            if (!formName.equals("map-datatype")) {
                throw new ParserException("Virtual data type maps can only contain map-datatype directives", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            String adtName = this.parseIdentifier();
            if (vdtm.hasVDTMapping(adtName)) {
                throw new ParserException("map-datatype already supplied for " + adtName, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            Type targetType = this.typeParser.parseTypeName(ats);
            VirtualDataTypeMap.ADTMapping adtm = new VirtualDataTypeMap.ADTMapping();
            vdtm.addVDTMapping(adtName, adtm);
            adtm.m_targetType = targetType;
            while ((formName = this.parseFormPrologOrEnd()) != null) {
                if (formName.equals("map-match")) {
                    if (adtm.m_matchCode != null) {
                        throw new ParserException("map-match already supplied", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    adtm.m_matchVariable = new Binding(this.parseName());
                    adtm.m_matchCode = this.parseExpression(ats);
                    this.parseCloseParen();
                    continue;
                }
                if (formName.equals("map-constructor")) {
                    String constructorName = this.parseIdentifier();
                    VirtualDataTypeMap.ConstructorMapping cm = new VirtualDataTypeMap.ConstructorMapping();
                    if (adtm.m_constructors.containsKey(constructorName)) {
                        throw new ParserException("map-constructor already supplied for " + constructorName, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    while ((formName = this.parseFormPrologOrEnd()) != null) {
                        if (formName.equals("construct")) {
                            if (cm.m_constructCode != null) {
                                throw new ParserException("construct already supplied", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                            }
                            this.parseOpenParen();
                            cm.m_constructParameters = Binding.getBindings(this.parseRemainingIdentifiers());
                            this.parseCloseParen();
                            cm.m_constructCode = this.parseExpression(ats);
                            this.parseCloseParen();
                            continue;
                        }
                        if (formName.equals("deconstruct")) {
                            if (cm.m_deconstructVariable != null) {
                                throw new ParserException("deconstruct already supplied");
                            }
                            cm.m_deconstructVariable = new Binding(this.parseName());
                            continue;
                        }
                        throw new ParserException("Unrecognized form: " + formName);
                    }
                    adtm.m_constructors.put(constructorName, cm);
                    continue;
                }
                throw new ParserException("Unrecognized form: " + formName, this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
        }
        return vdtm;
    }

    protected void parseVDTMap(Module m) throws ParserException {
        String formName;
        while ((formName = this.parseFormPrologOrEnd()) != null) {
            if (!formName.equals("map-datatype")) {
                throw new ParserException("Virtual data type maps can only contain map-datatype directives");
            }
            String adtName = this.parseIdentifier();
            if (m.getVDTMap().hasVDTMapping(adtName)) {
                throw new ParserException("map-datatype already supplied for " + adtName);
            }
            Type targetType = this.typeParser.parseTypeName(m);
            VirtualDataTypeMap.ADTMapping adtm = new VirtualDataTypeMap.ADTMapping();
            m.getVDTMap().addVDTMapping(adtName, adtm);
            adtm.m_targetType = targetType;
            while ((formName = this.parseFormPrologOrEnd()) != null) {
                if (formName.equals("map-match")) {
                    if (adtm.m_matchCode != null) {
                        throw new ParserException("map-match already supplied");
                    }
                    adtm.m_matchVariable = new Binding(this.parseName());
                    TupleInstruction pre_matchCode = new TupleInstruction(new Instruction[]{this.parseExpression(m)});
                    Function func_matchCode = new Function(OptimizerUtilities.generateIntermediateIdentifier(), new Binding[]{new Binding(adtm.m_matchVariable)}, pre_matchCode);
                    try {
                        func_matchCode.typeCheck(m, null, new LinkedList<Function>());
                    }
                    catch (TypeCheckException tce) {
                        throw new ParserException("match code in " + adtName + " vdtmapping does not typecheck!", tce);
                    }
                    func_matchCode.reduce();
                    adtm.m_matchCode = func_matchCode.getBody();
                    this.parseCloseParen();
                    continue;
                }
                if (formName.equals("map-constructor")) {
                    String constructorName = this.parseIdentifier();
                    VirtualDataTypeMap.ConstructorMapping cm = new VirtualDataTypeMap.ConstructorMapping();
                    if (adtm.m_constructors.containsKey(constructorName)) {
                        throw new ParserException("map-constructor already supplied for " + constructorName);
                    }
                    while ((formName = this.parseFormPrologOrEnd()) != null) {
                        if (formName.equals("construct")) {
                            if (cm.m_constructCode != null) {
                                throw new ParserException("construct already supplied");
                            }
                            this.parseOpenParen();
                            cm.m_constructParameters = Binding.getBindings(this.parseRemainingIdentifiers());
                            this.parseCloseParen();
                            Instruction pre_constructCode = this.parseExpression(m);
                            Binding[] bind_constructCode = new Binding[cm.m_constructParameters.length];
                            for (int i = 0; i < cm.m_constructParameters.length; ++i) {
                                bind_constructCode[i] = new Binding(cm.m_constructParameters[i]);
                            }
                            Function func_constructCode = new Function(OptimizerUtilities.generateIntermediateIdentifier(), bind_constructCode, pre_constructCode);
                            try {
                                func_constructCode.typeCheck(m, null, new LinkedList<Function>());
                            }
                            catch (TypeCheckException tce) {
                                throw new ParserException("construct code in " + adtName + " vdtmapping does not typecheck!", tce);
                            }
                            func_constructCode.reduce();
                            cm.m_constructCode = func_constructCode.getBody();
                            this.parseCloseParen();
                            continue;
                        }
                        if (formName.equals("deconstruct")) {
                            if (cm.m_deconstructVariable != null) {
                                throw new ParserException("deconstruct already supplied");
                            }
                            cm.m_deconstructVariable = new Binding(this.parseName());
                            TupleInstruction pre_deconstructCode = new TupleInstruction(this.parseRemainingExpressions(m));
                            Function func_deconstructCode = new Function(OptimizerUtilities.generateIntermediateIdentifier(), new Binding[]{new Binding((Object)cm.m_deconstructVariable, adtm.m_targetType, new TypeEnvironment(m))}, pre_deconstructCode);
                            try {
                                func_deconstructCode.typeCheck(m, null, new LinkedList<Function>());
                            }
                            catch (TypeCheckException tce) {
                                throw new ParserException("deconstruct code in " + adtName + " vdtmapping does not typecheck!", tce);
                            }
                            func_deconstructCode.reduce();
                            cm.m_deconstructCode = func_deconstructCode.getBody();
                            continue;
                        }
                        throw new ParserException("Unrecognized form: " + formName);
                    }
                    adtm.m_constructors.put(constructorName, cm);
                    continue;
                }
                throw new ParserException("Unrecognized form: " + formName);
            }
        }
    }

    protected void parseModule(Module m, boolean isLibrary) throws ParserException {
        String formName;
        while ((formName = this.parseFormPrologOrEnd()) != null) {
            ModuleSignature ms;
            String moduleSignature;
            String moduleName;
            if (formName.equals("main")) {
                this.m_typeVariables = new HashMap();
                m.addFunction(new Function("main", new Binding[0], this.parseExpression(m), this.getCurrentURL(), this.getLineNumber()));
                this.parseCloseParen();
                break;
            }
            if (formName.equals("import-library")) {
                String libName = this.parseIdentifier(true);
                this.parseLibrary(m, libName);
            } else if (formName.equals("import-module")) {
                moduleName = this.parseIdentifier(true);
                ModuleSignature ms2 = this.resolveModuleSignature(moduleName);
                m.addModuleImportDirective(new TopLevelModuleImportDirective(moduleName, ms2, moduleName));
            } else if (formName.equals("apply-functor")) {
                moduleName = this.parseIdentifier(true);
                if (!this.parseIdentifier(true).equals("@")) {
                    throw new ParserException("apply-functor must have signature specified", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                }
                moduleSignature = this.parseIdentifier(true);
                ms = this.resolveModuleSignature(moduleSignature);
                String functor = this.parseIdentifier(true);
                Object[] params = this.parseRemainingIdentifiers();
                m.addModuleImportDirective(new FunctorApplicationDirective(moduleName, ms, functor, params));
            } else if (formName.equals("import-java-static-method")) {
                this.parseJavaStaticMethodImport(m);
            } else if (formName.equals("declare-datatype")) {
                String type2 = this.parseIdentifier(true);
            } else if (formName.equals("function")) {
                this.parseFunction(m);
            } else {
                if (formName.equals("vdtmap")) {
                    this.parseVDTMap(m);
                    continue;
                }
                if (formName.equals("module")) {
                    moduleName = this.parseIdentifier(true);
                    if (!this.parseIdentifier(true).equals("@")) {
                        throw new ParserException("module must have signature specified", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    moduleSignature = this.parseIdentifier(true);
                    ms = this.resolveModuleSignature(moduleSignature);
                    Module m2 = new Module(moduleName, m, ms);
                    this.parseModule(m2, false);
                    m.addModule(m2);
                    continue;
                }
                if (formName.equals("functor")) {
                    moduleName = this.parseFormProlog();
                    if (!this.parseIdentifier(true).equals("@")) {
                        throw new ParserException("functor must have signature specified", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                    }
                    moduleSignature = this.parseIdentifier(true);
                    ms = this.resolveModuleSignature(moduleSignature);
                    Object[] params = this.parseRemainingIdentifiers();
                    this.parseCloseParen();
                    ModuleSignature[] paramSignatures = new ModuleSignature[params.length / 3];
                    Object[] paramNames = new Object[params.length / 3];
                    for (int i = 0; i < params.length; i += 3) {
                        if (!params[i + 1].equals("@")) {
                            throw new ParserException("parameters to functor must include types", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
                        }
                        ModuleSignature ms2 = this.resolveModuleSignature(params[i + 2].toString());
                        paramNames[i / 3] = params[i];
                        paramSignatures[i / 3] = ms2;
                    }
                    Module m2 = new Module(moduleName, m, ms);
                    this.parseModule(m2, false);
                    Functor f2 = new Functor(moduleName, m2, paramSignatures, (String[])paramNames, ms);
                    m.addFunctor(f2);
                    continue;
                }
                if (formName.equals("define-datatype")) {
                    this.parseADT(m);
                    continue;
                }
                if (formName.equals("type-alias")) {
                    this.parseTypeAlias(m);
                    continue;
                }
                throw new ParserException("Unexpected form " + formName + " in program form", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
            }
            this.parseCloseParen();
        }
    }

    public Module parseModule() throws ParserException {
        return this.parseModule(null);
    }

    public Module parseModule(ModuleSignature ms) throws ParserException {
        boolean generateSignature;
        this.m_parsedLibrary.add(this.m_baseURL);
        String topLevel = this.parseFormProlog();
        boolean bl = generateSignature = ms == null;
        if (!"module".equals(topLevel)) {
            return this.parseProgramOrModuleFragment(false, topLevel);
        }
        String moduleName = this.parseIdentifier(true);
        if (ms == null) {
            ms = new ModuleSignature("");
        }
        Module m2 = new Module(moduleName, null, ms);
        this.parseModule(m2, false);
        Parser.resolveFixups(m2, this.m_typeFixups);
        this.m_typeFixups.clear();
        return m2;
    }

    public static void resolveFixups(Module m2, ArrayList typeFixups) throws ParserException {
    }

    public ModuleSignature resolveModuleSignature(String name2) throws ParserException {
        try {
            ModuleSignature ms = this.m_knownModuleSignatures.resolveModuleSignature(name2);
            if (ms == null) {
                throw new RuntimeException();
            }
            return ms;
        }
        catch (Exception e) {
            throw new ParserException("Unable to resolve module signature " + name2 + " in \n" + this.m_knownModuleSignatures, e);
        }
    }

    public Module parseModuleFragment() throws ParserException {
        return this.parseProgramOrModuleFragment(true, null);
    }

    public Program parseProgram() throws ParserException {
        return (Program)this.parseProgramOrModuleFragment(false, null);
    }

    public Module parseProgramOrModuleFragment(boolean makeModule, String topLevel) throws ParserException {
        Module program;
        ModuleSignature ms;
        boolean firstTime = true;
        while (true) {
            if (!firstTime || null == topLevel) {
                this.m_parsedLibrary.add(this.m_baseURL);
                topLevel = this.parseFormProlog();
            }
            firstTime = false;
            if (!topLevel.equals("module-signature")) break;
            this.parseModuleSignature();
        }
        boolean isLibrary = "library".equals(topLevel);
        if (!isLibrary && !"program".equals(topLevel)) {
            throw new ParserException("Expected program or library form at root level", this.getCurrentURL(), this.getLineNumber(), this.getOffsetInLine());
        }
        String moduleName = null;
        if (!isLibrary) {
            moduleName = this.parseIdentifier(false);
        }
        if (!isLibrary) {
            char x = this.read();
            if (x != '@') {
                ms = new ModuleSignature("");
                if (makeModule) {
                    ms.addFunctionSignature(new FunctionSignature("main", new Object[0], new Type[0], null));
                }
                this.unread(x);
            } else {
                String moduleSignature = this.parseIdentifier(true);
                ms = this.resolveModuleSignature(moduleSignature);
            }
        } else {
            ms = new ModuleSignature("");
        }
        Module module = program = makeModule ? new Module("", null) : new Program(ms);
        if (null != moduleName) {
            program.setName(moduleName);
        }
        this.parseModule(program, isLibrary);
        return program;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Object[] objArray1 = this.m_sourceStack.toArray();
        int mx = objArray1.length + 1;
        Object[] objArray = new Object[mx];
        System.arraycopy(objArray1, 0, objArray, 0, mx - 1);
        objArray[mx - 1] = this.m_currentSource;
        for (int i = mx - 1; 0 <= i; --i) {
            if (i == mx - 1) {
                sb.append("at   ");
            } else {
                sb.append("from ");
            }
            ParserSource ps = (ParserSource)objArray[i];
            URL url = ps.m_currentURL;
            if (url != null) {
                String surl = ps.m_currentURL.toString();
                int idx = surl.lastIndexOf(47);
                if (0 < idx) {
                    surl = surl.substring(idx);
                }
                sb.append(surl);
            }
            sb.append(" at line ");
            sb.append(ps.m_lineNumber);
            sb.append(" at offset ");
            sb.append(ps.m_offset);
            sb.append('\n');
        }
        String ret = sb.toString();
        return ret;
    }

    public TypeParser getTypeParser() {
        return this.typeParser;
    }

    public static class StaticMethodSpec {
        String m_name;
        String m_class;
        String m_methodName;
        Type m_returnType;
        Type[] m_parameterTypes;
    }
}

