/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.parser;

import com.ibm.xltxe.rnm1.xylem.parser.ParserException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;

public class ParserSource {
    protected PushbackReader m_reader;
    protected int m_lineNumber = 1;
    private boolean m_prev_was_CR;
    private boolean m_CR_seen;
    protected int m_offset = 0;
    protected URL m_currentURL = null;

    public ParserSource() {
        this.m_currentURL = null;
    }

    public ParserSource(URL url) throws ParserException {
        this.m_currentURL = url;
        this.m_reader = new PushbackReader(this.getInputStreamReader(this.m_currentURL), 256);
    }

    public ParserSource(Reader reader, URL url) {
        this.m_currentURL = url;
        this.m_reader = new PushbackReader(reader, 256);
    }

    public ParserSource(Reader reader) {
        this(reader, null);
    }

    private final InputStreamReader getInputStreamReader(URL url) throws ParserException {
        InputStream in2 = null;
        try {
            in2 = url.openStream();
            return new InputStreamReader(in2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return new InputStreamReader(in2);
        }
        catch (Exception e) {
            throw new ParserException("Error reading URL " + url, e);
        }
    }

    public void unread(char ch) throws ParserException {
        try {
            this.m_reader.unread(ch);
            --this.m_offset;
        }
        catch (IOException ioe) {
            throw new ParserException("I/O error", ioe);
        }
    }

    public char read() throws ParserException {
        return this.read(false);
    }

    public char read(boolean noErrorAtEnd) throws ParserException {
        int n2;
        try {
            n2 = this.m_reader.read();
            ++this.m_offset;
        }
        catch (IOException ioe) {
            throw new ParserException("I/O error", ioe);
        }
        switch (n2) {
            case -1: {
                if (!noErrorAtEnd) {
                    throw new ParserException("Unexpected end of file");
                }
                return '\u0000';
            }
            case 13: {
                this.m_CR_seen = true;
                if (this.m_prev_was_CR) break;
                this.m_offset = 0;
                ++this.m_lineNumber;
                this.m_prev_was_CR = true;
                break;
            }
            case 10: {
                this.m_offset = 0;
                if (!this.m_CR_seen) {
                    ++this.m_lineNumber;
                    this.m_offset = 0;
                }
                this.m_prev_was_CR = false;
                break;
            }
            default: {
                this.m_prev_was_CR = false;
            }
        }
        return (char)n2;
    }
}

