/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xltxe.rnm1.xylem.parser;

import com.ibm.xltxe.rnm1.xtq.common.utils.Util;
import com.ibm.xltxe.rnm1.xylem.ITypeStore;
import com.ibm.xltxe.rnm1.xylem.Type;
import com.ibm.xltxe.rnm1.xylem.parser.ITypeHandler;
import com.ibm.xltxe.rnm1.xylem.parser.IXMLTypeParser;
import com.ibm.xltxe.rnm1.xylem.parser.Parser;
import com.ibm.xltxe.rnm1.xylem.parser.ParserException;
import com.ibm.xltxe.rnm1.xylem.types.JavaArrayType;
import com.ibm.xltxe.rnm1.xylem.types.JavaObjectType;
import com.ibm.xltxe.rnm1.xylem.types.LambdaType;
import com.ibm.xltxe.rnm1.xylem.types.LazyStreamType;
import com.ibm.xltxe.rnm1.xylem.types.NamedType;
import com.ibm.xltxe.rnm1.xylem.types.NullableType;
import com.ibm.xltxe.rnm1.xylem.types.PromiseType;
import com.ibm.xltxe.rnm1.xylem.types.SlotType;
import com.ibm.xltxe.rnm1.xylem.types.StreamType;
import com.ibm.xltxe.rnm1.xylem.types.TagType;
import com.ibm.xltxe.rnm1.xylem.types.TupleType;
import com.ibm.xltxe.rnm1.xylem.types.TypeVariable;
import com.ibm.xltxe.rnm1.xylem.types.UnionType;
import com.ibm.xml.xci.dp.util.xml.QNameUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;

public class TypeParser {
    Parser parser;
    public static char XMLTYPE_OPEN_CHAR = (char)123;
    public static char XMLTYPE_CLOSE_CHAR = (char)125;
    public static String XMLTYPE_OPEN_STRING = Character.toString(XMLTYPE_OPEN_CHAR);
    public static String XMLTYPE_CLOSE_STRING = Character.toString(XMLTYPE_CLOSE_CHAR);
    public static String XMLTYPE_UNSTABLE_STRING = "unstable";
    private NamespaceContext dumbStupidNamespaceContext = new NamespaceContextImpl();

    TypeParser(Parser parser) {
        this.parser = parser;
    }

    public Type _parseTypeName(ITypeStore ts, String typeName) throws ParserException {
        Type t;
        boolean isStream = false;
        if (typeName.endsWith("[]")) {
            typeName = typeName.substring(0, typeName.length() - 2);
            isStream = true;
        }
        if (typeName.startsWith("?")) {
            if (this.parser.m_typeVariables == null) {
                throw new ParserException("Type variables not allowed here", this.parser.getCurrentURL(), this.parser.getLineNumber(), this.parser.getOffsetInLine());
            }
            t = (Type)this.parser.m_typeVariables.get(typeName.substring(1));
            if (t == null) {
                t = new TypeVariable();
                this.parser.m_typeVariables.put(typeName.substring(1), t);
            }
        } else {
            ITypeHandler th = (ITypeHandler)this.parser.m_typeHandlers.get(typeName);
            if (th == null) {
                t = ts.lookupTypeAlias(typeName);
                if (t == null) {
                    t = new NamedType(typeName);
                }
            } else {
                t = th.parseType(typeName, this.parser);
            }
            if (t == null) {
                throw new ParserException("Unknown type name: " + typeName, this.parser.getCurrentURL(), this.parser.getLineNumber(), this.parser.getOffsetInLine());
            }
        }
        return isStream ? new StreamType(t) : t;
    }

    protected Type[] parseRemainingTypes(ITypeStore ts) throws ParserException {
        ArrayList<Type> list = new ArrayList<Type>();
        while (true) {
            Type t;
            if ((t = this.parseTypeName(ts, false)) == null) {
                Type[] types2 = new Type[list.size()];
                list.toArray(types2);
                return types2;
            }
            list.add(t);
        }
    }

    protected Type[] parseUnionType(ITypeStore ts, boolean required) throws ParserException {
        ArrayList<Type> list = new ArrayList<Type>();
        while (true) {
            Type t;
            if ((t = this.parseUnionTypeName(ts, true)) == null) {
                Type[] types2 = new Type[list.size()];
                list.toArray(types2);
                return types2;
            }
            list.add(t);
        }
    }

    protected Type parseUnionTypeName(ITypeStore ts, boolean required) throws ParserException {
        String s;
        char ch = TypeParser.getNextNonWhitespaceChar(this.parser);
        if (ch == ')') {
            return null;
        }
        if (ch != '(') {
            this.parser.unread(ch);
        }
        if ((s = this.parser.parseIdentifier(required)) == null) {
            return null;
        }
        return this._parseTypeName(ts, s);
    }

    public Type parseTypeName(ITypeStore ts) throws ParserException {
        return this.parseTypeName(ts, true);
    }

    public static char getNextNonWhitespaceChar(Parser parser, boolean noErrorAtEnd) throws ParserException {
        char operatorMaybe;
        while (Character.isWhitespace(operatorMaybe = parser.readStripComments(noErrorAtEnd))) {
        }
        return operatorMaybe;
    }

    public static char getNextNonWhitespaceChar(Parser parser) throws ParserException {
        char operatorMaybe;
        while (Character.isWhitespace(operatorMaybe = parser.readStripComments())) {
        }
        return operatorMaybe;
    }

    public Type parseTypeName(ITypeStore ts, boolean required) throws ParserException {
        Type type2;
        char ch = TypeParser.getNextNonWhitespaceChar(this.parser);
        if (ch == XMLTYPE_OPEN_CHAR) {
            IXMLTypeParser xmlTypeParser = this.parser.getXMLTypeParser();
            assert (xmlTypeParser != null);
            type2 = xmlTypeParser.parseXMLType(this.parser);
            ch = TypeParser.getNextNonWhitespaceChar(this.parser);
            if (ch != XMLTYPE_CLOSE_CHAR) {
                throw new ParserException("\nXML Type must end with: \"" + XMLTYPE_CLOSE_CHAR + "\"", this.parser.getCurrentURL(), this.parser.getLineNumber(), this.parser.getOffsetInLine());
            }
        } else if (ch == '(') {
            String t = this.parser.parseIdentifier(true);
            if (t.equals("slot")) {
                type2 = new SlotType(this.parseTypeName(ts));
            } else if (t.equals("promise")) {
                type2 = new PromiseType(this.parseTypeName(ts));
            } else if (t.equals("tag")) {
                type2 = new TagType(this.parser.parseIdentifier(), this.parseTypeName(ts));
            } else if (t.equals("nullable")) {
                type2 = new NullableType(this.parseTypeName(ts));
            } else if (t.equals("lazy-stream")) {
                type2 = new LazyStreamType(this.parseTypeName(ts));
            } else if (t.equals("->")) {
                this.parser.parseOpenParen();
                Type[] params = this.parseRemainingTypes(ts);
                this.parser.parseCloseParen();
                type2 = new LambdaType(params, this.parseTypeName(ts), true);
            } else if (t.equals("!->")) {
                this.parser.parseOpenParen();
                Type[] params = this.parseRemainingTypes(ts);
                this.parser.parseCloseParen();
                type2 = new LambdaType(params, this.parseTypeName(ts), false);
            } else if (t.equals("tuple")) {
                type2 = new TupleType(this.parseRemainingTypes(ts));
            } else if (t.equals("union")) {
                type2 = new UnionType(this.parseUnionType(ts, true));
            } else if (t.equals("java-array")) {
                type2 = this.parseTypeName(ts);
                int n2 = this.parser.parseInteger();
                type2 = new JavaArrayType(type2, n2);
            } else if (t.equals("java")) {
                type2 = new JavaObjectType(this.parser.parseIdentifier());
            } else {
                Type[] params = this.parseRemainingTypes(ts);
                type2 = new NamedType(t, ts.getName(), params);
            }
            this.parser.parseCloseParen();
        } else {
            this.parser.unread(ch);
            String s = this.parser.parseIdentifier(required);
            if (s == null) {
                return null;
            }
            if (!this.validateTypeName(s)) {
                throw new ParserException("\nType name must match production for QName: \"" + s + "\"", this.parser.getCurrentURL(), this.parser.getLineNumber(), this.parser.getOffsetInLine());
            }
            type2 = this._parseTypeName(ts, s);
        }
        ch = TypeParser.getNextNonWhitespaceChar(this.parser, true);
        if (ch == '[') {
            ch = TypeParser.getNextNonWhitespaceChar(this.parser);
            if (ch == ']') {
                return new StreamType(type2);
            }
            this.parser.unread(ch);
        } else {
            this.parser.unread(ch);
        }
        return type2;
    }

    private boolean validateTypeName(String s) {
        int indexOfLBracket = s.indexOf(91);
        if (indexOfLBracket > -1) {
            String brackets = s.substring(indexOfLBracket);
            for (int i = 1; i < brackets.length(); ++i) {
                char c = brackets.charAt(i);
                if (Character.isSpaceChar(c) || c == ']') continue;
                return false;
            }
            s = s.substring(0, indexOfLBracket);
        }
        return this.validateName(s);
    }

    public QName parseAndValidateQName(boolean required) throws ParserException {
        String s = this.parseAndValidateQNameToString(required);
        QName qname2 = null;
        if (required || s != null) {
            qname2 = QNameUtil.toQName(this.dumbStupidNamespaceContext, s);
        }
        return qname2;
    }

    public String parseAndValidateQNameToString(boolean required) throws ParserException {
        String s = this.parser.parseTypeIdentifier(required);
        if ((required || s != null) && !this.validateTypeName(s)) {
            throw new ParserException("\nType name must match production for QName: \"" + s + "\"", this.parser.getCurrentURL(), this.parser.getLineNumber(), this.parser.getOffsetInLine());
        }
        return s;
    }

    public String parseAndValidateNCNameOrWildcardToString(boolean required) throws ParserException {
        char c = TypeParser.getNextNonWhitespaceChar(this.parser);
        if (c == '*') {
            return null;
        }
        this.parser.unread(c);
        String s = this.parser.parseTypeIdentifier(required);
        if ((required || s != null) && !this.validateTypeName(s)) {
            throw new ParserException("\nType name must match production for NCName: \"" + s + "\"", this.parser.getCurrentURL(), this.parser.getLineNumber(), this.parser.getOffsetInLine());
        }
        if (s != null && s.equals("*")) {
            return null;
        }
        return s;
    }

    public String parseAndValidateElementNameOrWildcardToString(boolean required) throws ParserException {
        char c = TypeParser.getNextNonWhitespaceChar(this.parser);
        if (c == '*') {
            return null;
        }
        this.parser.unread(c);
        String s = this.parser.parseTypeIdentifier(required);
        if (!(!required && s == null || s.trim().equals("*") || this.validateTypeName(s))) {
            throw new ParserException("\nType name must match production for NCName: \"" + s + "\"", this.parser.getCurrentURL(), this.parser.getLineNumber(), this.parser.getOffsetInLine());
        }
        return s;
    }

    public QName parseAndValidateElementNameOrWildcard(boolean required) throws ParserException {
        char c = TypeParser.getNextNonWhitespaceChar(this.parser);
        if (c == '*') {
            return null;
        }
        this.parser.unread(c);
        String s = this.parser.parseTypeIdentifier(required);
        if ((required || s != null) && !s.trim().equals("*")) {
            QName qname2 = null;
            if (required || s != null) {
                qname2 = QNameUtil.toQName(this.dumbStupidNamespaceContext, s);
            }
            return qname2;
        }
        return null;
    }

    public boolean validateName(String s) {
        return Util.isValidQNames(s);
    }

    private static class NamespaceContextImpl
    implements NamespaceContext {
        private HashMap<String, String> prefixToNamespace = new HashMap();
        private HashMap<String, String> namespaceToPrefix = new HashMap();

        public NamespaceContextImpl() {
            this.register("xs", "http://www.w3.org/2001/XMLSchema");
        }

        private void register(String prefix2, String uri2) {
            this.prefixToNamespace.put(prefix2, uri2);
            this.namespaceToPrefix.put(uri2, prefix2);
        }

        @Override
        public String getNamespaceURI(String arg0) {
            String result2 = this.prefixToNamespace.get(arg0);
            if (result2 == null) {
                result2 = "";
            }
            return result2;
        }

        @Override
        public String getPrefix(String arg0) {
            return this.namespaceToPrefix.get(arg0);
        }

        public Iterator getPrefixes(String arg0) {
            return this.prefixToNamespace.keySet().iterator();
        }
    }
}

